/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.task;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class StructProjectFilterSchemeUpgradeTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(StructProjectFilterSchemeUpgradeTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        long startTime = System.currentTimeMillis();
        LOG.info("start to upgrade:");
        this.executeUpgrade();
        this.disableTask();
        LOG.info("end to upgrade cost {}ms", (Object)(System.currentTimeMillis() - startTime));
    }

    private void executeUpgrade() {
        HRBaseServiceHelper structureSchemeHelper = new HRBaseServiceHelper("homs_strprotofilter");
        structureSchemeHelper.deleteByFilter(new QFilter[]{new QFilter("structproject", "=", (Object)1010L)});
        HRBaseServiceHelper filterSchemeHelper = new HRBaseServiceHelper("bos_filterscheme");
        QFilter filter = new QFilter("form", "=", (Object)"homs_adminorgchart");
        DynamicObject[] filterSchemes = filterSchemeHelper.query("userid", new QFilter[]{filter});
        ArrayList<DynamicObject> structureSchemes = new ArrayList<DynamicObject>(filterSchemes.length);
        for (DynamicObject filterScheme : filterSchemes) {
            DynamicObject structureScheme = structureSchemeHelper.generateEmptyDynamicObject();
            structureScheme.set("scheme", filterScheme.getPkValue());
            structureScheme.set("user", (Object)filterScheme.getLong("userid.id"));
            structureScheme.set("structproject", (Object)1010L);
            structureSchemes.add(structureScheme);
        }
        structureSchemeHelper.save(structureSchemes.toArray(new DynamicObject[0]));
    }

    private void disableTask() {
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        scheduleManager.disableJob("3F+V=A0K+TDG");
        scheduleManager.disableSchedule("3F+VIBY=TKL8");
    }
}

