/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class AdminStructLongNumberUtils {
    private static final Log logger = LogFactory.getLog(AdminStructLongNumberUtils.class);
    private static final String STRUCT_PROJECT = "structproject";
    private static final String ADMINORG_BOID = "adminorg.boid";
    private static final HRBaseServiceHelper ADMIN_STRUCT_ORM = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey());
    private static final QFilter STRUCT_PROJECT_FILTER = new QFilter("structproject", "in", (Object)1010L);
    private static final QFilter CURRENT_VERSION_FILTER = new QFilter("iscurrentversion", "=", (Object)"1");
    private static final QFilter DATA_STATUS_FILTER = new QFilter("datastatus", "in", Arrays.asList("1", "2"));
    private static final DynamicObject EMPTY_DYNAMIC_OBJECT = ADMIN_STRUCT_ORM.generateEmptyDynamicObject();

    public static void sortBatchEntityByAdminStructLongNumber(List<DynamicObject> batchEntities, boolean isReverse) {
        if (batchEntities == null || batchEntities.isEmpty()) {
            return;
        }
        List adminOrgBoIds = batchEntities.stream().map(entity -> entity.getLong(ADMINORG_BOID)).collect(Collectors.toList());
        if (adminOrgBoIds.isEmpty()) {
            logger.info("empty adminOrgBoIds");
            return;
        }
        QFilter qFilter = new QFilter("adminorg", "in", adminOrgBoIds);
        if (EMPTY_DYNAMIC_OBJECT.containsProperty(STRUCT_PROJECT)) {
            logger.info("haos_adminorgstruct entity contains property structproject");
            qFilter.and(STRUCT_PROJECT_FILTER);
        }
        qFilter.and(CURRENT_VERSION_FILTER).and(DATA_STATUS_FILTER);
        DynamicObject[] query = ADMIN_STRUCT_ORM.query("adminorg.id,structlongnumber", new QFilter[]{qFilter});
        Map<Long, String> adminOrgId2StructLongNumber = Arrays.stream(query).collect(Collectors.toMap(dyn -> dyn.getLong("adminorg.id"), dyn -> dyn.getString("structlongnumber")));
        Collections.sort(batchEntities, (entry1, entry2) -> {
            int l2;
            String s1 = (String)adminOrgId2StructLongNumber.get(entry1.getLong(ADMINORG_BOID));
            String s2 = (String)adminOrgId2StructLongNumber.get(entry2.getLong(ADMINORG_BOID));
            int l1 = s1 != null ? s1.length() : 0;
            int n = l2 = s2 != null ? s2.length() : 0;
            if (isReverse) {
                return l2 - l1;
            }
            return l1 - l2;
        });
    }
}

