/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.util;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.hr.haos.business.domain.repository.orgteam.OTQueryRepository;
import kd.hr.haos.business.service.orgteam.OrgTeamSynService;
import kd.hr.haos.business.util.LocalDateRangeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

public class BatchSynOtUtils {
    public static List<DynamicObject> createOt4Save(List<DynamicObject> subOrgList, String numberPrefix) {
        return subOrgList.stream().map(subOrg -> BatchSynOtUtils.createOt4Save(subOrg, numberPrefix)).collect(Collectors.toList());
    }

    private static DynamicObject createOt4Save(DynamicObject subOrg, String numberPrefix) {
        DynamicObject newOt = OTQueryRepository.getInstance().genEmptyDy();
        HRDynamicObjectUtils.copy((DynamicObject)subOrg, (DynamicObject)newOt);
        OrgTeamSynService.getInstance().setOtType(newOt);
        new OrgTeamSynService().synOrgTeamBizFields(newOt, subOrg, numberPrefix);
        newOt.set("parent", (Object)subOrg.getDynamicObject("parentorg"));
        newOt.set("id", (Object)subOrg.getLong("id"));
        return newOt;
    }

    public static List<DynamicObject> createOt4Scene(List<DynamicObject> subTypeOrgList) {
        DynamicObjectType otDt = EntityMetadataCache.getSubDataEntityType((String)"haos_orgteamquery", Arrays.asList("id", "boid", "parentid", "bsed", "bsled", "structnumber", "enable", "billenable"));
        return subTypeOrgList.stream().map(subTypeOrg -> BatchSynOtUtils.createOt4Scene(subTypeOrg, otDt)).collect(Collectors.toList());
    }

    private static DynamicObject createOt4Scene(DynamicObject adOrg, DynamicObjectType otDt) {
        DynamicObject ot = new DynamicObject(otDt);
        ot.set("id", adOrg.get("id"));
        ot.set("boid", adOrg.get("boid"));
        ot.set("parentid", adOrg.get("parentorg.id"));
        ot.set("structnumber", adOrg.get("structnumber"));
        ot.set("bsed", adOrg.get("bsed"));
        ot.set("bsled", adOrg.get("bsled"));
        ot.set("enable", adOrg.get("enable"));
        return ot;
    }

    public static List<DynamicObject> createNewOt4SceneList(List<DynamicObject> otList) {
        return otList.stream().map(BatchSynOtUtils.createNewOt4Scene()).collect(Collectors.toList());
    }

    public static Function<DynamicObject, DynamicObject> createNewOt4Scene() {
        return ot -> {
            DynamicObject newOt = OTQueryRepository.getInstance().genEmptyDy(Arrays.asList("id", "boid", "parentid", "bsed", "bsled", "structnumber", "status", "enable", "initbatch", "initdatasource", "initstatus", "billenable"));
            newOt.set("id", (Object)ot.getLong("id"));
            newOt.set("boid", (Object)ot.getLong("boid"));
            newOt.set("parentid", (Object)ot.getLong("parent.id"));
            LocalDateRangeUtils.synEffectRange(ot, newOt);
            newOt.set("structnumber", ot.get("structnumber"));
            if (ot.getString("enable") != null) {
                newOt.set("enable", ot.get("enable"));
            } else {
                newOt.set("enable", (Object)"1");
            }
            newOt.set("status", ot.get("status"));
            newOt.set("initstatus", ot.get("initstatus"));
            newOt.set("initbatch", ot.get("initbatch"));
            newOt.set("initdatasource", ot.get("initdatasource"));
            return newOt;
        };
    }

    public static List<DynamicObject> createNewOt4SaveList(List<DynamicObject> otList) {
        return otList.stream().map(dy -> {
            DynamicObject newDy = new DynamicObject(dy.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)dy, (DynamicObject)newDy);
            newDy.set("id", dy.get("id"));
            newDy.set("iscurrentversion", (Object)"1");
            return newDy;
        }).collect(Collectors.toList());
    }

    public static List<DynamicObject> createNewOt4SaveListPure(List<DynamicObject> otList) {
        return otList.stream().map(dy -> {
            DynamicObject newDy = new DynamicObject(dy.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)dy, (DynamicObject)newDy);
            newDy.set("id", dy.get("id"));
            return newDy;
        }).collect(Collectors.toList());
    }
}

