/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.hr.haos.business.util.DirectedGraph;

public class CycleDetector<T> {
    private static final String MARKED = "marked";
    private static final String COMPLETE = "complete";
    private DirectedGraph<T> graph;
    private Map<T, String> marks;
    private List<List<T>> verticesInCycles;

    public CycleDetector(DirectedGraph<T> graph) {
        this.graph = graph;
        this.marks = new HashMap<T, String>();
        this.verticesInCycles = new ArrayList<List<T>>();
    }

    public boolean containsCycle() {
        for (T value : this.graph) {
            if (this.marks.containsKey(value)) continue;
            LinkedHashSet set = new LinkedHashSet();
            this.mark(value, set);
        }
        return !this.verticesInCycles.isEmpty();
    }

    private boolean mark(T vertex, Set<T> set) {
        if (COMPLETE.equals(this.marks.get(vertex))) {
            return true;
        }
        this.marks.put(vertex, MARKED);
        if (!set.add(vertex)) {
            List<T> localCycles = this.getCyclyLine(vertex, set);
            this.verticesInCycles.add(localCycles);
            return true;
        }
        for (T ux : this.graph.edgesFrom(vertex)) {
            this.mark(ux, new LinkedHashSet<T>(set));
        }
        this.marks.put(vertex, COMPLETE);
        return false;
    }

    private List<T> getCyclyLine(T vertex, Set<T> set) {
        ArrayList<T> localCycles = new ArrayList<T>(set.size() + 1);
        boolean flag = true;
        for (T tex : set) {
            if (flag && !tex.equals(vertex)) continue;
            if (flag) {
                flag = false;
            }
            localCycles.add(tex);
        }
        localCycles.add(vertex);
        return localCycles;
    }

    public List<List<T>> getVerticesInCycles() {
        return this.verticesInCycles;
    }
}

