/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.util;

import java.util.Date;
import java.util.Map;
import kd.hr.haos.business.util.TimeConvertUtil;
import kd.hr.haos.common.model.MainPersonModel;

public class HisMainPeopleHelper {
    private static final String START_DATE = "effdt";
    private static final String HEAD_SCULPTURE = "headsculpture";
    private static final String END_DATE = "leffdt";
    private static final String POS_TYPE = "postype";
    private static final String POS_TYPE_ID = "postype.id";
    private static final String LABOR_REL_STATUS = "laborrelstatus";
    private static final String LABOR_REL_TYPE = "laborreltype";
    private static final String POS_NAME = "position";
    private static final String IS_PRIMARY = "isprimary";
    private static final String STAND_POSITION = "stdposition";
    private static final String DEFAULT_VALUE = "";
    private static final long DEFAULT_ZERO_VALUE = 0L;
    private static final boolean DEFAULT_FALSE_VALUE = false;

    public static MainPersonModel convert(Map<String, Object> map) {
        return HisMainPeopleHelper.convert(map, false);
    }

    public static MainPersonModel convertMinusEndDate(Map<String, Object> map) {
        return HisMainPeopleHelper.convert(map, true);
    }

    private static MainPersonModel convert(Map<String, Object> map, boolean minusEndDate) {
        String endDate;
        MainPersonModel mainPersonModel = new MainPersonModel();
        String startDate = (String)map.get(START_DATE);
        if (startDate != null) {
            mainPersonModel.setStartDate(TimeConvertUtil.longToLocalDateTime(Long.parseLong(startDate)));
        }
        if ((endDate = (String)map.get(END_DATE)) != null) {
            if (minusEndDate) {
                mainPersonModel.setEndDate(TimeConvertUtil.longToLocalDateTime(Long.parseLong(endDate)).minusDays(1L));
            } else {
                mainPersonModel.setEndDate(TimeConvertUtil.longToLocalDateTime(Long.parseLong(endDate)));
            }
        }
        mainPersonModel.setHeadSculpture((String)map.getOrDefault(HEAD_SCULPTURE, DEFAULT_VALUE));
        mainPersonModel.setPersonName((String)map.getOrDefault("name", DEFAULT_VALUE));
        mainPersonModel.setPersonNumber((String)map.getOrDefault("number", DEFAULT_VALUE));
        mainPersonModel.setPosType((String)map.getOrDefault(POS_TYPE, DEFAULT_VALUE));
        mainPersonModel.setLaborRelStatus((String)map.getOrDefault(LABOR_REL_STATUS, DEFAULT_VALUE));
        mainPersonModel.setLaborRelType((String)map.getOrDefault(LABOR_REL_TYPE, DEFAULT_VALUE));
        mainPersonModel.setPosName((String)map.getOrDefault(POS_NAME, DEFAULT_VALUE));
        mainPersonModel.setStdPosName((String)map.getOrDefault(STAND_POSITION, DEFAULT_VALUE));
        mainPersonModel.setPrimary(Boolean.parseBoolean(map.getOrDefault(IS_PRIMARY, "false").toString()));
        mainPersonModel.setPersonId(Long.valueOf(Long.parseLong(map.get("person").toString())));
        Object posTypeIdVal = map.get(POS_TYPE_ID);
        String posTypeId = posTypeIdVal == null ? "0" : posTypeIdVal.toString();
        mainPersonModel.setPosTypeId(posTypeId != null ? Long.parseLong(posTypeId) : 0L);
        return mainPersonModel;
    }

    public static void resetDateField(Map<String, Object> map) {
        Date endDate;
        Date startDate = (Date)map.get(START_DATE);
        if (startDate != null) {
            map.put(START_DATE, String.valueOf(startDate.getTime()));
        }
        if ((endDate = (Date)map.get(END_DATE)) != null) {
            map.put(END_DATE, String.valueOf(endDate.getTime()));
        }
    }
}

