/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.util;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.util.DynamicObjectLogHelper;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;

public class LogUtil {
    private final Log logger;
    public static final String[] HIS_CHECK_FIELDS = new String[]{"id", "boid", "bsed", "bsled"};

    public LogUtil(Log logger) {
        this.logger = logger;
    }

    public void logger(String message, Object ... args) {
        block4: {
            try {
                for (int i = 0; i < args.length; ++i) {
                    message = message.replaceFirst("\\{}", "{" + i + "}");
                }
                String logStr = MessageFormat.format(message, args);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(logStr);
                }
            }
            catch (Exception e) {
                String logStr = message + Arrays.toString(args);
                if (!this.logger.isInfoEnabled()) break block4;
                this.logger.info(logStr);
            }
        }
    }

    public void error(String message, Throwable throwable) {
        this.logger.error(message, throwable);
    }

    public void error(Throwable throwable) {
        this.logger.error(throwable);
    }

    public void error(String message) {
        this.logger.error(message);
    }

    public void infoIfEnabled(Supplier<String> messageSupplier) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(messageSupplier.get());
        }
    }

    public void infoHisVersion(List<HisVersionParamBo> hisVersionParamBoList) {
        if (!this.logger.isInfoEnabled()) {
            return;
        }
        try {
            if (!CollectionUtils.isEmpty(hisVersionParamBoList)) {
                hisVersionParamBoList.forEach(this::infoHisVersion);
            } else {
                this.logger.info("hisVersionParamBoList is null or size is zero");
            }
        }
        catch (Exception e) {
            this.logger.info(String.format("log fail, exception: %s", e));
        }
    }

    private void infoHisVersion(HisVersionParamBo hisVersionParamBo) {
        if (hisVersionParamBo == null) {
            this.logger.info("hisVersionParamBo is null");
        } else if (hisVersionParamBo.getHisDyns() == null) {
            this.logger.info("hisVersionParamBo's hisDyns is null");
        } else {
            this.infoHisDynamicObject(Arrays.asList(hisVersionParamBo.getHisDyns()));
        }
    }

    public void infoHisDynamicObject(List<DynamicObject> dynamicObjectList) {
        if (!this.logger.isInfoEnabled()) {
            return;
        }
        try {
            if (CollectionUtils.isEmpty(dynamicObjectList)) {
                this.logger.info("dynamicObjectList is null or size is zero");
            } else {
                this.logger.info(String.format("dynamicObject type: %s, value: %s", dynamicObjectList.get(0).getDynamicObjectType().getName(), DynamicObjectLogHelper.convertDynamicObject2Map(dynamicObjectList, HIS_CHECK_FIELDS)));
            }
        }
        catch (Exception e) {
            this.logger.info(String.format("log fail, exception: %s", e));
        }
    }
}

