/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.util;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.adorg.AdminOrgStructRepository;
import kd.hr.haos.business.domain.repository.orgteam.OTStructRepository;
import kd.hr.haos.business.service.otherstruct.model.OtherStructEntity;
import kd.hr.haos.business.service.otherstruct.model.OtherStructVO;
import kd.hr.haos.business.util.LocalDateRangeUtils;
import kd.hr.haos.common.constants.changetransaction.ChangeTransactionConstants;
import kd.hr.haos.common.util.LocalDateRange;
import kd.hr.haos.common.util.OrgDateTimeUtil;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

public class OtherStructSplitUtil {
    public static void addStatusChangeList(OtherStructEntity otherStructEntity, List<DynamicObject> structList, boolean otFlag) {
        DynamicObject[] statusChangeArray;
        String propertyName;
        Set<Long> statusChangeSet = otherStructEntity.getStatusChangeOrg();
        if (CollectionUtils.isEmpty(statusChangeSet)) {
            return;
        }
        Date effectDate = otherStructEntity.getEffectDate();
        if (otFlag) {
            propertyName = "orgteam.id";
            statusChangeArray = OTStructRepository.getInstance().loadByOrgDateStructId(statusChangeSet, effectDate, OrgDateTimeUtil.BSLED, otherStructEntity.getStructProjectId());
        } else {
            statusChangeArray = AdminOrgStructRepository.getInstance().loadByOrgDateStructId(statusChangeSet, effectDate, OrgDateTimeUtil.BSLED, otherStructEntity.getStructProjectId());
            propertyName = "adminorg.id";
        }
        Set enableOrgSet = otherStructEntity.getOtherStructByType(ChangeTransactionConstants.INFO).stream().map(OtherStructVO::getOrgId).collect(Collectors.toSet());
        List statusChangeList = Arrays.stream(statusChangeArray).map(dy -> {
            DynamicObject newDy = new DynamicObject(dy.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)dy, (DynamicObject)newDy);
            newDy.set("enable", (Object)(enableOrgSet.contains(dy.getLong(propertyName)) ? "1" : "0"));
            if (newDy.getDate("bsed").compareTo(effectDate) < 0) {
                newDy.set("bsed", (Object)effectDate);
            }
            newDy.set("id", (Object)dy.getLong("id"));
            return newDy;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(structList)) {
            structList.addAll(statusChangeList);
            return;
        }
        Map<Long, List<DynamicObject>> structMap = structList.stream().collect(Collectors.groupingBy(dyn -> dyn.getLong("id")));
        for (DynamicObject statusChangeDy : statusChangeList) {
            List<DynamicObject> subStructList = structMap.get(statusChangeDy.getLong("id"));
            if (CollectionUtils.isEmpty(subStructList)) {
                structList.add(statusChangeDy);
                continue;
            }
            LocalDateRange statusChgDateRange = LocalDateRangeUtils.getEffectRange(statusChangeDy);
            List subList = subStructList.stream().map(idStruct -> {
                idStruct.set("enable", (Object)statusChangeDy.getString("enable"));
                return LocalDateRangeUtils.getEffectRange(idStruct);
            }).collect(Collectors.toList());
            List subtractList = statusChgDateRange.subtract(subList);
            subtractList.forEach(subtract -> {
                DynamicObject newDy = new DynamicObject(statusChangeDy.getDynamicObjectType());
                HRDynamicObjectUtils.copy((DynamicObject)statusChangeDy, (DynamicObject)newDy);
                LocalDateRangeUtils.setEffectRange(newDy, subtract);
                structList.add(newDy);
            });
        }
    }

    public static List<DynamicObject> splitStructAndSetHisId(List<DynamicObject> orgTeamDyList, List<DynamicObject> structDyList) {
        return OtherStructSplitUtil.splitStructAndSetHisId(orgTeamDyList, structDyList, false);
    }

    public static List<DynamicObject> splitStructAndSetHisId(List<DynamicObject> orgTeamDyList, List<DynamicObject> structDyList, boolean returnFlag) {
        Map<Long, List<DynamicObject>> structMap = structDyList.stream().collect(Collectors.groupingBy(struct -> struct.getLong("orgteam.id")));
        for (DynamicObject orgTeamDy : orgTeamDyList) {
            List<DynamicObject> list = structMap.get(orgTeamDy.getLong("boid"));
            if (CollectionUtils.isEmpty(list)) {
                if (!returnFlag) continue;
                throw new KDBizException("no find struct data---orgTeamId=" + orgTeamDy.getLong("boid"));
            }
            OtherStructSplitUtil.splitStructAndSetHisId(orgTeamDy, list, returnFlag);
        }
        return structMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static void splitStructAndSetHisId(DynamicObject orgTeamDy, List<DynamicObject> structDyList, boolean returnFlag) {
        LocalDateRange effectRange = LocalDateRangeUtils.getEffectRange(orgTeamDy);
        ListIterator<DynamicObject> it = structDyList.listIterator();
        while (it.hasNext()) {
            DynamicObject structDy = it.next();
            LocalDateRange structEffectRange = LocalDateRangeUtils.getEffectRange(structDy);
            if (!structEffectRange.overlaps(effectRange)) continue;
            if (effectRange.encloses(structEffectRange)) {
                structDy.set("orgteamhisid", (Object)orgTeamDy.getLong("id"));
                continue;
            }
            OtherStructSplitUtil.splitStructData(it, structDy, effectRange, structEffectRange);
            structDy.set("orgteamhisid", (Object)orgTeamDy.getLong("id"));
            if (structEffectRange.encloses(effectRange)) {
                LocalDateRangeUtils.setEffectRange(structDy, effectRange);
                if (!returnFlag) continue;
                return;
            }
            LocalDateRangeUtils.setEffectRange(structDy, structEffectRange.intersection(effectRange));
        }
    }

    private static void splitStructData(ListIterator<DynamicObject> it, DynamicObject structDy, LocalDateRange effectRange, LocalDateRange structEffectRange) {
        List<LocalDateRange> list = OtherStructSplitUtil.splitEffectRange(effectRange, structEffectRange);
        for (LocalDateRange dateRange : list) {
            DynamicObject newDy = new DynamicObject(structDy.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)structDy, (DynamicObject)newDy);
            LocalDateRangeUtils.setEffectRange(newDy, dateRange);
            it.add(newDy);
        }
    }

    private static List<LocalDateRange> splitEffectRange(LocalDateRange effectRange, LocalDateRange structEffectRange) {
        ArrayList<LocalDateRange> list = new ArrayList<LocalDateRange>(2);
        if (structEffectRange.getStart().compareTo(effectRange.getStart()) < 0) {
            list.add(LocalDateRange.of((LocalDate)structEffectRange.getStart(), (LocalDate)effectRange.getStart()));
        }
        if (structEffectRange.getEnd().compareTo(effectRange.getEnd()) > 0) {
            list.add(LocalDateRange.of((LocalDate)effectRange.getEnd(), (LocalDate)structEffectRange.getEnd()));
        }
        return list;
    }
}

