/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import kd.bos.service.KDDateUtils;

public class TimeConvertUtil {
    public static DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public static LocalDate date2LocalDate(Date date) {
        if (date == null) {
            return null;
        }
        return ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).toLocalDate();
    }

    public static Date localDate2Date(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        return Date.from(ZonedDateTime.of(localDate, LocalTime.MIN, ZoneId.systemDefault()).toInstant());
    }

    public static Date localDateTime2Date(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        return Date.from(ZonedDateTime.of(localDateTime.toLocalDate(), LocalTime.MIN, ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate longToLocalDate(long epochMill) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochMill), ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime longToLocalDateTime(long epochMill) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochMill), ZoneId.systemDefault()).toLocalDateTime();
    }

    public static ZonedDateTime nowUserZonedDateTime() {
        return TimeConvertUtil.toUserZonedDateTime(ZonedDateTime.now());
    }

    public static ZonedDateTime nowUserZonedDateTimeWithoutTime() {
        return TimeConvertUtil.nowUserZonedDateTime().truncatedTo(ChronoUnit.DAYS);
    }

    public static ZonedDateTime toUserZonedDateTime(LocalDateTime localDateTime) {
        return TimeConvertUtil.toUserZonedDateTime(ZonedDateTime.of(localDateTime, ZoneId.systemDefault()));
    }

    public static ZonedDateTime toUserZonedDateTimeWithoutTime(LocalDateTime localDateTime) {
        return TimeConvertUtil.toUserZonedDateTime(localDateTime).truncatedTo(ChronoUnit.DAYS);
    }

    public static ZonedDateTime toUserZonedDateTime(ZonedDateTime systemZonedDateTime) {
        return systemZonedDateTime.withZoneSameInstant(KDDateUtils.getSysTimeZone().toZoneId());
    }

    public static String toDateString(ZonedDateTime zonedDateTime) {
        return dateTimeFormatter.format(zonedDateTime);
    }

    public static int getYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static Date getMinDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        calendar.clear();
        calendar.set(1, year);
        calendar.set(2, calendar.getActualMinimum(2));
        calendar.set(5, calendar.getActualMinimum(5));
        return calendar.getTime();
    }

    public static Date getMaxDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        calendar.clear();
        calendar.set(1, year);
        calendar.set(2, calendar.getActualMaximum(2));
        calendar.set(5, calendar.getActualMaximum(5));
        calendar.set(10, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    public static Date getNowDate() {
        LocalDate now = LocalDate.now();
        return Date.from(now.atTime(LocalTime.MIDNIGHT).atZone(KDDateUtils.getSysTimeZone().toZoneId()).toInstant());
    }
}

