/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.util;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class TimeLogger {
    private static final Log LOGGER = LogFactory.getLog(TimeLogger.class);
    private long start;
    private long last;

    private TimeLogger() {
    }

    public static TimeLogger create() {
        return new TimeLogger();
    }

    public void start() {
        LOGGER.info("TimeCounter_start");
        this.last = this.start = System.currentTimeMillis();
    }

    public void startForError() {
        LOGGER.error("TimeCounter_start");
        this.last = this.start = System.currentTimeMillis();
    }

    public void check(String message) {
        long curLast = System.currentTimeMillis();
        LOGGER.info(message + TimeLogger.getCostMessage(curLast - this.last));
        this.last = curLast;
    }

    public void checkForError(String message) {
        long curLast = System.currentTimeMillis();
        LOGGER.error(message + TimeLogger.getCostMessage(curLast - this.last));
        this.last = curLast;
    }

    public void end() {
        LOGGER.info("TimeCounter_end" + TimeLogger.getCostMessage(System.currentTimeMillis() - this.start));
    }

    public void endForError() {
        LOGGER.error("TimeCounter_end" + TimeLogger.getCostMessage(System.currentTimeMillis() - this.start));
    }

    private static String getCostMessage(long cost) {
        return String.format(" cost: %sms", cost);
    }
}

