/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.util.coderule;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.haos.business.domain.repository.prjorg.PRJOrgRepository;
import kd.hr.haos.common.model.coderule.HAOSCodeRuleModel;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class ProjectGroupCodeRuleHelper {
    public static boolean isExist(HAOSCodeRuleModel model) {
        return CodeRuleServiceHelper.isExist((String)model.getEntityNumber(), (DynamicObject)ProjectGroupCodeRuleHelper.getEmptyDataInfo(model), (String)model.getOrgId());
    }

    public static boolean isModify(HAOSCodeRuleModel model) {
        return CodeRuleServiceHelper.isModifiable((String)model.getEntityNumber(), (DynamicObject)ProjectGroupCodeRuleHelper.getEmptyDataInfo(model), (String)model.getOrgId());
    }

    public static String[] getBatchNumber(HAOSCodeRuleModel model, int count) {
        String[] batchNumber;
        try {
            batchNumber = CodeRuleServiceHelper.getBatchNumber((String)model.getEntityNumber(), (DynamicObject)ProjectGroupCodeRuleHelper.getEmptyDataInfo(model), (String)model.getOrgId(), (int)count);
        }
        catch (KDException e) {
            throw new KDBizException(e.getMessage());
        }
        return batchNumber;
    }

    public static void recycleNumber(HAOSCodeRuleModel model, boolean collectAll) {
        String[] numbers = ProjectGroupCodeRuleHelper.getNeed2RecycleNumbers(model, collectAll);
        if ((numbers = ProjectGroupCodeRuleHelper.removeExist(numbers)) != null && numbers.length > 0) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(model.getEntityNumber());
            DynamicObject[] dynamicObjects = new DynamicObject[numbers.length];
            for (int i = 0; i < numbers.length; ++i) {
                DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
                dynamicObject.set("number", (Object)numbers[i]);
                dynamicObject.set("org", (Object)model.getOrgId());
                dynamicObjects[i] = dynamicObject;
            }
            CodeRuleServiceHelper.recycleBatchNumber((String)model.getEntityNumber(), (DynamicObject[])dynamicObjects, (String)model.getOrgId(), (String[])numbers);
        }
    }

    private static String[] removeExist(String[] numbers) {
        if (numbers != null && numbers.length != 0) {
            Set<String> numberSet = Arrays.stream(numbers).collect(Collectors.toSet());
            DynamicObject[] projectRoles = PRJOrgRepository.getInstance().queryOriginalByNumberAndCurrentVersion("number", numberSet);
            Arrays.stream(projectRoles).forEach(dy -> numberSet.remove(dy.getString("number")));
            return numberSet.toArray(new String[0]);
        }
        return numbers;
    }

    private static String[] getNeed2RecycleNumbers(HAOSCodeRuleModel model, boolean recycleAll) {
        String[] numbers = model.getNumbers();
        if (numbers != null && numbers.length > 0) {
            if (recycleAll) {
                return numbers;
            }
            return ProjectGroupCodeRuleHelper.getUnusedNumbers(model.getCurrentNumbers(), numbers);
        }
        return new String[0];
    }

    private static String[] getUnusedNumbers(String[] currentNumbers, String[] numbers) {
        if (currentNumbers != null && currentNumbers.length > 0) {
            Set<String> numberSet = Arrays.stream(numbers).collect(Collectors.toSet());
            numberSet.removeAll(Arrays.asList(currentNumbers));
            return numberSet.toArray(new String[0]);
        }
        return numbers;
    }

    public static DynamicObject getEmptyDataInfo(HAOSCodeRuleModel model) {
        return model.getDy() != null ? model.getDy() : new HRBaseServiceHelper(model.getEntityNumber()).generateEmptyDynamicObject();
    }
}

