/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.mservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.common.constants.structproject.StructProjectConstants;
import kd.hr.haos.mservice.api.IHAOSBatchAdminOrgInfoService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class HAOSBatchAdminOrgInfoService
implements IHAOSBatchAdminOrgInfoService {
    private static final Log LOGGER = LogFactory.getLog(HAOSBatchAdminOrgInfoService.class);
    List<String> changeFieldList = Arrays.asList("number", "name", "parentorg", "enable");

    public Map<String, Object> batchGetChangeAdminOrgInfoByDate(Date startDateTime, Date endDateTime, int start, int limit) {
        HashMap returnDataMap = Maps.newHashMapWithExpectedSize((int)2);
        if (limit > 5000) {
            returnDataMap.put("isover", false);
            returnDataMap.put("data", new ArrayList(0));
            returnDataMap.put("errorMsg", "The number of queries is less than 5000.");
            return returnDataMap;
        }
        ArrayList list = Lists.newArrayListWithExpectedSize((int)100);
        this.buildModelExcludeNew(startDateTime, endDateTime, list);
        this.buildModeForNew(startDateTime, endDateTime, list);
        Map<Long, Date> idVsOperateTimeMap = list.stream().filter(model -> model.getDate() != null).collect(Collectors.toMap(model -> model.getId(), model -> model.getDate(), (oldV, newV) -> newV));
        List<DynamicObject> adminOrgDynList = this.queryAdminOrgAndSorted(list);
        ArrayList returnList = Lists.newArrayListWithExpectedSize((int)list.size());
        for (int i = start; i < start + limit && i < adminOrgDynList.size(); ++i) {
            DynamicObject adminOrgDyn = adminOrgDynList.get(i);
            HashMap dataMap = Maps.newHashMapWithExpectedSize((int)7);
            long id = adminOrgDyn.getLong("id");
            dataMap.put("id", id);
            dataMap.put("number", adminOrgDyn.getString("number"));
            dataMap.put("name", adminOrgDyn.getLocaleString("name"));
            dataMap.put("parentorg", Objects.isNull(adminOrgDyn) ? 0L : adminOrgDyn.getLong("parentorg.id"));
            dataMap.put("establishmentdate", adminOrgDyn.getDate("establishmentdate"));
            dataMap.put("bsed", adminOrgDyn.getDate("bsed"));
            dataMap.put("enable", adminOrgDyn.getString("enable"));
            dataMap.put("operatetime", idVsOperateTimeMap.get(id));
            dataMap.put("isvirtualorg", adminOrgDyn.getString("isvirtualorg"));
            returnList.add(dataMap);
        }
        returnDataMap.put("isover", adminOrgDynList.size() <= start + limit);
        returnDataMap.put("data", returnList);
        return returnDataMap;
    }

    private List<DynamicObject> queryAdminOrgAndSorted(List<Model> list) {
        list.sort((o1, o2) -> {
            Date dateTimeo2;
            Date dateTimeo1 = o1.getDate();
            int i = dateTimeo1.compareTo(dateTimeo2 = o2.getDate());
            if (i == 0) {
                Integer o1Level = o1.getLevel();
                Integer o2Level = o2.getLevel();
                i = o1Level.compareTo(o2Level);
            }
            return i;
        });
        List idList = list.stream().map(model -> model.getId()).collect(Collectors.toList());
        AtomicInteger index = new AtomicInteger();
        Map<Long, Integer> idVsIndexMap = idList.stream().collect(Collectors.toMap(id -> id, id -> index.getAndIncrement()));
        HRBaseServiceHelper adminOrgHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter idFilter = new QFilter("id", "in", idList);
        DynamicObject[] adminOrgDynsForResult = adminOrgHelper.query("id, number, name, parentorg, establishmentdate, bsed, enable,isvirtualorg", new QFilter[]{idFilter});
        List<DynamicObject> adminOrgDynList = Arrays.stream(adminOrgDynsForResult).collect(Collectors.toList());
        adminOrgDynList.sort((o1, o2) -> {
            long id1 = o1.getLong("id");
            long id2 = o2.getLong("id");
            Integer index1 = (Integer)idVsIndexMap.get(id1);
            Integer index2 = (Integer)idVsIndexMap.get(id2);
            return index1 - index2;
        });
        return adminOrgDynList;
    }

    private void buildModeForNew(Date startDateTime, Date endDateTime, List<Model> list) {
        HRBaseServiceHelper changeTranSumhelper = new HRBaseServiceHelper("haos_changetransum");
        QFilter createTimeFilter = new QFilter("createtime", ">=", (Object)startDateTime);
        createTimeFilter.and("createtime", "<", (Object)endDateTime);
        Long[] changetypeNum = new Long[]{1010L, 1060L};
        QFilter changeTypeForNewFilter = new QFilter("orgchangetype.orgchangetype", "in", (Object)changetypeNum);
        DynamicObject[] changeTransumDyns = changeTranSumhelper.query("afterorg, createtime", new QFilter[]{createTimeFilter, changeTypeForNewFilter});
        List idList = Arrays.stream(changeTransumDyns).map(dyn -> dyn.getLong("afterorg")).collect(Collectors.toList());
        HRBaseServiceHelper adminOrgHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter idFilter = new QFilter("id", "in", idList);
        DynamicObject[] adminOrgDyns = adminOrgHelper.query("id, boid", new QFilter[]{idFilter});
        Map<Long, Long> idVsBoIdMap = Arrays.stream(adminOrgDyns).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getLong("boid")));
        HRBaseServiceHelper adminOrgStructHelper = new HRBaseServiceHelper("haos_adminorgstruct");
        QFilter adminOrgFilter = new QFilter("adminorg", "in", idVsBoIdMap.values());
        adminOrgFilter.and((QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get());
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        DynamicObject[] adminOrgStructForNewDyns = adminOrgStructHelper.query("adminorg, createtime, level", new QFilter[]{adminOrgFilter, isCurrentVersionFilter});
        Map<Long, List<DynamicObject>> boidVsStructDynListMap = Arrays.stream(adminOrgStructForNewDyns).collect(Collectors.groupingBy(dyn -> dyn.getLong("adminorg.id")));
        Set<Map.Entry<Long, List<DynamicObject>>> boidVsStructDynListEntries = boidVsStructDynListMap.entrySet();
        HashMap boIdVsLevelMap = Maps.newHashMapWithExpectedSize((int)boidVsStructDynListEntries.size());
        for (Map.Entry<Long, List<DynamicObject>> boidVsStructDynListEntry : boidVsStructDynListEntries) {
            DynamicObject earlyCreateTimeDyn = null;
            List<DynamicObject> structDynList = boidVsStructDynListEntry.getValue();
            for (DynamicObject structDyn : structDynList) {
                Date createTime;
                if (null == earlyCreateTimeDyn) {
                    earlyCreateTimeDyn = structDyn;
                    continue;
                }
                Date earlyCreateTime = earlyCreateTimeDyn.getDate("createtime");
                if (!HRDateTimeUtils.dayBefore((Date)earlyCreateTime, (Date)(createTime = structDyn.getDate("createtime")))) continue;
                earlyCreateTimeDyn = structDyn;
            }
            if (null == earlyCreateTimeDyn) continue;
            boIdVsLevelMap.put(earlyCreateTimeDyn.getLong("adminorg.id"), earlyCreateTimeDyn.getInt("level"));
        }
        Arrays.stream(changeTransumDyns).forEach(dyn -> {
            long id = dyn.getLong("afterorg");
            Date createtime = dyn.getDate("createtime");
            Long boid = (Long)idVsBoIdMap.get(id);
            if (boid == null) {
                return;
            }
            Integer level = (Integer)boIdVsLevelMap.get(boid);
            list.add(new Model(id, createtime, level));
        });
    }

    private List<Model> buildModelExcludeNew(Date startDateTime, Date endDateTime, List<Model> list) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("homs_orgchgrecord");
        List<Long> changeTypeList = Arrays.asList(1020L, 1030L, 1040L, 1070L);
        QFilter changeTypeFilter = new QFilter("orgchgentry.changetype", "in", changeTypeList);
        changeTypeFilter.and("orgchgentry.subentryentity.chgpageelement", "in", this.changeFieldList);
        QFilter dateFilter = new QFilter("orgchgentry.operationtime", ">=", (Object)startDateTime);
        dateFilter.and("orgchgentry.operationtime", "<", (Object)endDateTime);
        DynamicObject[] orgChgRecordDyns = hrBaseServiceHelper.loadDynamicObjectArray(new QFilter[]{dateFilter, changeTypeFilter});
        HashSet changeBillIdSet = Sets.newHashSetWithExpectedSize((int)orgChgRecordDyns.length);
        HashSet adminOrgHisIdSet = Sets.newHashSetWithExpectedSize((int)orgChgRecordDyns.length);
        for (DynamicObject orgChgRecordDyn : orgChgRecordDyns) {
            DynamicObject orgchgEntry;
            Date operationTime;
            DynamicObjectCollection orgchgEntryCol = orgChgRecordDyn.getDynamicObjectCollection("orgchgentry");
            Iterator iterator = orgchgEntryCol.iterator();
            while (iterator.hasNext() && !Objects.isNull(operationTime = (orgchgEntry = (DynamicObject)iterator.next()).getDate("operationtime"))) {
                DynamicObjectCollection subEntryEntityCol;
                List<String> chgPageElementList;
                long chagneTypeId = orgchgEntry.getLong("changetype.id");
                if (!HRDateTimeUtils.dayBefore((Date)operationTime, (Date)endDateTime) || !HRDateTimeUtils.dayAfter((Date)operationTime, (Date)startDateTime) || !changeTypeList.contains(chagneTypeId) || !this.isContainsChangeField(chgPageElementList = (subEntryEntityCol = orgchgEntry.getDynamicObjectCollection("subentryentity")).stream().map(subEntryEntity -> subEntryEntity.getString("chgpageelement")).collect(Collectors.toList()))) continue;
                changeBillIdSet.add(orgchgEntry.getLong("chgbill.id"));
                adminOrgHisIdSet.addAll(subEntryEntityCol.stream().map(dyn -> dyn.getLong("afterchgentity")).collect(Collectors.toSet()));
            }
        }
        HRBaseServiceHelper batchOrgEntityHelper = new HRBaseServiceHelper("homs_batchorgentity");
        QFilter billIdFilterForEntry = new QFilter("billid", "in", (Object)changeBillIdSet);
        DynamicObject[] batchOrgEntityDyns = batchOrgEntityHelper.query("id, billid, changetype, afterbaseinfoid, afterstructid", new QFilter[]{billIdFilterForEntry});
        Map<Long, Long> idVsBillIdMap = Arrays.stream(batchOrgEntityDyns).filter(dyn -> adminOrgHisIdSet.contains(dyn.getLong("afterbaseinfoid"))).collect(Collectors.toMap(dyn -> dyn.getLong("afterbaseinfoid"), dyn -> dyn.getLong("billid")));
        HRBaseServiceHelper orgBatchChgBillHelper = new HRBaseServiceHelper("homs_orgbatchchgbill");
        QFilter billIdFilterForBill = new QFilter("id", "in", (Object)changeBillIdSet);
        DynamicObject[] orgBatchChgBillDyns = orgBatchChgBillHelper.query("id, modifytime", new QFilter[]{billIdFilterForBill});
        Map<Long, Date> billIdVsModifyTimeMap = Arrays.stream(orgBatchChgBillDyns).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getDate("modifytime")));
        Map<Long, Long> idVsAfterStructIdMap = Arrays.stream(batchOrgEntityDyns).filter(dyn -> adminOrgHisIdSet.contains(dyn.getLong("afterbaseinfoid"))).collect(Collectors.toMap(dyn -> dyn.getLong("afterbaseinfoid"), dyn -> dyn.getLong("afterstructid")));
        HRBaseServiceHelper adminOrgStructHelper = new HRBaseServiceHelper("haos_adminorgstruct");
        QFilter structIdFilter = new QFilter("id", "in", idVsAfterStructIdMap.values());
        structIdFilter.and((QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get());
        DynamicObject[] adminOrgStructDyns = adminOrgStructHelper.query("id, level", new QFilter[]{structIdFilter});
        Map<Long, Integer> structIdVsLevelMap = Arrays.stream(adminOrgStructDyns).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getInt("level")));
        Arrays.stream(batchOrgEntityDyns).forEach(dyn -> {
            long id = dyn.getLong("afterbaseinfoid");
            Long billId = (Long)idVsBillIdMap.get(id);
            if (billId == null) {
                return;
            }
            Date modifyTime = (Date)billIdVsModifyTimeMap.get(billId);
            Long structId = (Long)idVsAfterStructIdMap.get(id);
            Integer level = (Integer)structIdVsLevelMap.get(structId);
            list.add(new Model(id, modifyTime, level));
        });
        return list;
    }

    public Map<String, Object> queryAllAdminOrgInfo(int start, int limit) {
        HashMap returnDataMap = Maps.newHashMapWithExpectedSize((int)2);
        if (limit > 5000) {
            returnDataMap.put("isover", false);
            returnDataMap.put("data", new ArrayList(0));
            returnDataMap.put("errorMsg", "The number of queries is less than 5000.");
            return returnDataMap;
        }
        HRBaseServiceHelper adminOrgStructHelper = new HRBaseServiceHelper("haos_adminorgstructquery");
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter dataStatusFilter = new QFilter("datastatus", "!=", (Object)EventOperateEnums.CHANGE_BEFORE_STATUS_TEMP.getValue());
        String selectField = "level,haos_adminorgdetail.id,haos_adminorgdetail.number,haos_adminorgdetail.name,haos_adminorgdetail.parentorg.id,haos_adminorgdetail.establishmentdate,haos_adminorgdetail.bsed,haos_adminorgdetail.enable,haos_adminorgdetail.isvirtualorg";
        int count = 0;
        ArrayList list = Lists.newArrayListWithExpectedSize((int)limit);
        try (DataSet dataSet = adminOrgStructHelper.queryMultiEntityDataSet(selectField, new QFilter[]{versionFilter, dataStatusFilter}, "level", true, start, limit + 1);){
            while (dataSet.hasNext()) {
                Row org = dataSet.next();
                if (++count > limit) continue;
                HashMap dataMap = Maps.newHashMapWithExpectedSize((int)8);
                dataMap.put("id", org.getLong("haos_adminorgdetail.id"));
                dataMap.put("number", org.getString("haos_adminorgdetail.number"));
                dataMap.put("name", org.getString("haos_adminorgdetail.name"));
                dataMap.put("parentorg", org.getLong("haos_adminorgdetail.parentorg.id"));
                dataMap.put("establishmentdate", org.getDate("haos_adminorgdetail.establishmentdate"));
                dataMap.put("bsed", org.getDate("haos_adminorgdetail.bsed"));
                dataMap.put("enable", org.getString("haos_adminorgdetail.enable"));
                dataMap.put("level", org.getString("level"));
                dataMap.put("isvirtualorg", org.getString("haos_adminorgdetail.isvirtualorg"));
                list.add(dataMap);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Throwable)ex);
        }
        returnDataMap.put("isover", count <= limit);
        returnDataMap.put("data", list);
        return returnDataMap;
    }

    private boolean isContainsChangeField(List<String> chgPageElementList) {
        for (String changeFieldList : this.changeFieldList) {
            if (!chgPageElementList.contains(changeFieldList)) continue;
            return true;
        }
        return false;
    }

    static class Model {
        long id;
        Date date;
        int level;

        public Model(long id, Date date, int level) {
            this.id = id;
            this.date = date;
            this.level = level;
        }

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }
    }
}

