/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.mservice;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.haos.business.domain.repository.CommonRepository;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.haos.mservice.api.IHAOSCustomeRoleService;
import kd.hr.haos.mservice.util.ApiResultUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.util.HRObjectUtils;

public class HAOSCustomeRoleService
implements IHAOSCustomeRoleService {
    private static Log LOGGER = LogFactory.getLog(HAOSCustomeRoleService.class);
    private static final HRBaseServiceHelper ROLE_HELPER = new HRBaseServiceHelper("haos_customorole");

    public HrApiResponse<String> saveCustomeRole(DynamicObject customeRole) {
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"haos_customorole", (DynamicObject[])new DynamicObject[]{customeRole}, (OperateOption)OperateOption.create());
        LOGGER.info("saveCustomeRole#call_save_result:{}", (Object)operationResult);
        return ApiResultUtil.handleOperationResult(operationResult);
    }

    public HrApiResponse<List<DynamicObject>> getCustomeRoles(List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            return HrApiResponse.fail((String)"500", (String)"ids is required\u3002");
        }
        QFilter qFilter = new QFilter("id", "in", ids).and(QFilterHelper.createValidHisCurrentDataFilter());
        HashSet<String> ignoreKeys = new HashSet<String>();
        ignoreKeys.add("iscurrentversion");
        ignoreKeys.add("datastatus");
        DynamicObject[] dys = CommonRepository.queryDynamicObjects((String)"haos_customorole", ignoreKeys, (String)"orgteam,number", (QFilter[])new QFilter[]{qFilter});
        return HrApiResponse.success(dys == null ? null : Arrays.asList(dys));
    }

    public HrApiResponse<List<DynamicObject>> getCustomeRolesByTeamId(List<Long> orgteamIds) {
        if (orgteamIds == null || orgteamIds.size() == 0) {
            return HrApiResponse.fail((String)"500", (String)"orgteamids is required\u3002");
        }
        QFilter qFilter = new QFilter("orgteam", "in", orgteamIds).and(QFilterHelper.createValidHisCurrentDataFilter());
        HashSet<String> ignoreKeys = new HashSet<String>();
        ignoreKeys.add("iscurrentversion");
        ignoreKeys.add("datastatus");
        DynamicObject[] dys = CommonRepository.queryDynamicObjects((String)"haos_customorole", ignoreKeys, (String)"orgteam,number", (QFilter[])new QFilter[]{qFilter});
        return HrApiResponse.success(dys == null ? null : Arrays.asList(dys));
    }

    public HrApiResponse<String> modifyCustomeRole(DynamicObject customeRole) {
        if (HRObjectUtils.isEmpty((Object)customeRole)) {
            return HrApiResponse.fail((String)"500", (String)"customeRole is empty");
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"his_rolemodify", (String)"haos_customorole", (DynamicObject[])new DynamicObject[]{customeRole}, (OperateOption)OperateOption.create());
        LOGGER.info("updateCustomeRoles#call_his_rolemodify_result:{}", (Object)operationResult);
        return ApiResultUtil.handleOperationResult(operationResult);
    }

    public HrApiResponse<String> removeCustomeRole(List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            return HrApiResponse.fail((String)"500", (String)"ids is empty");
        }
        QFilter qFilter = new QFilter("id", "in", ids).and(QFilterHelper.createValidHisCurrentDataFilter());
        DynamicObject[] roles = ROLE_HELPER.loadDynamicObjectArray(new QFilter[]{qFilter});
        if (roles == null || roles.length == 0) {
            LOGGER.info("removeCustomeRoles:not match data");
            return HrApiResponse.success();
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"tblremove", (String)"haos_customorole", (DynamicObject[])roles, (OperateOption)OperateOption.create());
        LOGGER.info("removeCustomeRoles#call_tblremove_result:{}", (Object)operationResult);
        return ApiResultUtil.handleOperationResult(operationResult);
    }

    public HrApiResponse<List<DynamicObject>> getCustomeRoleTpls(Long structtypeId) {
        if (structtypeId == null || structtypeId < 0L) {
            return HrApiResponse.fail((String)"500", (String)"structtype is invalided\u3002");
        }
        QFilter qFilter = new QFilter("structtype", "=", (Object)structtypeId).and(QFilterHelper.createValidHisCurrentDataFilter());
        HashSet<String> ignoreKeys = new HashSet<String>();
        ignoreKeys.add("iscurrentversion");
        ignoreKeys.add("datastatus");
        DynamicObject[] dys = CommonRepository.queryDynamicObjects((String)"haos_addhasrole", ignoreKeys, (String)"number", (QFilter[])new QFilter[]{qFilter});
        return HrApiResponse.success(dys == null ? null : Arrays.asList(dys));
    }

    public HrApiResponse<String> selectCustomeRoleTpls(List<DynamicObject> customeRoleTpls) {
        if (customeRoleTpls == null || customeRoleTpls.size() == 0) {
            return HrApiResponse.fail((String)"500", (String)"customeRoleTpls is empty");
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"tblsave", (String)"haos_addhasrole", (DynamicObject[])customeRoleTpls.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        LOGGER.info("removeCustomeRoles#call_tblremove_result:{}", (Object)operationResult);
        return ApiResultUtil.handleOperationResult(operationResult);
    }
}

