/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.mservice;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.application.impl.projectgroup.ProjectTeamApplicationImpl;
import kd.hr.haos.common.constants.projectgroup.ProjectGroupMDConstants;
import kd.hr.haos.mservice.api.IHAOSProjectGroupService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.constants.newhismodel.HisFieldNameConstants;

public class HAOSProjectGroupService
implements IHAOSProjectGroupService,
ProjectGroupMDConstants,
HisFieldNameConstants {
    private static final Log logger = LogFactory.getLog(ProjectTeamApplicationImpl.class);
    static final String PROJECT_GROUP_ID = "projectGroupId";
    static final String CHECK_TIME = "checkTime";

    public List<Map<String, Object>> getInfoByIdAndTime(List<Map<String, Object>> list) {
        Set ids = list.stream().map(s -> s.get(PROJECT_GROUP_ID)).collect(Collectors.toSet());
        QFilter idFilter = new QFilter("boid", "in", ids);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_projteambaseinfo");
        String select = String.join((CharSequence)",", "boid", "bsed", "bsled", "enable");
        QFilter notCurrentVersion = new QFilter("iscurrentversion", "=", (Object)"0");
        DynamicObject[] projects = helper.queryOriginalArray(select, new QFilter[]{idFilter, notCurrentVersion, Q_FILTER_HIS_DATA_STATUS});
        ArrayList<Map<String, Object>> projectRetList = new ArrayList<Map<String, Object>>();
        list.forEach(s -> {
            Date checkTime = (Date)s.get(CHECK_TIME);
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            DynamicObject object = null;
            for (DynamicObject f : projects) {
                if (!s.get(PROJECT_GROUP_ID).equals(f.getLong("boid")) || checkTime.before(f.getDate("bsed")) || f.getDate("bsled").before(checkTime)) continue;
                object = f;
                break;
            }
            if (object != null) {
                map.put(PROJECT_GROUP_ID, object.getLong("boid"));
                map.put("projectEnableStatus", object.getString("enable"));
                map.put("startDate", object.getDate("bsed"));
                map.put("endDate", object.getDate("bsled"));
                map.put(CHECK_TIME, s.get(CHECK_TIME));
                map.put("msgCode", 200);
                map.put("msgInfo", "success");
                projectRetList.add(map);
            }
        });
        return projectRetList;
    }

    public HrApiResponse<Object> getProTeamVersionById(List<Long> proTeamIdList) {
        Map dataMap;
        logger.info("HAOSProjectGroupService.getProTeamVersionById proTeamIdList={}", proTeamIdList);
        ProjectTeamApplicationImpl projectTeamApplication = ProjectTeamApplicationImpl.getInstance();
        try {
            dataMap = projectTeamApplication.getProjectTeamVersionInfoById(proTeamIdList);
        }
        catch (KDBizException e) {
            logger.error("HAOSProjectGroupService.getProTeamVersionById is exception.", (Throwable)e);
            return HrApiResponse.fail((String)"500", (String)e.getMessage());
        }
        return HrApiResponse.success((Object)dataMap);
    }
}

