/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.mservice;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.haos.business.application.impl.staff.SyncPersonStaffApplicationImpl;
import kd.hr.haos.business.domain.repository.staff.StaffCaseRepository;
import kd.hr.haos.business.domain.repository.staff.StaffDimensionRepository;
import kd.hr.haos.business.service.staff.occupy.impl.StaffOccupyServiceImpl;
import kd.hr.haos.business.service.staff.service.impl.PersonStaffServiceImpl;
import kd.hr.haos.business.service.staff.service.impl.StaffIncludeSubStaffQueryService;
import kd.hr.haos.mservice.api.IHAOSStaffService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.org.staff.StaffQueryInParam;
import kd.hr.hbp.common.model.org.staff.StaffQueryOutParamMap;
import kd.hr.hbp.common.model.org.staff.StaffResponse;
import kd.hr.hbp.common.model.org.staff.StaffUseInParam;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class HAOSStaffService
implements IHAOSStaffService {
    private static final Log LOG = LogFactory.getLog(HAOSStaffService.class);

    public StaffResponse<StaffQueryOutParamMap> getStaffUseInfoDetail(List<StaffQueryInParam> paramList) {
        StaffOccupyServiceImpl staffOccupyService = new StaffOccupyServiceImpl(paramList);
        StaffQueryOutParamMap staffQueryOutParamMap = staffOccupyService.queryStaffOccupyInfo();
        return StaffResponse.success((Object)staffQueryOutParamMap);
    }

    public StaffResponse<Map<String, Map<String, Object>>> queryUseStaffInfo(Date queryDate, List<Long> useOrgIds) {
        if (queryDate == null || CollectionUtils.isEmpty(useOrgIds)) {
            return StaffResponse.error((String)"queryDate and useOrgIds can not be empty!");
        }
        LOG.info("queryUseStaffInfo queryDate:{}, useOrgIds:{}", (Object)queryDate, (Object)JSON.toJSONString(useOrgIds));
        StaffOccupyServiceImpl staffOccupyService = new StaffOccupyServiceImpl();
        Map occupyResultMap = staffOccupyService.queryUseStaffInfo(queryDate, useOrgIds);
        LOG.info("queryUseStaffInfo occupyResultMap:{}", (Object)JSON.toJSONString((Object)occupyResultMap));
        return StaffResponse.success((Object)occupyResultMap);
    }

    public StaffResponse<Map<String, Map<String, Object>>> queryPositionStaffInfo(Date queryDate, List<Long> positionIds) {
        if (queryDate == null || CollectionUtils.isEmpty(positionIds)) {
            return StaffResponse.error((String)"queryDate and positionIds can not be empty!");
        }
        LOG.info("queryPositionStaffInfo queryDate:{}, useOrgIds:{}", (Object)queryDate, (Object)JSON.toJSONString(positionIds));
        StaffOccupyServiceImpl staffOccupyService = new StaffOccupyServiceImpl();
        Map occupyResultMap = staffOccupyService.queryPositionStaffInfo(queryDate, positionIds);
        LOG.info("queryPositionStaffInfo occupyResultMap:{}", (Object)JSON.toJSONString((Object)occupyResultMap));
        return StaffResponse.success((Object)occupyResultMap);
    }

    public StaffResponse<Map<Long, Integer>> queryIncludeSubStaffInfo(Date queryDate, List<Long> adminOrgIds) {
        if (queryDate == null || CollectionUtils.isEmpty(adminOrgIds)) {
            return StaffResponse.error((String)"queryDate and adminOrgIds can not be empty!");
        }
        StaffIncludeSubStaffQueryService staffIncludeSubStaffQueryService = new StaffIncludeSubStaffQueryService();
        Map resultMap = staffIncludeSubStaffQueryService.queryIncludeSubStaffQueryByAdminOrg(queryDate, adminOrgIds);
        LOG.info("queryIncludeSubStaffInfo resultMap:{}", (Object)JSON.toJSONString((Object)resultMap));
        return StaffResponse.success((Object)resultMap);
    }

    public StaffResponse<List<Map<String, Object>>> queryStaffDynamicdimension(String staffbill) {
        if (HRStringUtils.isEmpty((String)staffbill)) {
            return StaffResponse.error((String)"param staffbill is empty");
        }
        ArrayList resultList = new ArrayList(10);
        DynamicObject[] staffDynamicdimensionArr = StaffDimensionRepository.getInstance().queryStaffDynamicdimensionByStaffbill(staffbill);
        if (staffDynamicdimensionArr.length == 0) {
            LOG.info("queryStaffDynamicdimension resultList is empty");
            return StaffResponse.success(resultList);
        }
        block0: for (DynamicObject staffDynamicdimension : staffDynamicdimensionArr) {
            HashMap<String, String> resultMap = new HashMap<String, String>(16);
            String staffdimension = staffDynamicdimension.getString("staffdimension");
            DynamicObjectCollection collection = staffDynamicdimension.getDynamicObjectCollection("entryentity");
            for (DynamicObject col : collection) {
                String colStaffbill = col.getString("staffbill");
                boolean isexiststaffield = col.getBoolean("isexiststaffield");
                String mapfield = col.getString("mapfield");
                if (!HRStringUtils.equals((String)colStaffbill, (String)staffbill) || !isexiststaffield) continue;
                resultMap.put("mapfield", mapfield);
                resultMap.put("staffdimension", staffdimension);
                resultList.add(resultMap);
                continue block0;
            }
        }
        LOG.info("queryStaffDynamicdimension resultMap:{}", (Object)JSON.toJSONString(resultList));
        return StaffResponse.success(resultList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StaffResponse<String> syncOnePersonStaff(long person, Date startDate) {
        LOG.info("syncOnePersonStaff param:  person={}, startDate={}", (Object)person, (Object)startDate);
        if (person == 0L || startDate == null) {
            return StaffResponse.error((String)"param wrong");
        }
        Date now = HRDateTimeUtils.getNowDate();
        if (HRDateTimeUtils.dayAfter((Date)startDate, (Date)now)) {
            startDate = now;
        }
        SyncPersonStaffApplicationImpl syncPersonStaffApplication = new SyncPersonStaffApplicationImpl();
        try (TXHandle txHandle = TX.requiresNew();){
            syncPersonStaffApplication.doSyncByPersonId(Collections.singletonList(person), startDate, true);
        }
        return StaffResponse.success((Object)"success");
    }

    public StaffResponse<String> saveStaffCase(List<Map<String, Object>> params) {
        LOG.info("saveStaffCase param:  depEmpIdList={}", params);
        if (CollectionUtils.isEmpty(params)) {
            return StaffResponse.error((String)"saveStaffCase param wrong");
        }
        List personnelIdList = params.stream().filter(param -> param.get("personnel") != null).filter(param -> param.get("personnel") instanceof Long).map(param -> (Long)param.get("personnel")).collect(Collectors.toList());
        List rtnList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIDepempService", (String)"listEmpOrgrelDys", (Object[])new Object[]{personnelIdList});
        if (rtnList == null) {
            return StaffResponse.error((String)"saveStaffCase wrong");
        }
        HashMap<Long, List> failDataMap = new HashMap<Long, List>(params.size());
        HashMap<Long, Long> successDataMap = new HashMap<Long, Long>(params.size());
        Map<Long, DynamicObject> depEmpIdToDynMap = rtnList.stream().collect(Collectors.toMap(dyn -> dyn.getLong("depemp.id"), dyn -> dyn, (v1, v2) -> v1));
        ArrayList<DynamicObject> staffCaseList = new ArrayList<DynamicObject>(params.size());
        List<Long> idList = params.stream().filter(param -> param.get("id") != null).filter(param -> param.get("id") instanceof Long).map(param -> (Long)param.get("id")).collect(Collectors.toList());
        DynamicObject[] staffCaseDyns = StaffCaseRepository.getInstance().queryDyns(idList);
        Map<Long, DynamicObject> idToDynMap = Arrays.stream(staffCaseDyns).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
        List<Long> repeatIdList = this.getRepeatId(idList);
        long[] ids = ORM.create().genLongIds("haos_staffcase", params.size());
        int index = 0;
        HisEffDateCommonService hisEffDateCommonService = HisEffDateCommonService.getInstance();
        for (Map<String, Object> param2 : params) {
            Iterator paramId = param2.get("id");
            long id = !(paramId instanceof Long) ? ids[index++] : (Long)((Object)paramId);
            String errMsg = this.checkStaffCaseParams(param2);
            if (!HRStringUtils.isEmpty((String)errMsg)) {
                failDataMap.put(id, Collections.singletonList(errMsg));
                continue;
            }
            if (repeatIdList.contains(id)) {
                failDataMap.put(id, Collections.singletonList(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u6570\u636e\u4e2d\u6709\u91cd\u590d\u7684id\u3002", (String)"HAOSStaffService_0", (String)"hrmp-haos-mservice", (Object[])new Object[0])));
                continue;
            }
            long personnel = (Long)param2.get("personnel");
            Date bsed = (Date)param2.get("bsed");
            Object bsledObj = param2.get("bsled");
            Date bsled = bsledObj != null ? (Date)bsledObj : hisEffDateCommonService.getDate2999(null);
            String description = (String)param2.get("description");
            DynamicObject staffCase = idToDynMap.get(id);
            if (staffCase == null) {
                DynamicObject empposorgrel = depEmpIdToDynMap.get(personnel);
                if (empposorgrel == null) {
                    failDataMap.put(id, Collections.singletonList(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u90e8\u95e8\u4eba\u5458id\uff1a%s\u7684\u4efb\u804c\u7ecf\u5386\u6570\u636e\u3002", (String)"HAOSStaffService_1", (String)"hrmp-haos-mservice", (Object[])new Object[0]), personnel)));
                    continue;
                }
                staffCase = StaffCaseRepository.getInstance().getNewEmptyDyn();
                staffCase.set("personnel", (Object)empposorgrel.getDynamicObject("depemp"));
                staffCase.set("adminorg", (Object)empposorgrel.getDynamicObject("company"));
                staffCase.set("number", (Object)empposorgrel.getString("person.number"));
                staffCase.set("person", (Object)empposorgrel.getDynamicObject("person"));
                staffCase.set("bsed", (Object)bsed);
                staffCase.set("bsled", (Object)bsled);
                staffCase.set("description", (Object)description);
                staffCase.set("enable", (Object)"1");
                staffCase.set("status", (Object)"C");
                staffCase.set("id", (Object)id);
            } else {
                if (personnel != staffCase.getLong("personnel.id")) {
                    failDataMap.put(personnel, Collections.singletonList(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e0d\u53ef\u4fee\u6539\u5458\u5de5\u3002", (String)"HAOSStaffService_2", (String)"hrmp-haos-mservice", (Object[])new Object[0]), personnel)));
                    continue;
                }
                staffCase.set("bsed", (Object)bsed);
                staffCase.set("bsled", (Object)bsled);
                staffCase.set("description", (Object)description);
            }
            staffCaseList.add(staffCase);
            successDataMap.put(id, id);
        }
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("fromRPC", "1");
        OperationResult opResult = opImpl.localInvokeOperation("save", staffCaseList.toArray(new DynamicObject[0]), operateOption);
        List validateErrors = opResult.getValidateResult().getValidateErrors();
        for (ValidateResult validateError : validateErrors) {
            List allErrorInfo = validateError.getAllErrorInfo();
            for (OperateErrorInfo opErrorInfo : allErrorInfo) {
                long pkId = (Long)opErrorInfo.getPkValue();
                List errMsgList = failDataMap.getOrDefault(pkId, new ArrayList(8));
                errMsgList.add(opErrorInfo.getMessage());
                failDataMap.put(pkId, errMsgList);
                successDataMap.remove(pkId);
            }
        }
        HashMap<String, HashMap<Long, Object>> resultDataMap = new HashMap<String, HashMap<Long, Object>>(8);
        resultDataMap.put("successData", successDataMap);
        resultDataMap.put("failData", failDataMap);
        return StaffResponse.success(resultDataMap);
    }

    private String checkStaffCaseParams(Map<String, Object> param) {
        String errorMsg1 = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u53c2\u6570\uff0cpersonnel\u7ec4\u7ec7\u4ebaID\u3001bsed\u751f\u6548\u65e5\u671f \u4e3a\u5fc5\u586b\u3002", (String)"HAOSStaffService_3", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
        String errorMsg2 = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u53c2\u6570\uff0cpersonnel\u7ec4\u7ec7\u4ebaID\u4e3aLong\u7c7b\u578b\uff0cbsed\u751f\u6548\u65e5\u671f\u3001bsled\u5931\u6548\u65e5\u671f\u4e3aDate\u7c7b\u578b\uff0cdescription\u63cf\u8ff0\u4e3aString\u7c7b\u578b\u3002", (String)"HAOSStaffService_4", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
        Object personnel = param.get("personnel");
        Object bsed = param.get("bsed");
        Object bsled = param.get("bsled");
        Object description = param.get("description");
        if (personnel == null || bsed == null) {
            return errorMsg1;
        }
        if (!(personnel instanceof Long) || !(bsed instanceof Date) || bsled != null && !(bsled instanceof Date) || description != null && !(description instanceof String)) {
            return errorMsg2;
        }
        if ((Long)personnel == 0L) {
            return errorMsg1;
        }
        return "";
    }

    private List<Long> getRepeatId(List<Long> idList) {
        ArrayList<Long> repeatIdList = new ArrayList<Long>(idList.size());
        HashSet<Long> set = new HashSet<Long>(idList.size());
        for (Long id : idList) {
            if (set.add(id)) continue;
            repeatIdList.add(id);
        }
        return repeatIdList;
    }

    public StaffResponse<String> cancelBillStaff(List<StaffUseInParam> staffUseInParamList) {
        try (TXHandle txHandle = TX.required();){
            try {
                PersonStaffServiceImpl personStaffService = new PersonStaffServiceImpl();
                personStaffService.msgAbortProcess(staffUseInParamList);
            }
            catch (Exception ex) {
                txHandle.markRollback();
                throw ex;
            }
        }
        catch (Exception ex) {
            LOG.info("staffAbortMsg fromPRC exception is {}", (Object)ex.getMessage());
            throw ex;
        }
        return StaffResponse.success((Object)"");
    }
}

