/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.mservice.ot;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.hr.haos.business.domain.repository.orgteam.OTQueryRepository;
import kd.hr.haos.business.domain.repository.structproject.StructProjectRepository;
import kd.hr.haos.business.service.orgteam.OrgTeamSynService;
import kd.hr.haos.common.exception.mservice.PreDataException;
import kd.hr.haos.common.model.prj.CheckResult;
import kd.hr.haos.mservice.util.ParamCheckUtils;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.util.HRStringUtils;

public abstract class AbstractDataService {
    private static final Log LOGGER = LogFactory.getLog(AbstractDataService.class);
    long structProjectId;

    public final HrApiResponse<Map<String, Object>> execute(Map<String, Object> param) {
        try {
            HrApiResponse response = HrApiResponse.success();
            this.beforeParamCheck(param);
            CheckResult<String> paramCheckResult = this.paramCheck(param);
            if (!paramCheckResult.isSuccess()) {
                return HrApiResponse.fail((String)"301", (String)paramCheckResult.getKeyVsMsg().toString());
            }
            List<DynamicObject> otList = this.convert(param);
            this.beforeCheck(otList);
            CheckResult<String> bizCheckResult = this.bizCheck(otList);
            if (!bizCheckResult.isSuccess()) {
                return HrApiResponse.fail((String)"302", (String)bizCheckResult.getKeyVsMsg().toString());
            }
            this.beforeSave(otList);
            try (TXHandle txHandle = TX.requiresNew();){
                try {
                    this.process(otList);
                }
                catch (Exception ex) {
                    txHandle.markRollback();
                    LOGGER.error((Throwable)ex);
                    throw ex;
                }
            }
            return response;
        }
        catch (PreDataException ex) {
            LOGGER.error((Throwable)ex);
            return HrApiResponse.fail((String)"502", (String)ex.getMessage());
        }
        catch (Exception ex) {
            LOGGER.error((Throwable)ex);
            return HrApiResponse.fail((String)"501", (String)ex.getMessage());
        }
    }

    protected abstract Collection<String> getEnabledKeySet();

    protected abstract void beforeParamCheck(Map<String, Object> var1);

    protected abstract CheckResult<String> paramCheck(Map<String, Object> var1);

    protected void removeSucceeded(List<DynamicObject> otList) {
    }

    protected abstract List<DynamicObject> convert(Map<String, Object> var1);

    protected abstract void beforeCheck(List<DynamicObject> var1);

    protected abstract CheckResult<String> bizCheck(List<DynamicObject> var1);

    protected abstract void beforeSave(List<DynamicObject> var1);

    protected abstract void process(List<DynamicObject> var1);

    protected <T> CheckResult<T> createCheckResult(Map<T, List<String>> result) {
        CheckResult checkResult = new CheckResult();
        checkResult.setSuccess(result.size() == 0);
        checkResult.setKeyVsMsg(result);
        return checkResult;
    }

    String getNumberPrefix(List<DynamicObject> otList) {
        String numberPrefix = "";
        Optional<DynamicObject> otClassifyDyOpt = otList.stream().map(ot -> ot.get("otclassify")).filter(Objects::nonNull).filter(ot -> ot instanceof DynamicObject).map(obj -> (DynamicObject)obj).findAny();
        if (otClassifyDyOpt.isPresent()) {
            numberPrefix = this.getNumberPrefix(otClassifyDyOpt.get());
        }
        return numberPrefix;
    }

    String getNumberPrefix(DynamicObject otClassifyDy) {
        String numberByNumberPrefix = OrgTeamSynService.getNumberByPrefixId((Long)otClassifyDy.getLong("id"));
        if (HRStringUtils.isEmpty((String)numberByNumberPrefix)) {
            throw new PreDataException(ResManager.loadKDString((String)"\u672a\u9884\u7f6e\u7f16\u7801\u524d\u7f00\u6570\u636e\u3002", (String)"AbstractDataService_0", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
        }
        return numberByNumberPrefix;
    }

    CheckResult<String> boidNotExistCheck(List<Map<String, Object>> data) {
        return ParamCheckUtils.boidNotExistCheck(data, boidSet -> OTQueryRepository.getInstance().queryOriginalCurrentVersionById("boid", boidSet));
    }

    void setBoIdIfNull(List<Map<String, Object>> paramMap) {
        this.setIdIfNull(paramMap, "boid");
    }

    void setIdIfNull(List<Map<String, Object>> paramMap) {
        this.setIdIfNull(paramMap, "id");
    }

    private void setIdIfNull(List<Map<String, Object>> paramMap, String field) {
        long[] ids = ORM.create().genLongIds("haos_adminorgteam", paramMap.size());
        ArrayDeque idQueue = Arrays.stream(ids).boxed().collect(Collectors.toCollection(ArrayDeque::new));
        paramMap.forEach(map -> {
            Object idVal = map.get(field);
            if (idVal == null) {
                map.put(field, idQueue.poll());
            }
        });
    }

    long initStructProject(Map<String, Object> param) {
        return Long.parseLong(param.get("structproject").toString());
    }

    void setStructProjectId4Add(Map<String, Object> paramMap) {
        if (paramMap.get("structproject") == null) {
            List data = (List)paramMap.get("data");
            Supplier<Long> structProjectIdSupplier = () -> {
                DynamicObject[] structProjectByOtClassify;
                Object otclassfy = ((Map)data.get(0)).get("otclassify");
                if (otclassfy != null && (structProjectByOtClassify = StructProjectRepository.getInstance().queryStructProjectByOtClassify("id", Collections.singletonList(Long.parseLong(otclassfy.toString())))).length == 1) {
                    return structProjectByOtClassify[0].getLong("id");
                }
                return null;
            };
            paramMap.put("structproject", structProjectIdSupplier.get());
        }
    }

    void setStructProjectId4OtExist(Map<String, Object> paramMap) {
        if (paramMap.get("structproject") == null) {
            List data = (List)paramMap.get("data");
            Supplier<Long> structProjectIdSupplier = () -> {
                DynamicObject otDy;
                Object boid = ((Map)data.get(0)).get("boid");
                if (boid != null && (otDy = OTQueryRepository.getInstance().queryByPk("id, otclassify", boid)) != null) {
                    Long otclassfy = otDy.getLong("otclassify.id");
                    DynamicObject[] structProjectByOtClassify = StructProjectRepository.getInstance().queryStructProjectByOtClassify("id", Collections.singletonList(Long.parseLong(((Object)otclassfy).toString())));
                    if (structProjectByOtClassify.length == 1) {
                        return structProjectByOtClassify[0].getLong("id");
                    }
                }
                return null;
            };
            paramMap.put("structproject", structProjectIdSupplier.get());
        }
    }
}

