/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.mservice.ot;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.business.domain.repository.orgteam.OTQueryRepository;
import kd.hr.haos.business.domain.service.impl.orgteam.OrgTeamServiceImpl;
import kd.hr.haos.common.model.DyMapModel;
import kd.hr.haos.common.model.prj.CheckResult;
import kd.hr.haos.common.util.CheckChainUtils;
import kd.hr.haos.common.util.HRDyObjectUtils;
import kd.hr.haos.common.util.dyconverter.Map2Dy;
import kd.hr.haos.mservice.ot.AbstractDataService;
import kd.hr.haos.mservice.ot.valid.AbstractBizValidator;
import kd.hr.haos.mservice.ot.valid.AddBizValidator;
import kd.hr.haos.mservice.util.ParamCheckUtils;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class AddDataService
extends AbstractDataService {
    private static final Set<String> enabledKeySet = new HashSet<String>(Arrays.asList("id", "boid", "org", "number", "name", "parent", "bsed", "otclassify", "enable"));

    @Override
    protected Collection<String> getEnabledKeySet() {
        return enabledKeySet;
    }

    @Override
    protected void beforeParamCheck(Map<String, Object> param) {
        List data = (List)param.get("data");
        this.setIdIfNull(data);
        this.setBoIdIfNull(data);
        this.setStructProjectId4Add(param);
    }

    @Override
    protected CheckResult<String> paramCheck(Map<String, Object> param) {
        List data = (List)param.get("data");
        Supplier<CheckResult> boidMustInputCheck = () -> ParamCheckUtils.mustInputCheck(data, Collections.singleton("boid"));
        Supplier<CheckResult> boidKeyDuplicatedCheck = () -> ParamCheckUtils.keyDuplicatedCheck(data, "boid");
        Supplier<CheckResult> boidExistCheck = () -> this.boidExistCheck(data);
        Supplier<CheckResult> idMustInputCheck = () -> ParamCheckUtils.mustInputCheck(data, Collections.singleton("id"));
        Supplier<CheckResult> idKeyDuplicatedCheck = () -> ParamCheckUtils.keyDuplicatedCheck(data, "id");
        Supplier<CheckResult> structProjectExistCheck = () -> ParamCheckUtils.getStructProjectExistCheck(param);
        Supplier<CheckResult> structProjectNonSysTypeCheck = () -> ParamCheckUtils.getStructProjectNonSysTypeCheck(param);
        List<Supplier> checkList = Arrays.asList(boidMustInputCheck, boidKeyDuplicatedCheck, boidExistCheck, idMustInputCheck, idKeyDuplicatedCheck, structProjectExistCheck, structProjectNonSysTypeCheck);
        return (CheckResult)CheckChainUtils.check(checkList, CheckResult::isSuccess, ParamCheckUtils.getFastFailCheckContext());
    }

    private CheckResult<String> boidExistCheck(List<Map<String, Object>> data) {
        return ParamCheckUtils.boidExistCheck(data, boidSet -> OTQueryRepository.getInstance().queryOriginalCurrentVersionById("boid", boidSet));
    }

    @Override
    protected List<DynamicObject> convert(Map<String, Object> param) {
        this.structProjectId = this.initStructProject(param);
        List data = (List)param.get("data");
        DyMapModel dyMapModel = new DyMapModel();
        dyMapModel.setData(data);
        dyMapModel.setMetadata("haos_adminorgteam");
        HashMap<String, BiConsumer<DynamicObject, Object>> keyVsValueSetter = new HashMap<String, BiConsumer<DynamicObject, Object>>();
        keyVsValueSetter.put("parent", this.getParentSetter(data));
        keyVsValueSetter.put("id", this.getLongValueSetter("id"));
        keyVsValueSetter.put("boid", this.getLongValueSetter("boid"));
        dyMapModel.setKeyVsValueSetter(keyVsValueSetter);
        Map2Dy map2Dy = new Map2Dy();
        return map2Dy.map2DynamicObject(dyMapModel);
    }

    private BiConsumer<DynamicObject, Object> getParentSetter(List<Map<String, Object>> data) {
        Map<Long, Object> curBatchNewIdVsParentVal = data.stream().filter(map -> map.get("parent") != null).collect(Collectors.toMap(map -> Long.parseLong(map.get("boid").toString()), map -> map.get("parent")));
        MainEntityType otMainType = MetadataServiceHelper.getDataEntityType((String)"haos_adminorgteam");
        DynamicObjectType parentOrgDyType = HRDyObjectUtils.createDyTypeFromTargetType((DynamicObjectType)otMainType, (String)"parent");
        DynamicObject[] parentOrgDys = BusinessDataServiceHelper.load((Object[])curBatchNewIdVsParentVal.values().toArray(), (DynamicObjectType)parentOrgDyType);
        Map<String, DynamicObject> existIdVsDy = Arrays.stream(parentOrgDys).collect(Collectors.toMap(dy -> dy.getString("id"), dy -> dy));
        return (dy, value) -> {
            if (value == null) {
                dy.set("parent", null);
            } else {
                DynamicObject parentOt = null;
                String valString = value.toString();
                if (existIdVsDy.containsKey(value.toString())) {
                    parentOt = (DynamicObject)existIdVsDy.get(valString);
                } else if (curBatchNewIdVsParentVal.containsKey(Long.parseLong(value.toString()))) {
                    parentOt = new DynamicObject(parentOrgDyType);
                    parentOt.set("id", value);
                }
                if (parentOt != null) {
                    dy.set("parent", (Object)parentOt);
                } else {
                    dy.set("parent", value);
                    dy.set("parent_id", value);
                }
            }
        };
    }

    private BiConsumer<DynamicObject, Object> getLongValueSetter(String field) {
        return (ot, parentValue) -> ot.set(field, parentValue == null ? null : Long.valueOf(Long.parseLong(parentValue.toString())));
    }

    @Override
    protected void beforeCheck(List<DynamicObject> otList) {
        this.setOrg(otList);
        Date date2999 = HisEffDateCommonService.getInstance().getDate2999(null);
        String[] structNumbersOrProjectIdentify = ORM.create().genStringIds("haos_projteambaseinfo", otList.size());
        ArrayDeque<String> structNumbersOrProjectIdentifyQueue = new ArrayDeque<String>(Arrays.asList(structNumbersOrProjectIdentify));
        String numberPrefix = this.getNumberPrefix(otList);
        otList.forEach(ot -> {
            String number = ot.getString("number");
            if (!(HRStringUtils.isEmpty((String)numberPrefix) || HRStringUtils.isEmpty((String)number) || number.startsWith(numberPrefix))) {
                ot.set("number", (Object)String.format("%s_%s", numberPrefix, number));
            }
            if (HRStringUtils.isEmpty((String)ot.getString("structnumber"))) {
                ot.set("structnumber", structNumbersOrProjectIdentifyQueue.poll());
            }
            ot.set("bsled", (Object)date2999);
            ot.set("bsed", (Object)HRDateTimeUtils.truncateDate((Date)ot.getDate("bsed")));
            ot.set("firstbsed", (Object)ot.getDate("bsed"));
            ot.set("initstatus", (Object)"2");
            ot.set("initbatch", (Object)0L);
            ot.set("initdatasource", (Object)"0");
            ot.set("status", (Object)"C");
            if (ot.get("enable") == null) {
                ot.set("enable", (Object)"1");
            }
        });
    }

    private void setOrg(List<DynamicObject> otList) {
        Map<Long, DynamicObject> boidVsOt = otList.stream().collect(Collectors.toMap(ot -> ot.getLong("boid"), ot -> ot));
        otList.stream().filter(ot -> ot.get("parent") instanceof DynamicObject).filter(ot -> ot.get("org") == null).forEach(ot -> {
            DynamicObject parent = ot.getDynamicObject("parent");
            long parentId = parent.getLong("id");
            DynamicObject hasOrgValueParent = boidVsOt.getOrDefault(parentId, parent);
            Object orgValue = hasOrgValueParent.get("org");
            if (orgValue instanceof DynamicObject) {
                ot.set("org", orgValue);
            } else {
                ot.set("org", orgValue);
                ot.set("org_id", orgValue);
            }
        });
    }

    @Override
    protected CheckResult<String> bizCheck(List<DynamicObject> otList) {
        AddBizValidator validator = new AddBizValidator(otList);
        ((AbstractBizValidator)validator).valid();
        return this.createCheckResult(validator.getResult());
    }

    @Override
    protected void beforeSave(List<DynamicObject> otList) {
        otList.forEach(ot -> {
            DynamicObject otClassifyDy = ot.getDynamicObject("otclassify");
            ot.set("orgtype", otClassifyDy.get("orgtype"));
            ot.set("teamtype", otClassifyDy.get("teamtype"));
        });
    }

    @Override
    protected void process(List<DynamicObject> otList) {
        new OrgTeamServiceImpl().add(otList, this.structProjectId);
    }
}

