/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.mservice.ot.valid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.inte.api.EnabledLang;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.orgteam.OTQueryRepository;
import kd.hr.haos.business.service.orgteam.OrgTeamSynService;
import kd.hr.haos.business.service.projectgroup.service.LocaleStringComparator;
import kd.hr.haos.business.util.PatternUtil;
import kd.hr.haos.common.constants.masterdata.EnableEnum;
import kd.hr.haos.common.model.cascade.CycleCheckResult;
import kd.hr.haos.common.model.cascade.CycleCheckResultWithType;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public abstract class AbstractBizValidator {
    private final Map<String, List<String>> result;
    protected List<DynamicObject> otList;
    private final LocaleStringComparator localeStringComparator = new LocaleStringComparator();
    private Map<String, List<DynamicObject>> numberVsBoList;
    private Map<Long, DynamicObject> currentOtMap;
    private final List<String> lengthFields = Arrays.asList("number", "name");
    private String numberPrefix;
    private Map<Long, DynamicObject> otMap;

    public AbstractBizValidator(List<DynamicObject> otList) {
        this.otList = otList;
        this.result = new HashMap<String, List<String>>(otList.size());
    }

    public abstract void valid();

    protected void checkNumber(DynamicObject otDy) {
        String number = otDy.getString("number");
        if (HRStringUtils.isEmpty((String)number)) {
            return;
        }
        if (number.contains("!") || number.contains("\uff01")) {
            this.addMsg(otDy, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%s\u201d\u4e0d\u80fd\u5305\u542b\uff01\u5b57\u7b26\u3002", (String)"AbstractBizValidator_1", (String)"hrmp-haos-mservice", (Object[])new Object[0]), number));
        }
        if (this.checkNumberRepeat(otDy)) {
            this.addMsg(otDy, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%s\u201d\u5df2\u5b58\u5728\u3002", (String)"AbstractBizValidator_3", (String)"hrmp-haos-mservice", (Object[])new Object[0]), number));
        }
    }

    protected void checkName(DynamicObject otDy) {
        ILocaleString localeString = otDy.getLocaleString("name");
        if (localeString == null) {
            return;
        }
        List enabledLangList = this.localeStringComparator.getEnabledLangList();
        for (EnabledLang enabledLang : enabledLangList) {
            String name = (String)localeString.get((Object)enabledLang.getNumber());
            if (!HRStringUtils.isNotEmpty((String)name) || !PatternUtil.valideName((String)name)) continue;
            String message = ResManager.loadKDString((String)"\u540d\u79f0\u201c%s\u201d\u4e0d\u80fd\u5305\u542b\u5b57\u7b26\uff08\uff01_\\\uff09\u3002", (String)"AbstractBizValidator_0", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
            this.addMsg(otDy, String.format(message, name));
            break;
        }
    }

    protected void checkFutureDate(DynamicObject otDy) {
        Date date = otDy.getDate("bsed");
        if (date == null) {
            return;
        }
        if (date.compareTo(HRDateTimeUtils.getNowDate()) > 0) {
            String msg = ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5fc5\u987b\u662f\u4eca\u5929\u6216\u4eca\u5929\u4ee5\u524d\u7684\u65e5\u671f\u3002", (String)"AbstractCheckHelper_12", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
            this.addMsg(otDy, msg);
        }
    }

    protected void checkEnableValid(DynamicObject otDy) {
        String value = otDy.getString("enable");
        if (HRStringUtils.isEmpty((String)value)) {
            return;
        }
        EnableEnum enableEnum = EnableEnum.getEnableEnumByValue((String)value);
        if (enableEnum == null) {
            String message = ResManager.loadKDString((String)"%1$s\uff1a\u201c%2$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"AbstractBizValidator_8", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
            this.addMsg(otDy, String.format(message, "enable", value));
        }
    }

    protected void checkBdValid(DynamicObject otDy, List<String> fieldList) {
        fieldList.forEach(field -> this.checkValid(otDy, (String)field));
    }

    protected void checkTextLength(DynamicObject otDy) {
        DynamicObjectType objectType = otDy.getDynamicObjectType();
        this.lengthFields.forEach(field -> {
            String prefix;
            DynamicProperty property = objectType.getProperty(field);
            if (!(property instanceof TextProp)) {
                return;
            }
            int maxLength = ((TextProp)property).getMaxLenth();
            if (property instanceof MuliLangTextProp) {
                List enabledLangList = this.localeStringComparator.getEnabledLangList();
                ILocaleString localeString = otDy.getLocaleString(field);
                for (EnabledLang enabledLang : enabledLangList) {
                    String value = (String)localeString.get((Object)enabledLang.getNumber());
                    if (!HRStringUtils.isNotEmpty((String)value) || value.length() <= maxLength) continue;
                    this.addMsg(otDy, String.format(this.getLengthMessage(), property.getDisplayName(), maxLength));
                    break;
                }
                return;
            }
            String value = otDy.getString(field);
            if (HRStringUtils.isEmpty((String)value)) {
                return;
            }
            if ("number".equals(field) && !HRStringUtils.isEmpty((String)(prefix = this.getNumberPrefix()))) {
                value = value.replace(prefix, "");
            }
            if (value.length() > maxLength) {
                this.addMsg(otDy, String.format(this.getLengthMessage(), property.getDisplayName(), maxLength));
            }
        });
    }

    private String getLengthMessage() {
        return ResManager.loadKDString((String)"\u201c%1$s\u201d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7\u201c%2$s\u201d\u3002", (String)"AbstractBizValidator_5", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
    }

    protected void checkMustInput(DynamicObject otDy, List<String> filedList) {
        DynamicObjectType objectType = otDy.getDynamicObjectType();
        filedList.forEach(field -> {
            DynamicProperty property = objectType.getProperty(field);
            Object value = otDy.get(field);
            if (value == null) {
                this.addMsg(otDy, String.format(this.getMustInputMessage(), property.getDisplayName()));
                return;
            }
            if (!(property instanceof TextProp)) {
                return;
            }
            if (value instanceof ILocaleString) {
                if (this.localeStringComparator.isBizEmpty((ILocaleString)value)) {
                    this.addMsg(otDy, String.format(this.getMustInputMessage(), property.getDisplayName()));
                }
            } else if (HRStringUtils.isEmpty((String)otDy.getString(field))) {
                this.addMsg(otDy, String.format(this.getMustInputMessage(), property.getDisplayName()));
            }
        });
    }

    protected void batchCheckCoopAff() {
        if (!this.result.isEmpty()) {
            return;
        }
        List<CycleCheckResultWithType> cycleCheckResults = this.doBatchCheckCoopRelIsRinged();
        cycleCheckResults.stream().filter(CycleCheckResult::isCycled).forEach(cycleCheckResult -> {
            String msg = ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u81ea\u5df1\u6216\u81ea\u5df1\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u4e3a\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u3002", (String)"AbstractBizValidator_4", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
            this.addMsg(String.valueOf(cycleCheckResult.getStartBo()), msg);
        });
    }

    protected void checkEffDate(DynamicObject otDy) {
        Date curEffDt = otDy.getDate("bsed");
        if (curEffDt == null) {
            return;
        }
        DynamicObject curDBDy = this.getCurrentOtMap().get(otDy.getLong("boid"));
        Date curHisEffDt = curDBDy.getDate("bsed");
        if (curEffDt.compareTo(curHisEffDt) < 0) {
            this.addMsg(otDy, String.format(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u7ec4\u7ec7\u5f53\u524d\u751f\u6548\u65e5\u671f\u201c%s\u201d\u3002", (String)"AbstractBizValidator_6", (String)"hrmp-haos-mservice", (Object[])new Object[0]), HRDateTimeUtils.formatDate((Date)curHisEffDt)));
        }
    }

    protected Map<Long, DynamicObject> getCurrentOtMap() {
        if (this.currentOtMap == null) {
            HashSet boIdSet = new HashSet(this.otList.size() * 2);
            this.otList.forEach(otDy -> {
                boIdSet.add(otDy.getLong("boid"));
                boIdSet.add(this.getParentId((DynamicObject)otDy));
            });
            DynamicObject[] otDys = OTQueryRepository.getInstance().queryOriginalArrById("firstbsed,boid,bsed,parent.id,enable", boIdSet);
            this.currentOtMap = Arrays.stream(otDys).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy));
        }
        return this.currentOtMap;
    }

    protected long getParentId(DynamicObject otDy) {
        Object parent = otDy.get("parent");
        if (parent instanceof DynamicObject) {
            return ((DynamicObject)parent).getLong("id");
        }
        return 0L;
    }

    protected List<CycleCheckResultWithType> doBatchCheckCoopRelIsRinged() {
        throw new RuntimeException("doBatchCheckCoopRelIsRinged is not defined");
    }

    protected final void addMsg(String boIdStr, String msg) {
        this.result.computeIfAbsent(boIdStr, key -> new ArrayList()).add(msg);
    }

    protected final void addMsg(DynamicObject otDy, String msg) {
        this.addMsg(otDy.getString("boid"), msg);
    }

    protected final Map<Long, DynamicObject> getOtMap() {
        if (this.otMap == null) {
            this.otMap = this.otList.stream().collect(Collectors.toMap(otDy -> otDy.getLong("boid"), otDy -> otDy, (key1, key2) -> key2));
        }
        return this.otMap;
    }

    protected void checkParentEnable(DynamicObject otDy) {
        if ("1".equals(otDy.getString("enable"))) {
            DynamicObject parent = this.getParentDy(otDy);
            if (parent == null) {
                return;
            }
            if ("10".equals(parent.getString("enable"))) {
                this.addMsg(otDy, String.format(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u201c%s\u201d\u672a\u542f\u7528\u3002", (String)"AbstractBizValidator_9", (String)"hrmp-haos-mservice", (Object[])new Object[0]), parent.getLong("boid")));
            }
        }
    }

    protected DynamicObject getParentDy(DynamicObject otDy) {
        long parentBoId = this.getParentId(otDy);
        DynamicObject parentDy = this.getOtMap().get(parentBoId);
        if (parentDy == null) {
            parentDy = this.getCurrentOtMap().get(parentBoId);
        }
        return parentDy;
    }

    public Map<String, List<String>> getResult() {
        return this.result;
    }

    private String getMustInputMessage() {
        return ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c%s\u201d\u3002", (String)"AbstractBizValidator_2", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
    }

    private void checkValid(DynamicObject otDy, String propertyName) {
        DynamicProperty property = otDy.getDynamicObjectType().getProperty(propertyName);
        Object value = otDy.get(propertyName);
        if (value == null) {
            return;
        }
        if (!(value instanceof DynamicObject)) {
            String message = ResManager.loadKDString((String)"%1$s\uff1a\u201c%2$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"AbstractBizValidator_8", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
            this.addMsg(otDy, String.format(message, property.getDisplayName(), value));
        }
    }

    private boolean checkNumberRepeat(DynamicObject otDy) {
        List<DynamicObject> list;
        String number = otDy.getString("number");
        Date effDate = otDy.getDate("bsed");
        if (effDate == null) {
            return false;
        }
        if (this.numberVsBoList == null) {
            HashSet numberSet = new HashSet(this.otList.size());
            HashSet boIdSet = new HashSet(this.otList.size());
            this.otList.forEach(dy -> {
                numberSet.add(dy.getString("number"));
                boIdSet.add(dy.getLong("boid"));
            });
            DynamicObjectCollection dbOtCol = OTQueryRepository.getInstance().queryColByNumber("boid,number,bsed,bsled", numberSet, boIdSet);
            this.numberVsBoList = Stream.concat(dbOtCol.stream(), this.otList.stream()).collect(Collectors.groupingBy(dy -> dy.getString("number")));
        }
        if (CollectionUtils.isEmpty(this.numberVsBoList) || CollectionUtils.isEmpty(list = this.numberVsBoList.get(number))) {
            return false;
        }
        for (DynamicObject dy2 : list) {
            if (dy2.getLong("boid") == otDy.getLong("boid") || effDate.compareTo(dy2.getDate("bsled")) > 0) continue;
            return true;
        }
        return false;
    }

    public String getNumberPrefix() {
        if (this.numberPrefix != null) {
            return this.numberPrefix;
        }
        Optional<DynamicObject> op = this.otList.stream().filter(ot -> ot.get("otclassify") instanceof DynamicObject).map(ot -> ot.getDynamicObject("otclassify")).findAny();
        op.ifPresent(dynamicObject -> {
            this.numberPrefix = OrgTeamSynService.getNumberByPrefixId((Long)dynamicObject.getLong("id"));
        });
        this.numberPrefix = this.numberPrefix == null ? "" : this.numberPrefix + "_";
        return this.numberPrefix;
    }
}

