/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.mservice.ot.valid;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.haos.business.domain.repository.orgteam.OTQueryRepository;
import kd.hr.haos.business.service.projectgroup.valid.ProjectGroupValidHelper;
import kd.hr.haos.common.model.cascade.CycleCheckResultWithType;
import kd.hr.haos.mservice.ot.valid.AbstractBizValidator;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class AddBizValidator
extends AbstractBizValidator {
    private Map<String, List<Long>> structNumberVsBoList;

    public AddBizValidator(List<DynamicObject> otList) {
        super(otList);
    }

    @Override
    public void valid() {
        List<String> mustInput = Arrays.asList("org", "number", "name", "parent", "bsed", "otclassify", "structnumber");
        List<String> valid = Arrays.asList("org", "parent", "otclassify");
        this.otList.forEach(otDy -> {
            this.checkMustInput((DynamicObject)otDy, mustInput);
            this.checkBdValid((DynamicObject)otDy, valid);
            this.checkEnableValid((DynamicObject)otDy);
            this.checkNumber((DynamicObject)otDy);
            this.checkName((DynamicObject)otDy);
            this.checkStructNumber((DynamicObject)otDy);
            this.checkFutureDate((DynamicObject)otDy);
            this.checkTextLength((DynamicObject)otDy);
            this.checkEffDateByParent((DynamicObject)otDy);
            this.checkParentEnable((DynamicObject)otDy);
        });
        this.batchCheckCoopAff();
    }

    @Override
    protected List<CycleCheckResultWithType> doBatchCheckCoopRelIsRinged() {
        return ProjectGroupValidHelper.checkCoopAffRel((List)this.otList, (boolean)false);
    }

    private void checkEffDateByParent(DynamicObject otDy) {
        Date curEffDt = otDy.getDate("bsed");
        if (curEffDt == null) {
            return;
        }
        DynamicObject parentDy = this.getParentDy(otDy);
        if (parentDy == null) {
            return;
        }
        Date firstEffDate = parentDy.getDate("firstbsed");
        if (curEffDt.compareTo(firstEffDate) < 0) {
            this.addMsg(otDy, String.format(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u4e0a\u7ea7\u7ec4\u7ec7\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f\u201c%s\u201d\u3002", (String)"AbstractBizValidator_7", (String)"hrmp-haos-mservice", (Object[])new Object[0]), HRDateTimeUtils.formatDate((Date)firstEffDate)));
        }
    }

    private void checkStructNumber(DynamicObject otDy) {
        List boList;
        String structNumber = otDy.getString("structnumber");
        if (HRStringUtils.isEmpty((String)structNumber)) {
            return;
        }
        if (structNumber.length() != 12) {
            this.addMsg(otDy, String.format(ResManager.loadKDString((String)"\u7ed3\u6784\u7f16\u7801\u201c%s\u201d\u957f\u5ea6\u4e0d\u662f12\u4f4d\u3002", (String)"AddBizValidator_2", (String)"hrmp-haos-mservice", (Object[])new Object[0]), structNumber));
        }
        if (structNumber.contains("!")) {
            this.addMsg(otDy, String.format(ResManager.loadKDString((String)"\u7ed3\u6784\u7f16\u7801\u201c%s\u201d\u4e0d\u80fd\u5305\u542b\uff01\u5b57\u7b26\u3002", (String)"AddBizValidator_1", (String)"hrmp-haos-mservice", (Object[])new Object[0]), structNumber));
        }
        if (this.structNumberVsBoList == null) {
            Set structNumberSet = this.otList.stream().filter(dy -> HRStringUtils.isNotEmpty((String)dy.getString("structnumber"))).map(dy -> dy.getString("structnumber")).collect(Collectors.toSet());
            DynamicObjectCollection dbOtCol = OTQueryRepository.getInstance().queryColByStructNumber("boid,structnumber", structNumberSet);
            this.structNumberVsBoList = Stream.concat(dbOtCol.stream(), this.otList.stream()).collect(Collectors.groupingBy(dy -> dy.getString("structnumber"), Collectors.mapping(dy -> dy.getLong("boid"), Collectors.toList())));
        }
        if ((boList = this.structNumberVsBoList.getOrDefault(structNumber, Collections.emptyList())).size() > 1) {
            this.addMsg(otDy, String.format(ResManager.loadKDString((String)"\u7ed3\u6784\u7f16\u7801\u201c%s\u201d\u5df2\u5b58\u5728\u3002", (String)"AddBizValidator_0", (String)"hrmp-haos-mservice", (Object[])new Object[0]), structNumber));
        }
    }
}

