/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.mservice.ot.valid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.orgteam.OTQueryRepository;
import kd.hr.haos.business.service.projectgroup.valid.ProjectGroupValidHelper;
import kd.hr.haos.common.model.cascade.CycleCheckResultWithType;
import kd.hr.haos.mservice.ot.valid.AbstractBizValidator;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class ChangeBizValidator
extends AbstractBizValidator {
    private List<DynamicObject> parentChangedList;
    private Map<Long, List<DynamicObject>> parentMap;

    public ChangeBizValidator(List<DynamicObject> otList) {
        super(otList);
    }

    @Override
    public void valid() {
        this.parentChangedList = new ArrayList<DynamicObject>(this.otList.size());
        List<String> parentMustInput = Arrays.asList("org", "number", "name", "parent", "bsed", "otclassify");
        List<String> changeMustInput = Arrays.asList("org", "number", "name", "bsed", "otclassify");
        List<String> parentValid = Arrays.asList("org", "parent", "otclassify");
        List<String> changeValid = Arrays.asList("org", "otclassify");
        this.otList.forEach(otDy -> {
            boolean parentChange = this.parentChange((DynamicObject)otDy);
            this.checkMustInput((DynamicObject)otDy, parentChange ? parentMustInput : changeMustInput);
            this.checkBdValid((DynamicObject)otDy, parentChange ? parentValid : changeValid);
            this.checkEnableValid((DynamicObject)otDy);
            this.checkNumber((DynamicObject)otDy);
            this.checkName((DynamicObject)otDy);
            this.checkFutureDate((DynamicObject)otDy);
            if ("1".equals(otDy.getString("enable"))) {
                this.checkEffDate((DynamicObject)otDy);
            }
            this.checkEnable((DynamicObject)otDy);
            this.checkTextLength((DynamicObject)otDy);
            this.checkEffDateByChild((DynamicObject)otDy);
            if (parentChange) {
                this.checkParentEnable((DynamicObject)otDy);
                this.checkEffDateByParent((DynamicObject)otDy);
                this.parentChangedList.add((DynamicObject)otDy);
            }
        });
        if (!CollectionUtils.isEmpty(this.parentChangedList)) {
            this.batchCheckCoopAff();
        }
    }

    @Override
    protected List<CycleCheckResultWithType> doBatchCheckCoopRelIsRinged() {
        return ProjectGroupValidHelper.checkCoopAffRel(this.parentChangedList, (boolean)true);
    }

    private void checkEffDateByParent(DynamicObject otDy) {
        Date firstEffDate;
        Date curEffDt = otDy.getDate("bsed");
        if (curEffDt == null) {
            return;
        }
        long parentBoId = this.getParentId(otDy);
        DynamicObject parentDy = this.getCurrentOtMap().get(parentBoId);
        if (parentDy != null && curEffDt.compareTo(firstEffDate = parentDy.getDate("firstbsed")) < 0) {
            this.addMsg(otDy, String.format(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u4e0a\u7ea7\u7ec4\u7ec7\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f\u201c%s\u201d\u3002", (String)"AbstractBizValidator_7", (String)"hrmp-haos-mservice", (Object[])new Object[0]), HRDateTimeUtils.formatDate((Date)firstEffDate)));
        }
    }

    private void checkEffDateByChild(DynamicObject otDy) {
        Date curEffDt = otDy.getDate("bsed");
        if (!"10".equals(otDy.getString("enable")) || curEffDt == null) {
            return;
        }
        List<DynamicObject> list = this.getParentMap().get(otDy.getLong("boid"));
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Optional<DynamicObject> opt = list.stream().filter(dy -> curEffDt.compareTo(dy.getDate("firstbsed")) > 0).findFirst();
        opt.ifPresent(dynamicObject -> this.addMsg(otDy, String.format(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u4e0b\u7ea7\u7ec4\u7ec7\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f\u201c%s\u201d\u3002", (String)"ChangeBizValidator_1", (String)"hrmp-haos-mservice", (Object[])new Object[0]), HRDateTimeUtils.formatDate((Date)dynamicObject.getDate("firstbsed")))));
    }

    private void checkEnable(DynamicObject otDy) {
        String enable = this.getCurrentOtMap().get(otDy.getLong("boid")).getString("enable");
        if ("0".equals(enable)) {
            this.addMsg(otDy, ResManager.loadKDString((String)"\u7ec4\u7ec7\u5df2\u505c\u7528", (String)"ChangeBizValidator_0", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
        }
    }

    private boolean parentChange(DynamicObject otDy) {
        DynamicObject dbDy = this.getCurrentOtMap().get(otDy.getLong("boid"));
        return this.getParentId(otDy) != dbDy.getLong("parent.id");
    }

    private Map<Long, List<DynamicObject>> getParentMap() {
        if (this.parentMap != null) {
            return this.parentMap;
        }
        Set set = this.otList.stream().filter(otDy -> "10".equals(otDy.getString("enable"))).map(otDy -> otDy.getLong("boid")).collect(Collectors.toSet());
        DynamicObjectCollection col = OTQueryRepository.getInstance().queryColByParent("firstbsed,boid,bsed,parent.id,enable", set);
        Set<Long> orgSet = this.getOtMap().keySet();
        this.parentMap = col.stream().filter(otDy -> !orgSet.contains(otDy.getLong("boid"))).collect(Collectors.groupingBy(dy -> dy.getLong("parent.id")));
        this.otList.forEach(otDy -> {
            long parentId = this.getParentId((DynamicObject)otDy);
            if (0L != parentId) {
                List list = this.parentMap.computeIfAbsent(this.getParentId((DynamicObject)otDy), k -> new ArrayList(10));
                list.add(otDy);
            }
        });
        return this.parentMap;
    }
}

