/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.mservice.pjt;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.haos.business.domain.repository.prjorg.PRJOrgRepository;
import kd.hr.haos.common.model.prj.CheckResult;
import kd.hr.haos.mservice.pjt.AddBatchService;
import kd.hr.haos.mservice.pjt.ChangeInfoBatchService;
import kd.hr.haos.mservice.pjt.ChangeParentBatchService;
import kd.hr.haos.mservice.pjt.DisableBatchService;
import kd.hr.haos.mservice.util.ParamCheckUtils;

public abstract class AbstractDataBatchService<T> {
    private static final Log LOGGER = LogFactory.getLog(AbstractDataBatchService.class);
    private Map<String, Object> param;
    private boolean multiBatch;
    private boolean checkBoIdExist;
    private boolean checkBoIdNotExist;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Map<String, Object> execute(Map<String, Object> param) {
        ApiResult apiResult = ApiResult.success(null);
        try {
            this.init(param);
            CheckResult<String> mustInputCheckResult = this.mustInputCheck(param);
            if (!mustInputCheckResult.isSuccess()) {
                ApiResult fail = ApiResult.fail((String)"check fail", (String)"202");
                fail.setData((Object)mustInputCheckResult.getKeyVsMsg());
                return ApiResult.toMap((ApiResult)fail);
            }
            CheckResult<String> boIdCheckResult = this.boIdCheck(param);
            if (!boIdCheckResult.isSuccess()) {
                ApiResult fail = ApiResult.fail((String)"check fail", (String)"203");
                fail.setData((Object)boIdCheckResult.getKeyVsMsg());
                return ApiResult.toMap((ApiResult)fail);
            }
            T pjtList = this.map2T(param);
            this.beforeCheck(pjtList);
            CheckResult<String> check = this.check(pjtList);
            this.beforeSave(pjtList);
            if (!check.isSuccess()) {
                ApiResult fail = ApiResult.fail((String)"check fail", (String)"201");
                fail.setData((Object)check.getKeyVsMsg());
                return ApiResult.toMap((ApiResult)fail);
            }
            if (this.multiBatch) {
                this.save(pjtList);
                return ApiResult.toMap((ApiResult)apiResult);
            }
            try (TXHandle txHandle = TX.requiresNew();){
                try {
                    this.save(pjtList);
                }
                catch (Exception ex) {
                    txHandle.markRollback();
                    LOGGER.error((Throwable)ex);
                    Map map = ApiResult.toMap((ApiResult)ApiResult.ex((Throwable)ex, (boolean)true));
                    if (txHandle == null) return map;
                    if (throwable == null) {
                        txHandle.close();
                        return map;
                    }
                    try {
                        txHandle.close();
                        return map;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        return map;
                    }
                }
            }
            this.afterSave(pjtList);
            return ApiResult.toMap((ApiResult)apiResult);
        }
        catch (Exception ex) {
            LOGGER.error((Throwable)ex);
            apiResult = ApiResult.ex((Throwable)ex, (boolean)true);
        }
        return ApiResult.toMap((ApiResult)apiResult);
    }

    private CheckResult<String> boIdCheck(Map<String, Object> param) {
        CheckResult<String> checkResult = this.boIdDuplicatedCheck(param);
        if (checkResult.isSuccess()) {
            checkResult = this.boIdExistCheck(param);
        }
        return checkResult;
    }

    private CheckResult<String> boIdExistCheck(Map<String, Object> param) {
        String message;
        CheckResult checkResult = new CheckResult();
        checkResult.setSuccess(true);
        List data = (List)param.get("data");
        Set boidSet = data.stream().map(dataMap -> Long.valueOf(dataMap.get("boid").toString())).collect(Collectors.toSet());
        DynamicObject[] pjts = PRJOrgRepository.getInstance().queryByPks("id", boidSet);
        List idList = Arrays.stream(pjts).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        if (this.isCheckBoIdExist() && idList.size() > 0) {
            checkResult.setSuccess(false);
            checkResult.setKeyVsMsg(new HashMap());
            message = ResManager.loadKDString((String)"\u5728\u672c\u6279\u6b21\u4e2d\u6709\u5df2\u5b58\u5728BOID\uff1a%s\u3002", (String)"AbstractDataBatchService_2", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
            checkResult.getKeyVsMsg().put("0", Collections.singletonList(String.format(message, idList)));
        }
        if (this.isCheckBoIdNotExist() && idList.size() != boidSet.size()) {
            boidSet.removeAll(idList);
            checkResult.setSuccess(false);
            checkResult.setKeyVsMsg(new HashMap());
            message = ResManager.loadKDString((String)"\u5728\u672c\u6279\u6b21\u4e2d\u6709\u4e0d\u5b58\u5728BOID\uff1a%s\u3002", (String)"AbstractDataBatchService_3", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
            checkResult.getKeyVsMsg().put("0", Collections.singletonList(String.format(message, boidSet)));
        }
        return checkResult;
    }

    private CheckResult<String> boIdDuplicatedCheck(Map<String, Object> param) {
        return ParamCheckUtils.keyDuplicatedCheck((List)param.get("data"), "boid");
    }

    protected void init(Map<String, Object> param) {
        this.param = param;
        this.multiBatch = false;
    }

    protected CheckResult<String> mustInputCheck(Map<String, Object> param) {
        return ParamCheckUtils.mustInputCheck((List)param.get("data"), Collections.singleton("boid"));
    }

    protected abstract Set<String> getMustInputFieldSet();

    protected abstract T map2T(Map<String, Object> var1);

    protected abstract void beforeCheck(T var1);

    protected abstract CheckResult<String> check(T var1);

    protected void beforeSave(T pjtList) {
        if (this instanceof AddBatchService || this instanceof ChangeInfoBatchService || this instanceof ChangeParentBatchService || this instanceof DisableBatchService) {
            List dyList = (List)pjtList;
            dyList.forEach(dy -> {
                Object changeReason = dy.get("changereason");
                if (changeReason != null && !(changeReason instanceof DynamicObject)) {
                    dy.set("changereason", null);
                }
            });
        }
    }

    protected abstract void save(T var1);

    protected abstract void afterSave(T var1);

    protected final <T> T getOrIfNullVal(T val, Supplier<T> defaultVal) {
        return val != null ? val : defaultVal.get();
    }

    protected Map<String, Object> getParam() {
        return this.param;
    }

    protected boolean isMultiBatch() {
        return this.multiBatch;
    }

    protected <T> CheckResult<T> createCheckResult(Map<T, List<String>> result) {
        CheckResult checkResult = new CheckResult();
        if (result.size() == 0) {
            checkResult.setSuccess(true);
        } else {
            checkResult.setSuccess(false);
        }
        checkResult.setKeyVsMsg(result);
        return checkResult;
    }

    public void setCheckBoIdExist(boolean checkBoIdExist) {
        this.checkBoIdExist = checkBoIdExist;
    }

    public void setCheckBoIdNotExist(boolean checkBoIdNotExist) {
        this.checkBoIdNotExist = checkBoIdNotExist;
    }

    private boolean isCheckBoIdExist() {
        return this.checkBoIdExist;
    }

    private boolean isCheckBoIdNotExist() {
        return this.checkBoIdNotExist;
    }
}

