/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.mservice.pjt;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.haos.business.service.projectgroup.service.ProTeamMsgService;
import kd.hr.haos.business.service.projectgroup.service.ProjChangeEventService;
import kd.hr.haos.business.service.projectgroup.service.ProjectGroupChangeService;
import kd.hr.haos.common.constants.projectgroup.ProjectGroupMDConstants;
import kd.hr.haos.common.model.DyMapModel;
import kd.hr.haos.common.model.prj.CheckResult;
import kd.hr.haos.common.model.prj.OpParam;
import kd.hr.haos.common.util.dyconverter.Map2Dy;
import kd.hr.haos.mservice.pjt.AbstractDataBatchService;
import kd.hr.haos.mservice.pjt.valid.ChangeCheckHelper;
import kd.hr.hbp.business.domain.model.newhismodel.BatchVersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class ChangeInfoBatchService
extends AbstractDataBatchService<List<DynamicObject>> {
    HisResponse<BatchVersionChangeRespData> hisResponse;

    public ChangeInfoBatchService() {
        this.setCheckBoIdNotExist(true);
    }

    @Override
    protected Set<String> getMustInputFieldSet() {
        return new HashSet<String>(Collections.singletonList("boid"));
    }

    @Override
    protected List<DynamicObject> map2T(Map<String, Object> param) {
        List data = (List)param.get("data");
        DyMapModel dyMapModel = new DyMapModel();
        dyMapModel.setData(data);
        dyMapModel.setMetadata("haos_projectgroupbase");
        dyMapModel.setIgnoreKeySet(new HashSet<String>(Arrays.asList("number", "establishmentdate", "parentorg", "bsled", "projectteam", "parentprojectteam", "belongadminorg", "rootprojectteam", "projectidentify", "structnumber", "org", "entryentity", "opreatetype", "changetype", "modifier", "creator", "modifytime", "createtime", "enable", "status", "initbatch", "initdatasource", "initstatus")));
        dyMapModel.setOriginalKey("boid");
        Map2Dy map2Dy = new Map2Dy();
        return map2Dy.map2DynamicObject(dyMapModel);
    }

    @Override
    protected CheckResult<String> check(List<DynamicObject> dynamicObjectList) {
        ChangeCheckHelper changeCheckHelper = new ChangeCheckHelper(false);
        changeCheckHelper.init(dynamicObjectList);
        Map<String, List<String>> result = changeCheckHelper.check();
        return this.createCheckResult(result);
    }

    @Override
    protected void beforeCheck(List<DynamicObject> pjtList) {
        this.setDefaultValue(pjtList);
    }

    @Override
    protected void save(List<DynamicObject> pjtList) {
        OpParam opParam = new OpParam();
        opParam.setOpType("donothing_confirmchangeinfo");
        ProjectGroupChangeService changeService = new ProjectGroupChangeService(opParam);
        changeService.setEventId(Long.valueOf(ORM.create().genLongId("haos_projectgroupbase")));
        changeService.setPrjOrgs(pjtList.toArray(new DynamicObject[0]));
        changeService.init();
        this.hisResponse = changeService.change();
        ProjChangeEventService.handleChangeEventHis(this.hisResponse, (String)"haos_projteambaseinfo", (Boolean)true);
    }

    @Override
    protected void afterSave(List<DynamicObject> pjtList) {
        ProTeamMsgService.getInstance().sendProTeamChgMsg(this.hisResponse);
    }

    private void setDefaultValue(List<DynamicObject> dynamicObjectList) {
        Date date2999 = new HisEffDateCommonService().getDate2999(null);
        Date now = new Date();
        DynamicObject changeInfoChangeOperateDy = BusinessDataServiceHelper.loadSingle((Object)ProjectGroupMDConstants.CHANGE_OPERATE_CHANGE_INFO, (String)"haos_projchangeoperate");
        DynamicObject changeInfoChangeTypeDy = BusinessDataServiceHelper.loadSingle((Object)ProjectGroupMDConstants.CHANGETYPE_CHANGEPINFO, (String)"haos_projchangetype");
        dynamicObjectList.forEach(dy -> {
            dy.set("bsed", (Object)HRDateTimeUtils.truncateDate((Date)dy.getDate("bsed")));
            dy.set("bsled", (Object)date2999);
            dy.set("createtime", (Object)this.getOrIfNullVal(dy.getDate("createtime"), () -> now));
            dy.set("modifytime", (Object)this.getOrIfNullVal(dy.getDate("modifytime"), () -> now));
            dy.set("changeoperate", (Object)changeInfoChangeOperateDy);
            dy.set("changetype", (Object)changeInfoChangeTypeDy);
        });
    }
}

