/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.mservice.pjt;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.haos.business.domain.repository.prjorg.PRJOrgRepository;
import kd.hr.haos.business.domain.service.impl.teamcoop.TeamCoopRelServiceImpl;
import kd.hr.haos.business.service.adminorg.bean.TeamCoopRelBO;
import kd.hr.haos.business.service.projectgroup.service.ProjChangeEventService;
import kd.hr.haos.common.constants.projectgroup.ProjectGroupMDConstants;
import kd.hr.haos.common.model.DyMapModel;
import kd.hr.haos.common.model.prj.CheckResult;
import kd.hr.haos.common.util.dyconverter.Map2Dy;
import kd.hr.haos.mservice.pjt.AbstractDataBatchService;
import kd.hr.haos.mservice.pjt.valid.SaveCoopRelCheckHelper;

public class SaveCoopRelBatchService
extends AbstractDataBatchService<List<DynamicObject>> {
    private Date effectDate;

    public SaveCoopRelBatchService() {
        this.setCheckBoIdNotExist(true);
    }

    @Override
    protected Set<String> getMustInputFieldSet() {
        return new HashSet<String>(Collections.singletonList("boid"));
    }

    @Override
    protected List<DynamicObject> map2T(Map<String, Object> param) {
        List data = (List)param.get("data");
        DyMapModel dyMapModel = new DyMapModel();
        dyMapModel.setData(data);
        dyMapModel.setMetadata("haos_projteamcooprelalter");
        dyMapModel.setIgnoreKeySet(new HashSet());
        dyMapModel.setOriginalKey("boid");
        Map2Dy map2Dy = new Map2Dy();
        List dynamicObjects = map2Dy.map2DynamicObject(dyMapModel);
        if (dynamicObjects.size() > 0) {
            this.effectDate = ((DynamicObject)dynamicObjects.get(0)).getDate("bsed");
        }
        return dynamicObjects;
    }

    @Override
    protected CheckResult<String> check(List<DynamicObject> pjtList) {
        SaveCoopRelCheckHelper saveCoopRelCheckHelper = new SaveCoopRelCheckHelper();
        saveCoopRelCheckHelper.init(pjtList);
        Map<String, List<String>> result = saveCoopRelCheckHelper.check();
        return this.createCheckResult(result);
    }

    @Override
    protected void beforeCheck(List<DynamicObject> pjtList) {
        this.setDefaultValue(pjtList);
    }

    @Override
    protected void save(List<DynamicObject> pjtList) {
        Map<Long, List<TeamCoopRelBO>> orgTeamIdVsRelBoList = pjtList.stream().map(pjt -> {
            long pjtBoId = pjt.getLong("boid");
            DynamicObjectCollection coopRelEntry = pjt.getDynamicObjectCollection("entryentity");
            return coopRelEntry.stream().map(coopRelRow -> {
                TeamCoopRelBO teamCoopRelBO = new TeamCoopRelBO(Long.valueOf(pjtBoId), Long.valueOf(coopRelRow.getLong("coopreltype.id")), Long.valueOf(coopRelRow.getLong("cooporgteam.id")), coopRelRow.getInt("seq"));
                teamCoopRelBO.setBoId(Long.valueOf(coopRelRow.getLong("cooprelboid")));
                teamCoopRelBO.setEffDate(this.effectDate);
                return teamCoopRelBO;
            }).collect(Collectors.toList());
        }).flatMap(Collection::stream).collect(Collectors.groupingBy(TeamCoopRelBO::getOrgTeamId));
        pjtList.forEach(pjt -> orgTeamIdVsRelBoList.computeIfAbsent(pjt.getLong("boid"), id -> Collections.emptyList()));
        TeamCoopRelServiceImpl.getInstance().batchChangeAll(orgTeamIdVsRelBoList, this.effectDate, null);
        Map<Long, DynamicObject> boIdVsCurBatchPjt = pjtList.stream().collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy));
        DynamicObject[] hisPjts = PRJOrgRepository.getInstance().queryEffectingHisData("id, boid, bsed, changescene, changereason, changeoperate, changetype", boIdVsCurBatchPjt.keySet());
        Arrays.stream(hisPjts).forEach(dbPjt -> {
            DynamicObject curBatchPjt = (DynamicObject)boIdVsCurBatchPjt.get(dbPjt.getLong("boid"));
            dbPjt.set("changescene", curBatchPjt.get("changescene"));
            dbPjt.set("changereason", curBatchPjt.get("changereason"));
            dbPjt.set("changeoperate", curBatchPjt.get("changeoperate"));
            dbPjt.set("changetype", curBatchPjt.get("changetype"));
        });
        ProjChangeEventService.handleCoopRelChangeEvent((DynamicObject[])hisPjts);
    }

    @Override
    protected void afterSave(List<DynamicObject> pjtList) {
    }

    private void setDefaultValue(List<DynamicObject> pjtList) {
        DynamicObject relSaveChangeOperateDy = BusinessDataServiceHelper.loadSingle((Object)ProjectGroupMDConstants.CHANGE_OPERATE_COOPERATE, (String)"haos_projchangeoperate");
        DynamicObject relSaveChangeTypeDy = BusinessDataServiceHelper.loadSingle((Object)ProjectGroupMDConstants.CHANGETYPE_SAVE_COOP_REL, (String)"haos_projchangetype");
        pjtList.forEach(pjt -> {
            pjt.set("changeoperate", (Object)relSaveChangeOperateDy);
            pjt.set("changetype", (Object)relSaveChangeTypeDy);
        });
    }
}

