/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.mservice.pjt.valid;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.haos.business.domain.repository.teamcoop.TeamCoopRelRepository;
import kd.hr.haos.business.service.projectgroup.valid.ProjectGroupValidHelper;
import kd.hr.haos.business.util.LocalDateRangeUtils;
import kd.hr.haos.common.constants.projectgroup.ProjectGroupMDConstants;
import kd.hr.haos.common.model.cascade.CycleCheckResultWithType;
import kd.hr.haos.mservice.pjt.valid.AbstractCheckHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class SaveCoopRelCheckHelper
extends AbstractCheckHelper {
    Map<Long, Date> coopRelBoIdVsBsed;
    Map<Long, List<DynamicObject>> boVsCoopRelList;

    @Override
    public void init(List<DynamicObject> pjtList) {
        super.init(pjtList);
        super.initChangeTypeDy(ProjectGroupMDConstants.CHANGETYPE_SAVE_COOP_REL);
    }

    public Map<String, List<String>> check() {
        super.batchCheckSameBsed();
        this.pjtList.forEach(pjt -> {
            super.checkFutureBsed((DynamicObject)pjt);
            super.checkChangeSceneAndChangeReason((DynamicObject)pjt);
            super.checkEnable((DynamicObject)pjt);
            super.checkEntryMustInput((DynamicObject)pjt);
            super.checkCoopRelType((DynamicObject)pjt);
            super.checkCoopOrg((DynamicObject)pjt);
            super.checkMustInput((DynamicObject)pjt);
            super.checkBdValid((DynamicObject)pjt, Collections.singletonList("changescene"));
            this.checkCoopRelBoId((DynamicObject)pjt);
            this.checkBsed((DynamicObject)pjt);
            this.checkCoopRelBsed((DynamicObject)pjt);
        });
        if (this.isCoopEntryCheck()) {
            super.batchCheckCoopRelIsRinged();
        }
        return this.result;
    }

    @Override
    protected List<CycleCheckResultWithType> doBatchCheckCoopRelIsRinged() {
        return ProjectGroupValidHelper.checkCoopRel4CoopRelChange((List)this.pjtList);
    }

    @Override
    protected List<String> getMustInputCheckList() {
        return Arrays.asList("changescene", "bsed");
    }

    @Override
    protected String getCheckCoopOrgMessage() {
        return ResManager.loadKDString((String)"\u534f\u4f5c\u5173\u7cfb\u5206\u5f55\u7b2c%1$s\u884c\uff1a\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u534f\u4f5c\u7ec4\u7ec7\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f(%2$s)\u3002", (String)"SaveCoopRelCheckHelper_2", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
    }

    private void checkCoopRelBoId(DynamicObject pjt) {
        Date effDate = pjt.getDate("bsed");
        if (effDate == null) {
            return;
        }
        DynamicObjectCollection coopRelEntry = pjt.getDynamicObjectCollection("entryentity");
        List coopRelList = this.getBoVsCoopRelList().getOrDefault(pjt.getLong("boid"), Collections.emptyList());
        Set coopRelBoIdSet = coopRelList.stream().map(coopRel -> coopRel.getLong("boid")).collect(Collectors.toSet());
        for (int i = 0; i < coopRelEntry.size(); ++i) {
            boolean exist;
            long coopRelId = ((DynamicObject)coopRelEntry.get(i)).getLong("cooprelboid");
            if (coopRelId == 0L || (exist = coopRelBoIdSet.contains(coopRelId))) continue;
            String msg = ResManager.loadKDString((String)"\u534f\u4f5c\u5173\u7cfb\u5206\u5f55\u7b2c%s\u884c\uff1a\u534f\u4f5c\u5173\u7cfbBOID\u4f20\u503c\u4e0d\u5b58\u5728\u3002", (String)"SaveCoopRelCheckHelper_4", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
            this.addMsg(pjt, String.format(msg, i + 1));
        }
    }

    private void checkBsed(DynamicObject pjt) {
        Date effDate = pjt.getDate("bsed");
        if (effDate == null) {
            return;
        }
        Date estDate = pjt.getDate("establishmentdate");
        if (ProjectGroupValidHelper.checkDateEarlier((Date)effDate, (Date)estDate)) {
            String msg = ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u9879\u76ee\u56e2\u961f\u6210\u7acb\u65e5\u671f\u201c%s\u201d\u3002", (String)"SaveCoopRelCheckHelper_3", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
            this.addMsg(pjt, String.format(msg, HRDateTimeUtils.formatDate((Date)estDate)));
        }
    }

    private void checkCoopRelBsed(DynamicObject pjt) {
        List effectingBsedList;
        Date minDate;
        Date effDate = pjt.getDate("bsed");
        if (effDate == null) {
            return;
        }
        DynamicObjectCollection coopRelEntry = pjt.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < coopRelEntry.size(); ++i) {
            Date bsed;
            long coopRelId = ((DynamicObject)coopRelEntry.get(i)).getLong("cooprelboid");
            if (coopRelId == 0L || (bsed = this.getCoopRelBoIdVsBsed().get(coopRelId)) == null || !ProjectGroupValidHelper.checkDateEarlier((Date)effDate, (Date)bsed)) continue;
            String msg = ResManager.loadKDString((String)"\u534f\u4f5c\u5173\u7cfb\u5206\u5f55\u7b2c%1$s\u884c\uff1a\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u65e5\u671f(%2$s)\u3002", (String)"SaveCoopRelCheckHelper_5", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
            this.addMsg(pjt, String.format(msg, i + 1, HRDateTimeUtils.formatDate((Date)bsed)));
        }
        List effectingCoopRel = this.getBoVsCoopRelList().getOrDefault(pjt.getLong("boid"), Collections.emptyList());
        Set curBatchCoopRelBoSet = coopRelEntry.stream().map(dy -> dy.getLong("cooprelboid")).collect(Collectors.toSet());
        List deleteCoopRelList = effectingCoopRel.stream().filter(coopRel -> !curBatchCoopRelBoSet.contains(coopRel.getLong("boid"))).collect(Collectors.toList());
        if (deleteCoopRelList.size() != 0 && ProjectGroupValidHelper.checkDateEarlier((Date)effDate, (Date)(minDate = LocalDateRangeUtils.getMinDate(effectingBsedList = deleteCoopRelList.stream().map(dy -> dy.getDate("bsed")).collect(Collectors.toList()))))) {
            String msg = ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u88ab\u5220\u9664\u534f\u4f5c\u5173\u7cfb\u7684\u5f53\u524d\u751f\u6548\u65e5\u671f\u201c%s\u201d\u3002", (String)"SaveCoopRelCheckHelper_6", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
            this.addMsg(pjt, String.format(msg, HRDateTimeUtils.formatDate((Date)minDate)));
        }
    }

    @Override
    protected String getCheckEnableMessage() {
        return ResManager.loadKDString((String)"\u53ea\u6709\u542f\u7528\u7684\u6570\u636e\u624d\u80fd\u64cd\u4f5c\u201c\u53d8\u66f4\u201d\u3002", (String)"SaveCoopRelCheckHelper_1", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
    }

    private Map<Long, Date> getCoopRelBoIdVsBsed() {
        if (this.coopRelBoIdVsBsed == null) {
            this.initCoopRelMap();
        }
        return this.coopRelBoIdVsBsed;
    }

    private Map<Long, List<DynamicObject>> getBoVsCoopRelList() {
        if (this.boVsCoopRelList == null) {
            this.initCoopRelMap();
        }
        return this.boVsCoopRelList;
    }

    private void initCoopRelMap() {
        Set coopRelBoIdSet = this.pjtList.stream().map(pjt -> pjt.getDynamicObjectCollection("entryentity")).flatMap(Collection::stream).map(coopRow -> coopRow.getLong("cooprelboid")).collect(Collectors.toSet());
        DynamicObject[] coopRelDys = TeamCoopRelRepository.getInstance().queryOriginalArrayById("id, boid, bsed, iscurrentversion", coopRelBoIdSet);
        this.coopRelBoIdVsBsed = Arrays.stream(coopRelDys).filter(dy -> dy.getBoolean("iscurrentversion")).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy.getDate("bsed")));
        Set boSet = this.pjtList.stream().map(pjt -> pjt.getLong("boid")).collect(Collectors.toSet());
        DynamicObject[] allCoopRelDys = TeamCoopRelRepository.getInstance().queryOriginalArray4EnabledCurrentVersionWithoutAdByOt("id, org.id, boid, bsed", boSet);
        this.boVsCoopRelList = Arrays.stream(allCoopRelDys).collect(Collectors.groupingBy(coopRelDy -> coopRelDy.getLong("org.id")));
    }
}

