/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.mservice.webapi.api.controller.adminorg;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.mservice.webapi.api.constants.WebApiErrorCode;
import kd.hr.haos.mservice.webapi.api.constants.WebApiServiceHelperConstants;
import kd.hr.haos.mservice.webapi.api.model.adminorg.AdminOrgBaseInfoResultModel;
import kd.hr.haos.mservice.webapi.api.utils.AdminOrgWebApiUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;

@ApiController(value="odc", desc="adminOrgBaseInfoSearch")
@ApiMapping(value="/openapi/adminorgbaseinfosearch")
public class AdminOrgBaseInfoSearchController
implements Serializable {
    private static final int MAX_COUNTS = 1000;
    private static final long serialVersionUID = -54188824227852339L;

    @ApiPostMapping(value="getAdminOrgBaseInfo")
    public CustomApiResult<List<AdminOrgBaseInfoResultModel>> getAdminOrgBaseInfo(@ApiParam(value="\u65e5\u671f\uff08\u6587\u672c\uff09", required=true, example="2022-08-08") @ApiParam(value="\u65e5\u671f\uff08\u6587\u672c\uff09", required=true, example="2022-08-08") String dateString, @ApiParam(value="\u7f16\u7801\u96c6\u5408", required=true) @ApiParam(value="\u7f16\u7801\u96c6\u5408", required=true) List<String> numberList) throws ParseException {
        if (numberList.size() > 1000) {
            throw new OpenApiException(String.valueOf((Object)WebApiErrorCode.MAX_COUNTS_EXCEED_1000));
        }
        Date date = HRDateTimeUtils.parseDate((String)dateString, (String)"yyyy-MM-dd");
        ArrayList<Long> idList = new ArrayList(numberList.size());
        idList = AdminOrgWebApiUtils.getAdminOrgIdByNumber(numberList, date);
        ArrayList<AdminOrgBaseInfoResultModel> resultList = new ArrayList<AdminOrgBaseInfoResultModel>(numberList.size());
        AdminOrgBaseInfoResultModel model = new AdminOrgBaseInfoResultModel();
        QFilter idFilter = new QFilter("boid", "in", idList);
        DynamicObject[] dynamicObjects = AdminOrgWebApiUtils.queryAdminHisInfo(idFilter, date);
        Map<Long, DynamicObject> companyMap = AdminOrgWebApiUtils.getBasicDataInfo(WebApiServiceHelperConstants.COMPANY_SERVICEHELPER, idList, date, "adminorg.id,companytype,industrytype,iscurrentversion");
        Map<Long, DynamicObject> depMap = AdminOrgWebApiUtils.getBasicDataInfo(WebApiServiceHelperConstants.DEPARTMENT_SERVICEHELPER, idList, date, "adminorg.id,departmenttype");
        Map<Long, DynamicObject> groupMap = AdminOrgWebApiUtils.getBasicDataInfo(WebApiServiceHelperConstants.GROUP_SERVICEHELPER, idList, date, "adminorg.id,groupvision,groupmission");
        HashMap<Long, DynamicObject> companyNameMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObject depDynObj;
            DynamicObject companyDynObj;
            model = new AdminOrgBaseInfoResultModel();
            model.setBoid(dynamicObject.getLong("boid"));
            model.setVid((Long)dynamicObject.getPkValue());
            model.setName(dynamicObject.getString("name"));
            model.setNumber(dynamicObject.getString("number"));
            model.setAdminOrgTypeName(dynamicObject.getString("adminorgtype.name"));
            model.setAdminOrgTypeNumber(dynamicObject.getString("adminorgtype.number"));
            model.setParentBoid(dynamicObject.getLong("parentorg.boid"));
            model.setParenName(dynamicObject.getString("parentorg.name"));
            model.setParentNumber(dynamicObject.getString("parentorg.number"));
            model.setEstablishmentDate(dynamicObject.getDate("establishmentdate"));
            Long belongCompanyBoId = dynamicObject.getLong("belongcompany.boid");
            if (!HRObjectUtils.isEmpty((Object)belongCompanyBoId)) {
                if (!HRObjectUtils.isEmpty(companyNameMap.get(belongCompanyBoId))) {
                    DynamicObject belongCompanyDynObj = (DynamicObject)companyNameMap.get(belongCompanyBoId);
                    model.setBelongCompanyName(belongCompanyDynObj.getString("name"));
                    model.setBelongCompanyNumber(belongCompanyDynObj.getString("number"));
                } else {
                    QFilter belongCompanyIdFilter = new QFilter("boid", "=", (Object)belongCompanyBoId);
                    DynamicObject[] belongCompanyDynObjs = AdminOrgWebApiUtils.queryAdminHisInfo(belongCompanyIdFilter, date);
                    if (belongCompanyDynObjs.length > 0) {
                        DynamicObject belongCompanyDynObj = belongCompanyDynObjs[0];
                        model.setBelongCompanyName(belongCompanyDynObj.getString("name"));
                        model.setBelongCompanyNumber(belongCompanyDynObj.getString("number"));
                        companyNameMap.put(belongCompanyBoId, belongCompanyDynObj);
                    }
                }
            }
            model.setCorporateOrgName(dynamicObject.getString("corporateorg.name"));
            model.setCorporateOrgNumber(dynamicObject.getString("corporateorg.number"));
            model.setAdminOrgLayerName(dynamicObject.getString("adminorglayer.name"));
            model.setAdminOrgLayerNumber(dynamicObject.getString("adminorglayer.number"));
            model.setAdminOrgFunctionName(dynamicObject.getString("adminorgfunction.name"));
            model.setAdminOrgFunctionNumber(dynamicObject.getString("adminorgfunction.number"));
            model.setCompanyAreaName(dynamicObject.getString("companyarea.name"));
            model.setCompanyAreaNumber(dynamicObject.getString("companyarea.number"));
            model.setCityName(dynamicObject.getString("city.name"));
            model.setCityNumber(dynamicObject.getString("city.number"));
            model.setWorkplaceName(dynamicObject.getString("workplace.name"));
            model.setWorkplaceNumber(dynamicObject.getString("workplace.number"));
            model.setDetailaddress(dynamicObject.getString("detailaddress"));
            model.setIndex(dynamicObject.getInt("index"));
            model.setPositioning(dynamicObject.getString("positioning"));
            model.setMainduty(dynamicObject.getString("mainduty"));
            model.setSafeLevelName(dynamicObject.getString("safelevel.name"));
            model.setSafeLevelNumber(dynamicObject.getString("safelevel.number"));
            model.setSafeTypeName(dynamicObject.getString("safetype.name"));
            model.setSafeTypeNumber(dynamicObject.getString("safetype.number"));
            model.setEnable(dynamicObject.getString("enable"));
            DynamicObject groupDynObj = groupMap.get(dynamicObject.getLong("boid"));
            if (!HRObjectUtils.isEmpty((Object)groupDynObj)) {
                model.setGroupMission(groupDynObj.getString("groupmission"));
                model.setGroupVision(groupDynObj.getString("groupvision"));
            }
            if (!HRObjectUtils.isEmpty((Object)(companyDynObj = companyMap.get(dynamicObject.getLong("boid"))))) {
                model.setCompanyTypeName(companyDynObj.getString("companytype.name"));
                model.setCompanyTypeNumber(companyDynObj.getString("companytype.number"));
                model.setIndustryTypeName(companyDynObj.getString("industrytype.name"));
                model.setIndustryTypeNumber(companyDynObj.getString("industrytype.number"));
            }
            if (!HRObjectUtils.isEmpty((Object)(depDynObj = depMap.get(dynamicObject.getLong("boid"))))) {
                model.setDepartmentTypeName(depDynObj.getString("departmenttype.name"));
                model.setDepartmentTypeNumber(depDynObj.getString("departmenttype.number"));
            }
            resultList.add(model);
        }
        return CustomApiResult.success(resultList);
    }
}

