/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.mservice.webapi.api.controller.adminorg;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.mservice.webapi.api.constants.WebApiErrorCode;
import kd.hr.haos.mservice.webapi.api.constants.WebApiServiceHelperConstants;
import kd.hr.haos.mservice.webapi.api.model.adminorg.AdminOrgChangePageModel;
import kd.hr.haos.mservice.webapi.api.model.adminorg.AdminOrgChangeResultModel;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

@ApiController(value="odc", desc="adminOrgChangeSearch")
@ApiMapping(value="/openapi/query")
public class AdminOrgChangeSearchController
implements Serializable {
    private static final long serialVersionUID = -5814509286485779180L;

    @ApiPostMapping(value="getAdminOrgChangeSearch")
    public CustomApiResult<AdminOrgChangePageModel> getAdminOrgChangeSearch(@ApiParam(value="\u5f00\u59cb\u65e5\u671f", required=true, example="2022-01-01") @ApiParam(value="\u5f00\u59cb\u65e5\u671f", required=true, example="2022-01-01") Date startDateTime, @ApiParam(value="\u7ed3\u675f\u65e5\u671f", required=true, example="2022-01-10") @ApiParam(value="\u7ed3\u675f\u65e5\u671f", required=true, example="2022-01-10") Date endDateTime, @ApiParam(value="\u9875\u7801", required=false, example="1") @ApiParam(value="\u9875\u7801", required=false, example="1") int pageNo, @ApiParam(value="\u6761\u6570", required=false, example="1000") @ApiParam(value="\u6761\u6570", required=false, example="1000") int pageSize) {
        if (pageSize > 5000) {
            throw new OpenApiException(String.valueOf((Object)WebApiErrorCode.MAX_COUNTS_EXCEED_5000));
        }
        AdminOrgChangePageModel model = new AdminOrgChangePageModel(pageNo, pageSize);
        String entityName = "haos_changeoperdetail";
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityName);
        model.setRows(new ArrayList<AdminOrgChangeResultModel>(0));
        String selectProperties = "afterorg,changeoperate,createtime";
        DynamicObjectCollection changeOperateCol = helper.queryOriginalCollection(selectProperties, this.getQFilters(startDateTime, endDateTime));
        if (CollectionUtils.isEmpty((Collection)changeOperateCol)) {
            model.setLastPage(true);
            return CustomApiResult.success((Object)((Object)model));
        }
        Map<Long, DynamicObject> changeOperateMap = changeOperateCol.stream().collect(Collectors.toMap(dy -> dy.getLong("afterorg"), dy -> dy, (key1, key2) -> key2));
        selectProperties = "id,boid,number,name,parentorg.id,establishmentdate,bsed,enable";
        QFilter idQFilter = new QFilter("id", "in", changeOperateMap.keySet());
        DynamicObject[] orgDyArr = WebApiServiceHelperConstants.ADMINORGHELPER_SERVICEHELPER.query(selectProperties, new QFilter[]{idQFilter});
        int start = (model.getPageNo() - 1) * model.getPageSize();
        if (start >= orgDyArr.length) {
            model.setLastPage(true);
            return CustomApiResult.success((Object)((Object)model));
        }
        int end = start + model.getPageSize();
        model.setLastPage(end >= orgDyArr.length);
        ArrayList<AdminOrgChangeResultModel> list = new ArrayList<AdminOrgChangeResultModel>(orgDyArr.length);
        for (DynamicObject dy2 : orgDyArr) {
            list.add(this.buildRow(dy2, changeOperateMap.get(dy2.getLong("id"))));
        }
        this.setModelSort(list);
        list.sort((o1, o2) -> {
            int i = o1.getOperatTime().compareTo(o2.getOperatTime());
            return i == 0 ? o1.getSort() - o2.getSort() : i;
        });
        model.setRows(list.subList(start, model.getLastPage() ? list.size() : end));
        return CustomApiResult.success((Object)((Object)model));
    }

    private AdminOrgChangeResultModel buildRow(DynamicObject dy, DynamicObject changeOperateDy) {
        AdminOrgChangeResultModel row = new AdminOrgChangeResultModel();
        row.setBoid(dy.getLong("boid"));
        row.setName(dy.getString("name"));
        row.setEstablishmentDate(dy.getDate("establishmentdate"));
        row.setNumber(dy.getString("number"));
        row.setParentBoid(dy.getLong("parentorg.id"));
        row.setBsed(dy.getDate("bsed"));
        row.setEnable(dy.getString("enable"));
        if (changeOperateDy != null) {
            row.setChangeOperateId(changeOperateDy.getLong("changeoperate"));
            row.setOperatTime(changeOperateDy.getDate("createtime"));
        }
        return row;
    }

    private QFilter[] getQFilters(Date startDateTime, Date endDateTime) {
        QFilter filter = new QFilter("createtime", ">=", (Object)startDateTime);
        filter.and("createtime", "<", (Object)endDateTime);
        filter.and("org.otclassify", "=", (Object)1010L);
        return new QFilter[]{filter};
    }

    private void setModelSort(List<AdminOrgChangeResultModel> list) {
        Map<Date, List<AdminOrgChangeResultModel>> dateMap = list.stream().collect(Collectors.groupingBy(AdminOrgChangeResultModel::getOperatTime));
        for (List<AdminOrgChangeResultModel> valueList : dateMap.values()) {
            this.setSort(valueList);
        }
    }

    private void setSort(List<AdminOrgChangeResultModel> list) {
        if (list.size() == 1) {
            list.get(0).setSort(1);
            return;
        }
        AdminOrgChangeResultModel virtualRoot = new AdminOrgChangeResultModel();
        Map<Long, AdminOrgChangeResultModel> map = list.stream().collect(Collectors.toMap(AdminOrgChangeResultModel::getBoid, model -> model));
        list.forEach(node -> map.getOrDefault(node.getParentBoid(), virtualRoot).getSubList().add((AdminOrgChangeResultModel)((Object)node)));
        ArrayDeque queue = new ArrayDeque(16);
        virtualRoot.getSubList().forEach(node -> {
            node.setSort(1);
            queue.offer(node);
        });
        while (!queue.isEmpty()) {
            AdminOrgChangeResultModel poll = (AdminOrgChangeResultModel)((Object)queue.poll());
            poll.getSubList().forEach(node -> {
                node.setSort(poll.getSort() + 1);
                queue.offer(node);
            });
        }
    }
}

