/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.mservice.webapi.api.controller.adminorg;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.hr.haos.business.servicehelper.AdminOrgQueryServiceHelper;
import kd.hr.haos.mservice.webapi.api.constants.WebApiErrorCode;
import kd.hr.haos.mservice.webapi.api.model.adminorg.AdminOrgSubResultModel;
import kd.hr.haos.mservice.webapi.api.utils.AdminOrgWebApiUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;

@ApiController(value="odc", desc="adminOrgSubSearch")
@ApiMapping(value="/openapi/adminorgsubsearch")
public class AdminOrgSubSearchController
implements Serializable {
    private static final int MAX_COUNTS = 500;
    private static final long serialVersionUID = -8522581125733253320L;

    @ApiPostMapping(value="getAdminOrgSubInfo")
    public CustomApiResult<List<AdminOrgSubResultModel>> getAdminOrgSubInfo(@ApiParam(value="\u65e5\u671f\uff08\u6587\u672c\uff09", required=true, example="2022-08-08") @ApiParam(value="\u65e5\u671f\uff08\u6587\u672c\uff09", required=true, example="2022-08-08") String dateString, @ApiParam(value="\u7f16\u7801\u96c6\u5408", required=false) @ApiParam(value="\u7f16\u7801\u96c6\u5408", required=false) List<String> numberList, @ApiParam(value="\u7ec4\u7ec7ID\u96c6\u5408", required=false) @ApiParam(value="\u7ec4\u7ec7ID\u96c6\u5408", required=false) List<Long> idList) throws ParseException {
        if (numberList.size() > 500 || idList.size() > 500) {
            throw new OpenApiException(String.valueOf((Object)WebApiErrorCode.MAX_COUNTS_EXCEED_500));
        }
        if (numberList.size() == 0 && idList.size() == 0) {
            throw new OpenApiException(String.valueOf((Object)WebApiErrorCode.NUMBER_AND_ID_EMPTY));
        }
        Date date = HRDateTimeUtils.parseDate((String)dateString, (String)"yyyy-MM-dd");
        if (idList.size() == 0) {
            idList = AdminOrgWebApiUtils.getAdminOrgIdByNumber(numberList, date);
        }
        ArrayList<AdminOrgSubResultModel> resultList = new ArrayList<AdminOrgSubResultModel>(idList.size() == 0 ? numberList.size() : idList.size());
        AdminOrgSubResultModel model = new AdminOrgSubResultModel();
        List subOrgList = new ArrayList();
        subOrgList = AdminOrgQueryServiceHelper.batchQueryAllSubOrg(idList, (Date)date);
        HashMap infoMap = new HashMap(20);
        for (int i = 0; i < subOrgList.size(); ++i) {
            infoMap = (HashMap)subOrgList.get(i);
            model = new AdminOrgSubResultModel();
            model.setBoid((Long)infoMap.get("orgId"));
            model.setNumber((String)infoMap.get("orgNumber"));
            model.setName((String)infoMap.get("orgName"));
            model.setParentId((Long)infoMap.get("parentOrgId"));
            model.setEnable((String)infoMap.get("businessStatus"));
            resultList.add(model);
        }
        return CustomApiResult.success(resultList);
    }
}

