/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.customorgteam.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.haos.business.domain.repository.customstruct.CustomOrgTeamRepository;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class CustomOrgTeamConfirmChangeValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        List ids = Arrays.stream(dataEntities).map(extendedDataEntity -> extendedDataEntity.getDataEntity().getLong("id")).collect(Collectors.toList());
        CustomOrgTeamRepository customOrgTeamRepository = CustomOrgTeamRepository.getRepository();
        Map orgTeamMap = customOrgTeamRepository.queryByIds(ids, "bsed");
        Map<Long, List<Long>> childMap = this.queryRelationInfo(dataEntities);
        Arrays.stream(dataEntities).forEach(extendedDataEntity -> {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            long id = dataEntity.getLong("id");
            DynamicObject parent = dataEntity.getDynamicObject("parent");
            long parentId = HRObjectUtils.isEmpty((Object)parent) ? 0L : parent.getLong("id");
            List childOrgTeamIds = (List)childMap.get(id);
            if (childOrgTeamIds.contains(parentId) || parentId == id) {
                this.addErrorMessage((ExtendedDataEntity)extendedDataEntity, ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u80fd\u9009\u62e9\u81ea\u5df1\u53ca\u4e0b\u7ea7\u7ec4\u7ec7\u4f5c\u4e3a\u4e0a\u7ea7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CustomOrgTeamConfirmChangeValidator_0", (String)"hrmp-haos-opplugin", (Object[])new Object[0]));
            }
            DynamicObject orgTeam = (DynamicObject)orgTeamMap.get(id);
            Date oldEffStartDate = orgTeam.getDate("bsed");
            Date newEffStartDate = dataEntity.getDate("bsed");
            if (HRDateTimeUtils.dayBefore((Date)HRDateTimeUtils.truncateDate((Date)newEffStartDate), (Date)oldEffStartDate)) {
                this.addErrorMessage((ExtendedDataEntity)extendedDataEntity, ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u7248\u672c\u751f\u6548\u65e5\u671f\u201c%s\u201d\u3002", (String)"CustomOrgTeamConfirmChangeValidator_1", (String)"hrmp-haos-opplugin", (Object[])new Object[]{HRDateTimeUtils.formatDate((Date)oldEffStartDate)}));
            }
        });
    }

    private Map<Long, List<Long>> queryRelationInfo(ExtendedDataEntity[] dataEntities) {
        ArrayList<Long> ids = new ArrayList<Long>(dataEntities.length * 2);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            ids.add(dynamicObject.getLong("id"));
            ids.add(dynamicObject.getLong("parent.id"));
        }
        Map dys = CustomOrgTeamRepository.getRepository().queryByIds(ids, "structlongnumber,parent");
        if (dys != null && dys.size() > 0) {
            HashMap<Long, List<Long>> childMap = new HashMap<Long, List<Long>>(dataEntities.length * 2);
            for (ExtendedDataEntity dataEntity : dataEntities) {
                DynamicObject dynamicObject = dataEntity.getDataEntity();
                Long id = dynamicObject.getLong("id");
                String longNum = dynamicObject.getString("structlongnumber");
                List childs = dys.values().stream().filter(val -> val.getString("structlongnumber").startsWith(longNum)).map(val -> val.getLong("id")).collect(Collectors.toList());
                childMap.put(id, childs);
            }
            return childMap;
        }
        return Collections.emptyMap();
    }
}

