/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.customorgteam.validator;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.customstruct.CustomOrgTeamEmpRepository;
import kd.hr.haos.business.domain.repository.customstruct.CustomOrgTeamRepository;
import kd.hr.haos.business.domain.repository.customstruct.CustomOrgTeamRoleRepository;
import kd.hr.haos.business.domain.repository.customstruct.CustomOrgTeamStructRepository;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class CustomOrgTeamDisableValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        List orgTeamIds = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity().getLong("id")).collect(Collectors.toList());
        Map enabledChildOrgTeamMap = CustomOrgTeamRepository.getRepository().queryByParentIds(orgTeamIds, null, "name", true);
        CustomOrgTeamRoleRepository customOrgTeamRoleRepository = CustomOrgTeamRoleRepository.getRepository();
        Map orgTeamRoleCountMap = customOrgTeamRoleRepository.countByOrgTeamIds(orgTeamIds);
        CustomOrgTeamEmpRepository customOrgTeamEmpRepository = CustomOrgTeamEmpRepository.getRepository();
        Map orgTeamEmpCountMap = customOrgTeamEmpRepository.countByOrgTeamIds(orgTeamIds);
        HashSet disabledOrgTeamIds = new HashSet(dataEntities.length);
        List<ExtendedDataEntity> collect = Arrays.stream(dataEntities).sorted((o1, o2) -> o2.getDataEntity().getInt("level") - o1.getDataEntity().getInt("level")).collect(Collectors.toList());
        CustomOrgTeamStructRepository customOrgTeamStructRepository = CustomOrgTeamStructRepository.getRepository();
        Set rootOrgTeamIds = customOrgTeamStructRepository.filterRootOrgTeamIds(orgTeamIds);
        collect.forEach(dataEntity -> {
            Integer orgTeamEmpCount;
            Integer orgTeamRoleCount;
            Set existsEnabledChildOrgTeamIds;
            List enabledChildOrgTeams;
            DynamicObject orgTeam = dataEntity.getDataEntity();
            boolean validateResult = true;
            long orgTeamId = orgTeam.getLong("id");
            if (rootOrgTeamIds.contains(orgTeamId)) {
                this.addErrorMessage((ExtendedDataEntity)dataEntity, ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u53ef\u505c\u7528\u3002", (String)"CustomOrgTeamDisableValidator_3", (String)"hrmp-haos-opplugin", (Object[])new Object[0]));
                validateResult = false;
            }
            if (!CollectionUtils.isEmpty((Collection)(enabledChildOrgTeams = (List)enabledChildOrgTeamMap.get(orgTeamId))) && !disabledOrgTeamIds.containsAll(existsEnabledChildOrgTeamIds = enabledChildOrgTeams.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet()))) {
                this.addErrorMessage((ExtendedDataEntity)dataEntity, ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u6709\u5df2\u542f\u7528\u7684\u4e0b\u7ea7\u7ec4\u7ec7\uff0c\u4e0d\u53ef\u505c\u7528\u3002", (String)"CustomOrgTeamDisableValidator_0", (String)"hrmp-haos-opplugin", (Object[])new Object[0]));
                validateResult = false;
            }
            if ((orgTeamRoleCount = (Integer)orgTeamRoleCountMap.get(orgTeamId)) != null && orgTeamRoleCount > 0) {
                this.addErrorMessage((ExtendedDataEntity)dataEntity, ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0b\u6709\u89d2\u8272\uff0c\u8bf7\u5148\u5c06\u89d2\u8272\u79fb\u9664\u3002", (String)"CustomOrgTeamDisableValidator_1", (String)"hrmp-haos-opplugin", (Object[])new Object[0]));
                validateResult = false;
            }
            if ((orgTeamEmpCount = (Integer)orgTeamEmpCountMap.get(orgTeamId)) != null && orgTeamEmpCount > 0) {
                this.addErrorMessage((ExtendedDataEntity)dataEntity, ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0b\u6709\u6210\u5458\uff0c\u8bf7\u5148\u5c06\u6210\u5458\u79fb\u9664\u3002", (String)"CustomOrgTeamDisableValidator_2", (String)"hrmp-haos-opplugin", (Object[])new Object[0]));
                validateResult = false;
            }
            if (validateResult) {
                disabledOrgTeamIds.add(orgTeamId);
            }
        });
    }
}

