/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.customorgteam.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.customstruct.CustomOrgTeamRepository;
import kd.hr.haos.business.domain.repository.customstruct.CustomOrgTeamStructRepository;
import kd.hr.haos.business.domain.repository.customstruct.CustomStructProjectRepository;
import kd.hr.haos.business.domain.repository.customstruct.NumberPrefixRepository;
import kd.hr.haos.common.constants.MultiLangEnum;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class CustomOrgTeamSaveValidator
extends HRDataBaseValidator {
    private static Log LOGGER = LogFactory.getLog(CustomOrgTeamSaveValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        int length = dataEntities.length;
        LOGGER.info("validate start length:{}", (Object)length);
        ArrayList<Long> orgTeamIds = new ArrayList<Long>(length);
        ArrayList<Long> parentIds = new ArrayList<Long>(length);
        ArrayList<Long> structProjectIds = new ArrayList<Long>(length);
        ArrayList<String> names = new ArrayList<String>(length);
        Date earliestEffectDate = null;
        Date latestEffectDate = null;
        for (int i = 0; i < length; ++i) {
            DynamicObject dataEntity = dataEntities[i].getDataEntity();
            orgTeamIds.add(dataEntity.getLong("id"));
            parentIds.add(dataEntity.getLong("parent.id"));
            structProjectIds.add(dataEntity.getLong("structproject.id"));
            names.add(dataEntity.getString("name"));
            Date effectStartDate = dataEntity.getDate("bsed");
            Date effectEndDate = dataEntity.getDate("bsled");
            if (effectEndDate == null) {
                effectEndDate = HisEffDateCommonService.getInstance().getDate2999(null);
            }
            if (i == 0) {
                earliestEffectDate = effectStartDate;
                latestEffectDate = effectEndDate;
                continue;
            }
            if (HRDateTimeUtils.dayBefore((Date)effectStartDate, (Date)earliestEffectDate)) {
                earliestEffectDate = effectStartDate;
            }
            if (!HRDateTimeUtils.dayAfter((Date)effectEndDate, (Date)latestEffectDate)) continue;
            latestEffectDate = effectEndDate;
        }
        CustomOrgTeamStructRepository customOrgTeamStructRepository = CustomOrgTeamStructRepository.getRepository();
        Map parentOrgTeamStructMap = customOrgTeamStructRepository.queryByOrgTeamIds(String.join((CharSequence)",", "orgteam.id", "structproject.id", "enable"), parentIds);
        CustomOrgTeamRepository customOrgTeamRepository = CustomOrgTeamRepository.getRepository();
        Map repeatNameChildOrgTeamMap = customOrgTeamRepository.queryEffectingRepeatNameChildOrgTeams(parentIds, orgTeamIds, names, earliestEffectDate, latestEffectDate);
        Map structProjectMap = CustomStructProjectRepository.getRepository().queryByStructProjectIds(structProjectIds, "otclassify");
        List otClassIds = structProjectMap.values().stream().map(dy -> dy.getLong("otclassify.id")).collect(Collectors.toList());
        Map prefixNumberMap = NumberPrefixRepository.getRepository().getNumberPrefixByIds(otClassIds);
        ArrayList realNumbers = new ArrayList(length);
        HashMap idAndRealNumberMap = new HashMap(length);
        Arrays.stream(dataEntities).forEach(extendedDataEntity -> {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            long structProjectId = dataEntity.getLong("structproject.id");
            DynamicObject structProject = (DynamicObject)structProjectMap.get(structProjectId);
            long otClassifyId = structProject.getLong("otclassify.id");
            String numberPrefix = (String)prefixNumberMap.get(otClassifyId);
            String number = String.join((CharSequence)"_", numberPrefix, dataEntity.getString("number"));
            realNumbers.add(number);
            idAndRealNumberMap.put(dataEntity.getLong("id"), number);
        });
        Set existRepeatNumbers = customOrgTeamRepository.existRepeatNumbers(realNumbers, orgTeamIds);
        Set rootOrgTeamIds = customOrgTeamStructRepository.filterRootOrgTeamIds(orgTeamIds);
        HashSet passOrgTeamIds = new HashSet(length);
        Map<String, List<ExtendedDataEntity>> nameDys = Arrays.stream(dataEntities).collect(Collectors.groupingBy(val -> val.getDataEntity().getString("parent.id") + "_" + val.getDataEntity().getString("name")));
        Arrays.stream(dataEntities).forEach(extendedDataEntity -> {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            Long id = dataEntity.getLong("id");
            String realNumber = (String)idAndRealNumberMap.get(id);
            if (existRepeatNumbers.contains(realNumber)) {
                this.addErrorMessage((ExtendedDataEntity)extendedDataEntity, ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CustomOrgTeamSaveValidator_0", (String)"hrmp-haos-opplugin", (Object[])new Object[0]));
            }
            DynamicObject parent = dataEntity.getDynamicObject("parent");
            Date effStartDate = dataEntity.getDate("bsed");
            if (!HRObjectUtils.isEmpty((Object)parent)) {
                if (rootOrgTeamIds.contains(id)) {
                    this.addErrorMessage((ExtendedDataEntity)extendedDataEntity, ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u53d8\u66f4\u4e0a\u7ea7\u7ec4\u7ec7\u3002", (String)"CustomOrgTeamSaveValidator_3", (String)"hrmp-haos-opplugin", (Object[])new Object[0]));
                } else {
                    List repeatNameChildOrgTeams;
                    String key;
                    List sameNameDys;
                    long parentId = parent.getLong("id");
                    DynamicObject parentOrgTeamStruct = (DynamicObject)parentOrgTeamStructMap.get(parentId);
                    if (!HRObjectUtils.isEmpty((Object)parentOrgTeamStruct)) {
                        long structProjectId;
                        long parentStructProjectId = parentOrgTeamStruct.getLong("structproject.id");
                        if (parentStructProjectId != (structProjectId = dataEntity.getLong("structproject.id"))) {
                            this.addErrorMessage((ExtendedDataEntity)extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u53ef\u586b\u5199\u5f53\u524d\u67b6\u6784\u65b9\u6848\u4e0b\u7684\u7ec4\u7ec7\u4f5c\u4e3a\u4e0a\u7ea7\u7ec4\u7ec7\u3002", (String)"CustomOrgTeamSaveValidator_5", (String)"hrmp-haos-opplugin", (Object[])new Object[0]));
                            return;
                        }
                        String enable = parentOrgTeamStruct.getString("enable");
                        if (!HRStringUtils.equals((String)enable, (String)"1")) {
                            this.addErrorMessage((ExtendedDataEntity)extendedDataEntity, ResManager.loadKDString((String)"\u201c\u4e0a\u7ea7\u7ec4\u7ec7\u201d\u672a\u542f\u7528\u3002", (String)"CustomOrgTeamSaveValidator_6", (String)"hrmp-haos-opplugin", (Object[])new Object[0]));
                            return;
                        }
                    } else if (!passOrgTeamIds.contains(parentId)) {
                        this.addErrorMessage((ExtendedDataEntity)extendedDataEntity, ResManager.loadKDString((String)"\u201c\u4e0a\u7ea7\u7ec4\u7ec7\u201d\u4e0d\u5b58\u5728\u3002", (String)"CustomOrgTeamSaveValidator_7", (String)"hrmp-haos-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    String name = dataEntity.getString("name");
                    if ("ot_his_newsave".equals(this.getOperateKey()) && (sameNameDys = (List)nameDys.get(key = dataEntity.getString("parent.id") + "_" + name)).size() > 1 && sameNameDys.get(0) != extendedDataEntity) {
                        HashSet<String> errorMessages = new HashSet<String>(sameNameDys.size());
                        for (ExtendedDataEntity extendDE : sameNameDys) {
                            if (extendDE == extendedDataEntity) continue;
                            Date childEffStartDate = extendDE.getDataEntity().getDate("bsed");
                            Date childEffEndDate = HRDateTimeUtils.getSysMaxDate();
                            errorMessages.add(String.format(ResManager.loadKDString((String)"\u201c%1$s-%2$s\u201d\u671f\u95f4\uff0c\u201c%3$s\u201d\u4e0b\u5df2\u5b58\u5728%4$s\u540d\u79f0\u4e3a\u201c%5$s\u201d\u7684\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CustomOrgTeamSaveValidator_1", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), HRDateTimeUtils.formatDate((Date)childEffStartDate), HRDateTimeUtils.formatDate((Date)childEffEndDate), parent.getString("name"), MultiLangEnum.CHINES_SIMP.getName(), dataEntity.getString("name")));
                        }
                        errorMessages.forEach(message -> this.addErrorMessage((ExtendedDataEntity)extendedDataEntity, (String)message));
                    }
                    if (!CollectionUtils.isEmpty((Collection)(repeatNameChildOrgTeams = (List)repeatNameChildOrgTeamMap.get(parentId)))) {
                        HashSet<String> errorMessages = new HashSet<String>(repeatNameChildOrgTeams.size());
                        for (DynamicObject repeatNameChildOrgTeam : repeatNameChildOrgTeams) {
                            Date childEffStartDate = repeatNameChildOrgTeam.getDate("bsed");
                            Date childEffEndDate = repeatNameChildOrgTeam.getDate("bsled");
                            String childOrgTeamName = repeatNameChildOrgTeam.getString("name");
                            if (!HRStringUtils.equals((String)name, (String)childOrgTeamName) || HRDateTimeUtils.dayAfter((Date)effStartDate, (Date)childEffEndDate)) continue;
                            errorMessages.add(String.format(ResManager.loadKDString((String)"\u201c%1$s-%2$s\u201d\u671f\u95f4\uff0c\u201c%3$s\u201d\u4e0b\u5df2\u5b58\u5728%4$s\u540d\u79f0\u4e3a\u201c%5$s\u201d\u7684\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CustomOrgTeamSaveValidator_1", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), HRDateTimeUtils.formatDate((Date)childEffStartDate), HRDateTimeUtils.formatDate((Date)childEffEndDate), parent.getString("name"), MultiLangEnum.CHINES_SIMP.getName(), dataEntity.getString("name")));
                        }
                        errorMessages.forEach(message -> this.addErrorMessage((ExtendedDataEntity)extendedDataEntity, (String)message));
                    }
                }
            } else if (!rootOrgTeamIds.contains(id)) {
                String importType = this.getOption().getVariableValue("importtype", "");
                if (HRStringUtils.equals((String)importType, (String)"new")) {
                    this.addErrorMessage((ExtendedDataEntity)extendedDataEntity, ResManager.loadKDString((String)"\u201c\u4e0a\u7ea7\u7ec4\u7ec7\u201d\u672a\u5728\u7cfb\u7edf\u4e2d\u5339\u914d\u5230\u3002", (String)"CustomOrgTeamSaveValidator_8", (String)"hrmp-haos-opplugin", (Object[])new Object[0]));
                } else {
                    this.addErrorMessage((ExtendedDataEntity)extendedDataEntity, ResManager.loadKDString((String)"\u201c\u4e0a\u7ea7\u7ec4\u7ec7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CustomOrgTeamSaveValidator_2", (String)"hrmp-haos-opplugin", (Object[])new Object[0]));
                }
            }
            if (HRDateTimeUtils.dayAfter((Date)effStartDate, (Date)new Date())) {
                this.addErrorMessage((ExtendedDataEntity)extendedDataEntity, ResManager.loadKDString((String)"\u751f\u6548\u65f6\u95f4\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u65f6\u95f4\u3002", (String)"CustomOrgTeamSaveValidator_4", (String)"hrmp-haos-opplugin", (Object[])new Object[0]));
            }
            if (!this.getFalseDataEntities().contains(extendedDataEntity)) {
                passOrgTeamIds.add(id);
            }
        });
        LOGGER.info("validate end length:{}", (Object)length);
    }
}

