/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.customrole;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.domain.repository.CommonRepository;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.haos.business.domain.repository.custroleemp.CustRoleEmpRepository;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class AddHasRoleValid
extends HRDataBaseValidator {
    private static final String selProp = "number, name, orgteam.id";

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (Objects.isNull(dataEntities) || dataEntities.length == 0) {
            return;
        }
        List targetDys = CustRoleEmpRepository.getInstance().getCustRoleTargetData((DynamicObject[])Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).toArray(DynamicObject[]::new));
        HashSet<String> nums = new HashSet<String>(dataEntities.length);
        HashSet<Long> orgTeamIds = new HashSet<Long>(dataEntities.length);
        for (DynamicObject dy2 : targetDys) {
            nums.add(dy2.getString("number"));
            orgTeamIds.add(dy2.getLong("orgteam"));
        }
        QFilter orgTeamFilter = new QFilter("orgteam", "in", orgTeamIds);
        QFilter numFilter = new QFilter("number", "in", nums);
        DynamicObject[] orgs = CommonRepository.queryDynamicObjects((String)"haos_cusadminorgteam", (String)"enable", (QFilter[])new QFilter[]{new QFilter("id", "in", orgTeamIds).and(QFilterHelper.createValidHisCurrentDataFilter())});
        Map<Long, String> orgStatusMap = null;
        if (orgs != null) {
            orgStatusMap = Stream.of(orgs).collect(Collectors.toMap(val -> val.getLong("id"), val -> val.getString("enable")));
        }
        DynamicObject[] numOrgteamDys = CommonRepository.queryDynamicObjects((String)"haos_customorole", (String)selProp, (QFilter[])new QFilter[]{numFilter.and(orgTeamFilter).and(QFilterHelper.createValidHisCurrentDataFilter())});
        Map<String, DynamicObject> numDyMap = Arrays.stream(numOrgteamDys).collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy, (oldval, newVal) -> newVal));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String errorMsg;
            DynamicObject dy3 = dataEntity.getDataEntity();
            String number = dy3.getString("number");
            if (numDyMap.get(number) != null) {
                errorMsg = ResManager.loadKDString((String)"\u5b58\u5728\u7f16\u7801\u3001\u7ec4\u7ec7\u76f8\u540c\u7684\u6570\u636e\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"AddHasRoleValid_0", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, errorMsg);
            }
            if (orgStatusMap == null || "1".equals(orgStatusMap.get(dy3.getLong("orgteam")))) continue;
            errorMsg = ResManager.loadKDString((String)"\u7981\u7528\u7ec4\u7ec7\u4e0d\u80fd\u6dfb\u52a0\u65b0\u89d2\u8272\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"AddHasRoleValid_2", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, errorMsg);
        }
    }
}

