/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.customrole;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.haos.business.domain.repository.custroleemp.CustRoleEmpRepository;
import kd.hr.haos.opplugin.web.customrole.CustomRoleValid;
import kd.hr.haos.opplugin.web.customrole.CustomSaveOp;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamListBo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisOperateType;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;

public class CustomEditOp
extends HRDataBaseOp {
    private static final Log LOGGER = LogFactory.getLog(CustomSaveOp.class);
    private static final HRBaseServiceHelper CUSTOMOROLE_HELPER = new HRBaseServiceHelper("haos_customorole");
    private static final HRBaseServiceHelper CUSEMPPOSORGREL_HELPER = new HRBaseServiceHelper("haos_cusempposorgrel");

    public void onAddValidators(AddValidatorsEventArgs evt) {
        evt.addValidator((AbstractValidator)new CustomRoleValid());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        ArrayList<HisVersionParamBo> hisVersionParamListBo = new ArrayList<HisVersionParamBo>();
        ArrayList<DynamicObject> reloHisDys = new ArrayList<DynamicObject>(dataEntities.length);
        HashMap<Long, Long> roleOrgRelateMap = new HashMap<Long, Long>(dataEntities.length);
        List roleIds = Arrays.stream(dataEntities).map(val -> val.getLong("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", roleIds).and(QFilterHelper.createValidHisCurrentDataFilter());
        DynamicObject[] roleDysDB = CUSTOMOROLE_HELPER.query("orgteam", new QFilter[]{qFilter});
        if (roleDysDB != null) {
            for (DynamicObject role : roleDysDB) {
                roleOrgRelateMap.put(role.getLong("id"), role.getLong("orgteam.id"));
            }
        }
        for (DynamicObject dynamicObject : dataEntities) {
            DynamicObject newDy = CUSTOMOROLE_HELPER.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)newDy);
            newDy.set("bsed", (Object)new Date());
            reloHisDys.add(newDy);
            Long oldOrgTeamId = (Long)roleOrgRelateMap.get(dynamicObject.getLong("id"));
            if (oldOrgTeamId == null || oldOrgTeamId.longValue() == dynamicObject.getLong("orgteam.id")) continue;
            Date now = new Date();
            QFilter personQfilter = new QFilter("customorole", "=", (Object)dynamicObject.getLong("id")).and("startdate", "<=", (Object)now).and("sysenddate", ">=", (Object)now).and(QFilterHelper.createValidHisCurrentDataFilter());
            DynamicObject[] cusempposorgrelDys = CUSEMPPOSORGREL_HELPER.loadDynamicObjectArray(new QFilter[]{personQfilter});
            if (cusempposorgrelDys == null || cusempposorgrelDys.length <= 0) continue;
            ArrayList<DynamicObject> empposorgrelHisDys = new ArrayList<DynamicObject>(cusempposorgrelDys.length);
            for (DynamicObject empposorgrelDy : cusempposorgrelDys) {
                DynamicObject newEempposorgrel = CUSEMPPOSORGREL_HELPER.generateEmptyDynamicObject();
                HashSet<String> ignoreKeys = new HashSet<String>(4);
                ignoreKeys.add("id");
                ignoreKeys.add("boid");
                ignoreKeys.add("iscurrentversion");
                HRDynamicObjectUtils.copy((DynamicObject)empposorgrelDy, (DynamicObject)newEempposorgrel, ignoreKeys);
                newEempposorgrel.set("bsed", (Object)new Date());
                newEempposorgrel.set("orgteam_id", (Object)dynamicObject.getLong("orgteam.id"));
                empposorgrelHisDys.add(newEempposorgrel);
            }
            CustRoleEmpRepository.getInstance().discardBoData(cusempposorgrelDys, "haos_cusempposorgrel");
            HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
            hisVersionParamBo.setOperateType(EnumHisOperateType.SAVE_VERSION.getType());
            hisVersionParamBo.setEntityNumber("haos_cusempposorgrel");
            hisVersionParamBo.setAtomicTrans(true);
            hisVersionParamBo.setHisDyns(empposorgrelHisDys.toArray(new DynamicObject[0]));
            hisVersionParamListBo.add(hisVersionParamBo);
        }
        HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
        hisVersionParamBo.setOperateType(EnumHisOperateType.SAVE_VERSION.getType());
        hisVersionParamBo.setEntityNumber("haos_customorole");
        hisVersionParamBo.setAtomicTrans(true);
        hisVersionParamBo.setHisDyns(reloHisDys.toArray(new DynamicObject[0]));
        hisVersionParamListBo.add(hisVersionParamBo);
        HisVersionParamListBo listBo = new HisVersionParamListBo();
        listBo.setListHisVersionParamBo(hisVersionParamListBo);
        HisModelController.getInstance().batchHisVersionChange(listBo);
    }
}

