/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.customrole;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.haos.business.domain.repository.CommonRepository;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class CustomRoleValid
extends HRDataBaseValidator {
    public void validate() {
        String operateKey;
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (Objects.isNull(dataEntities) || dataEntities.length == 0) {
            return;
        }
        switch (operateKey = this.getOperateKey()) {
            case "save": {
                this.checkDataStatus(dataEntities);
                Map variables = this.getOption().getVariables();
                if (variables == null || "new".equals(variables.get("importtype")) || PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"homs", (String)this.getEntityKey(), (String)"47156aff000000ac")) break;
                String message = ResManager.loadKDString((String)"\u65e0\u65b0\u589e\u201c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CustomRoleNameValid_7", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    this.addFatalErrorMessage(dataEntity, message);
                }
                break;
            }
            case "tblremove": {
                HashSet<Long> custRoleIds = new HashSet<Long>(dataEntities.length);
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject dy2 = dataEntity.getDataEntity();
                    Long id = dy2.getLong("id");
                    custRoleIds.add(id);
                }
                QFilter filter = new QFilter("customorole", "in", custRoleIds);
                filter.and(QFilterHelper.createValidHisCurrentDataFilter());
                DynamicObject[] custRoleRels = CommonRepository.queryDynamicObjects((String)"haos_cusempposorgrel", (String)"customorole.id", (QFilter[])new QFilter[]{filter});
                Map<Long, DynamicObject> roleIdCusRoleMap = Arrays.stream(custRoleRels).collect(Collectors.toMap(dy -> dy.getLong("customorole.id"), dy -> dy, (oldValue, newValue) -> newValue));
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject dy3 = dataEntity.getDataEntity();
                    Long id = dy3.getLong("id");
                    if (roleIdCusRoleMap.get(id) == null) continue;
                    String orgName = dy3.getString("orgteam.name");
                    String roleName = dy3.getString("name");
                    String errorMsg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e0b\u8fd8\u6709\u4efb\u804c\u4eba\u5458\uff0c\u8bf7\u5148\u79fb\u9664\u89d2\u8272\u4e0b\u7684\u4eba\u5458\u3002", (String)"CustomRoleNameValid_1", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), orgName + "-" + roleName);
                    this.addErrorMessage(dataEntity, errorMsg);
                }
                break;
            }
        }
    }

    private void checkDataStatus(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String errorMsg;
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            DynamicObject orgDy = dynamicObject.getDynamicObject("orgteam");
            if (orgDy == null) {
                errorMsg = ResManager.loadKDString((String)"\u5fc5\u987b\u586b\u5199\u201c\u6240\u5c5e\u7ec4\u7ec7\u201d\u3002", (String)"CustomRoleValid_0", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, errorMsg);
                continue;
            }
            if ("1".equals(orgDy.getString("enable"))) continue;
            errorMsg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7ec4\u7ec7\u5df2\u7ecf\u505c\u7528\u3002", (String)"CustomRoleValid_1", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), orgDy.getString("name"));
            this.addErrorMessage(dataEntity, errorMsg);
        }
    }
}

