/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.customrole;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.haos.opplugin.web.customrole.CustomRoleValid;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisOperateType;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;

public class CustomSaveOp
extends HRDataBaseOp {
    private static Log LOGGER = LogFactory.getLog(CustomSaveOp.class);
    private static final HRBaseServiceHelper ADDHASROLE_HELPER = new HRBaseServiceHelper("haos_addhasrole");

    public void onAddValidators(AddValidatorsEventArgs evt) {
        evt.addValidator((AbstractValidator)new CustomRoleValid());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        for (DynamicObject dy : dataEntities) {
            if (dy.get("index") != null && dy.getInt("index") != 0) continue;
            dy.set("index", (Object)1);
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        DynamicObject[] dys = args.getDataEntities();
        if (dys == null || dys.length == 0) {
            LOGGER.warn("beforeExecuteOperationTransaction dys is empty");
            return;
        }
        ArrayList<DynamicObject> hisDys = new ArrayList<DynamicObject>(dys.length);
        List numbers = Arrays.stream(dys).map(val -> val.getString("number")).collect(Collectors.toList());
        long teamTypeId = dys[0].getLong("orgteam.teamtype.id");
        QFilter qFilter = QFilterHelper.createValidHisCurrentDataFilter().and("structtype.id", "=", (Object)teamTypeId).and("number", "in", numbers);
        HashMap<String, Long> relateMap = new HashMap<String, Long>(dys.length);
        DynamicObject[] dysDb = ADDHASROLE_HELPER.query("number", new QFilter[]{qFilter});
        if (dysDb != null && dysDb.length > 0) {
            for (DynamicObject dy : dysDb) {
                relateMap.put(dy.getString("number"), dy.getLong("id"));
            }
        }
        for (DynamicObject dynamicObject : dys) {
            if (relateMap.containsKey(dynamicObject.getString("number"))) continue;
            DynamicObject newDy = ADDHASROLE_HELPER.generateEmptyDynamicObject();
            HashSet<String> ignoreKeys = new HashSet<String>();
            ignoreKeys.add("id");
            ignoreKeys.add("boid");
            ignoreKeys.add("iscurrentversion");
            HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)newDy, ignoreKeys);
            newDy.set("structtype_id", (Object)teamTypeId);
            newDy.set("bsed", (Object)new Date());
            hisDys.add(newDy);
        }
        if (hisDys.size() > 0) {
            DynamicObject[] dyArray = hisDys.toArray(new DynamicObject[0]);
            HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
            hisVersionParamBo.setOperateType(EnumHisOperateType.SAVE_VERSION.getType());
            hisVersionParamBo.setEntityNumber("haos_addhasrole");
            hisVersionParamBo.setAtomicTrans(true);
            hisVersionParamBo.setHisDyns(dyArray);
            HisModelController.getInstance().hisVersionChange(hisVersionParamBo);
            for (DynamicObject dy : hisDys) {
                relateMap.put(dy.getString("number"), dy.getLong("id"));
            }
        }
        for (DynamicObject dynamicObject : dys) {
            dynamicObject.set("sourcetpl", relateMap.get(dynamicObject.getString("number")));
        }
    }
}

