/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.custroleemp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.CommonRepository;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.haos.business.domain.repository.custroleemp.CustRoleEmpRepository;
import kd.hr.haos.opplugin.web.customrole.CustomSaveOp;
import kd.hr.haos.opplugin.web.custroleemp.CustRoleEmpPermValid;
import kd.hr.haos.opplugin.web.custroleemp.CustRoleEmpRelValid;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;

public class CustRoleEmpEditOp
extends HRDataBaseOp {
    private static Log LOGGER = LogFactory.getLog(CustomSaveOp.class);

    public void onAddValidators(AddValidatorsEventArgs evt) {
        evt.addValidator((AbstractValidator)new CustRoleEmpRelValid());
        evt.addValidator((AbstractValidator)new CustRoleEmpPermValid());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] orgTeams;
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        HashSet<Long> employIds = new HashSet<Long>(dataEntities.length);
        HashSet<Long> outPerIds = new HashSet<Long>(dataEntities.length);
        ArrayList<DynamicObject> hisNeedEditDys = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> hisNeedDiscardDys = new ArrayList<DynamicObject>();
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_cusempposorgrel");
        long orgTeamId = 0L;
        for (DynamicObject dy : dataEntities) {
            DynamicObjectCollection collection;
            if (Boolean.TRUE.equals(dy.getBoolean("datasource"))) {
                employIds.add(dy.getLong("depemp.employee.id"));
            } else {
                outPerIds.add(dy.getLong("outperson.id"));
            }
            if (orgTeamId != 0L || CollectionUtils.isEmpty((Collection)(collection = dy.getDynamicObjectCollection("entryentity"))) || ((DynamicObject)collection.get(0)).getLong("enorgteam.id") == 0L) continue;
            orgTeamId = ((DynamicObject)collection.get(0)).getLong("enorgteam.id");
        }
        QFilter empFilter = new QFilter("depemp.employee.id", "in", employIds).and(QFilterHelper.createValidHisCurrentDataFilter());
        QFilter outPerFilter = new QFilter("outperson.id", "in", outPerIds).and(QFilterHelper.createValidHisCurrentDataFilter());
        if (orgTeamId != 0L && (orgTeams = CommonRepository.queryDynamicObjects((String)"haos_customotstruct", (String)"structproject.id", (QFilter[])new QFilter[]{new QFilter("orgteam", "=", (Object)orgTeamId).and(QFilterHelper.createValidHisCurrentDataFilter())})) != null && orgTeams.length > 0) {
            QFilter structProjectF = CustRoleEmpRepository.getInstance().getFilterByStructProject(Long.valueOf(orgTeams[0].getLong("structproject.id")), "orgteam.id");
            empFilter.and(structProjectF);
            outPerFilter.and(structProjectF);
        }
        DynamicObject[] empDys = CommonRepository.queryDynamicObjects((String)"haos_cusempposorgrel", (String)"", (String)"index", (QFilter[])new QFilter[]{empFilter});
        DynamicObject[] outPerDys = CommonRepository.queryDynamicObjects((String)"haos_cusempposorgrel", (String)"", (String)"index", (QFilter[])new QFilter[]{outPerFilter});
        if (empDys != null && empDys.length > 0) {
            this.buildHisData(dataEntities, hisNeedEditDys, hisNeedDiscardDys, helper, empDys, "depemp.employee.id");
        }
        if (outPerDys != null && outPerDys.length > 0) {
            this.buildHisData(dataEntities, hisNeedEditDys, hisNeedDiscardDys, helper, outPerDys, "outperson.id");
        }
        if (!CollectionUtils.isEmpty(hisNeedDiscardDys)) {
            CustRoleEmpRepository.getInstance().discardBoData(hisNeedDiscardDys.toArray(new DynamicObject[0]), "haos_cusempposorgrel");
        }
        if (!CollectionUtils.isEmpty(hisNeedEditDys)) {
            CustRoleEmpRepository.getInstance().saveOrEditHisData(hisNeedEditDys.toArray(new DynamicObject[0]), "haos_cusempposorgrel");
        }
        if (!dataEntities[0].getBoolean("datasource")) {
            QFilter filter = new QFilter("id", "in", outPerIds);
            DynamicObject outNewPer = CommonRepository.queryDynamicObject((String)"haos_outperson", (String)"", (QFilter[])new QFilter[]{filter});
            outNewPer.set("number", dataEntities[0].get("outpernumber"));
            outNewPer.set("name", dataEntities[0].get("name"));
            outNewPer.set("gender", dataEntities[0].get("gender"));
            outNewPer.set("phone", dataEntities[0].get("phone"));
            outNewPer.set("description", dataEntities[0].get("perdesc"));
            CommonRepository.saveDynamicObject((String)"haos_outperson", (DynamicObject)outNewPer);
        }
    }

    private void buildHisData(DynamicObject[] dataEntities, List<DynamicObject> hisNeedEditDys, List<DynamicObject> hisNeedDiscardDys, HRBaseServiceHelper helper, DynamicObject[] empDys, String key) {
        Map<Long, List<DynamicObject>> empIdAndEmpDy = Arrays.stream(empDys).collect(Collectors.groupingBy(emp -> emp.getLong(key)));
        for (DynamicObject dy : dataEntities) {
            int i;
            DynamicObjectCollection collection;
            Long empId = dy.getLong(key);
            if (empIdAndEmpDy.get(empId) == null || CollectionUtils.isEmpty((Collection)(collection = dy.getDynamicObjectCollection("entryentity")))) continue;
            List<DynamicObject> empList = empIdAndEmpDy.get(empId);
            int collSize = collection.size();
            int empSize = empList.size();
            if (empSize > collSize) {
                for (i = 0; i < collSize; ++i) {
                    this.editHisData(hisNeedEditDys, helper, collection, empList, i, dy);
                }
                for (i = collSize; i < empSize; ++i) {
                    DynamicObject empTmpDy = empList.get(i);
                    hisNeedDiscardDys.add(empTmpDy);
                }
                continue;
            }
            if (empSize == collSize) {
                for (i = 0; i < collSize; ++i) {
                    this.editHisData(hisNeedEditDys, helper, collection, empList, i, dy);
                }
                continue;
            }
            if (empSize >= collSize) continue;
            for (i = 0; i < empSize; ++i) {
                this.editHisData(hisNeedEditDys, helper, collection, empList, i, dy);
            }
            for (i = empSize; i < collSize; ++i) {
                DynamicObject newDy = helper.generateEmptyDynamicObject();
                CustRoleEmpRepository.getInstance().setCustRelDy(dy, newDy);
                DynamicObject collDy = (DynamicObject)collection.get(i);
                newDy = CustRoleEmpRepository.getInstance().setCollDy(newDy, collDy);
                hisNeedEditDys.add(newDy);
            }
        }
    }

    private void editHisData(List<DynamicObject> hisNeedEditDys, HRBaseServiceHelper helper, DynamicObjectCollection collection, List<DynamicObject> empList, int i, DynamicObject sourceDy) {
        DynamicObject empTmpDy = empList.get(i);
        DynamicObject collDy = (DynamicObject)collection.get(i);
        DynamicObject newDy = helper.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)empTmpDy, (DynamicObject)newDy);
        newDy = CustRoleEmpRepository.getInstance().setCustRelDyName(sourceDy, newDy);
        newDy = CustRoleEmpRepository.getInstance().setCollDy(newDy, collDy);
        hisNeedEditDys.add(newDy);
    }
}

