/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.otherframework;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.InitOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.structproject.StructProjectRepository;
import kd.hr.haos.business.service.otherstruct.OtherStructService;
import kd.hr.haos.business.service.otherstruct.model.OtherStructEntity;
import kd.hr.haos.business.service.otherstruct.model.OtherStructVO;
import kd.hr.haos.opplugin.web.validate.OtherStructValidator;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;

public class OtherStructSaveOp
extends HRDataBaseOp {
    private List<OtherStructVO> list;
    private Long newRootOrgId;
    protected OtherStructService otherStructService;

    public void initialize(InitOperationArgs e) {
        super.initialize(e);
        this.buildData();
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new OtherStructValidator(this.list));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs event) {
        DynamicObject[] dataEntities = event.getDataEntities();
        DynamicObject dataEntity = dataEntities[0];
        OtherStructEntity otherStructEntity = this.buildEntity(dataEntity);
        boolean enableChangedFlag = this.setDefaultValue(otherStructEntity);
        this.otherStructService = new OtherStructService(otherStructEntity);
        this.otherStructService.saveOtherStruct();
        DynamicObject[] structProjectDys = StructProjectRepository.getInstance().loadByIds(Collections.singleton(otherStructEntity.getStructProjectId()));
        if (structProjectDys.length != 1) {
            return;
        }
        DynamicObject structProjectDy = structProjectDys[0];
        if (this.newRootOrgId != null) {
            structProjectDy.set("rootorg", (Object)this.newRootOrgId);
        }
        if (enableChangedFlag) {
            structProjectDy.set("enable", (Object)otherStructEntity.getEnable());
        }
        StructProjectRepository.getInstance().saveOne(structProjectDy);
        this.updateRootOrgEnable(otherStructEntity);
    }

    protected void updateRootOrgEnable(OtherStructEntity otherStructEntity) {
    }

    protected boolean setDefaultValue(OtherStructEntity otherStructEntity) {
        if (!"10".equals(otherStructEntity.getEnable())) {
            otherStructEntity.setEnable("1");
        }
        return false;
    }

    private OtherStructEntity buildEntity(DynamicObject dataEntity) {
        OtherStructEntity otherStructEntity = new OtherStructEntity(this.list);
        DynamicObject structProjectDy = dataEntity.getDynamicObject("structproject");
        otherStructEntity.setStructProjectId(Long.valueOf(structProjectDy.getLong("id")));
        otherStructEntity.setEnable(structProjectDy.getString("enable"));
        otherStructEntity.setEffectDate(dataEntity.getDate("bsed"));
        otherStructEntity.setIncludeVirtual(structProjectDy.getBoolean("isincludevirtualorg"));
        if ("10".equals(otherStructEntity.getEnable())) {
            OtherStructVO rootVO = this.list.stream().filter(vo -> vo.getParentId() == null).findFirst().orElse(null);
            if (rootVO == null) {
                return otherStructEntity;
            }
            Long rootOrg = structProjectDy.getLong("rootorg.id");
            if (rootVO.getOrgId().equals(rootOrg)) {
                otherStructEntity.setRootOrgId(rootOrg);
                this.list.remove(rootVO);
            } else {
                this.newRootOrgId = rootVO.getOrgId();
            }
        } else {
            otherStructEntity.setDeleteFlag(Boolean.FALSE);
        }
        otherStructEntity.setDyList(this.buildVirtualList(dataEntity));
        return otherStructEntity;
    }

    private List<DynamicObject> buildVirtualList(DynamicObject dataEntity) {
        DynamicObjectCollection col = dataEntity.getDynamicObjectCollection("entryentity");
        if (!CollectionUtils.isEmpty((Collection)col)) {
            MainEntityType dynamicObjectType = EntityMetadataCache.getDataEntityType((String)"haos_virtualorg");
            DynamicObjectType bosOrgType = EntityMetadataCache.getSubDataEntityType((String)"bos_org", Collections.singletonList("id"));
            return col.stream().map(arg_0 -> OtherStructSaveOp.lambda$buildVirtualList$1((DynamicObjectType)dynamicObjectType, bosOrgType, arg_0)).collect(Collectors.toList());
        }
        return null;
    }

    private void buildData() {
        String listStr = this.operateOption.getVariableValue("other_struct_op_params");
        this.list = SerializationUtils.fromJsonStringToList((String)listStr, OtherStructVO.class);
    }

    private static /* synthetic */ DynamicObject lambda$buildVirtualList$1(DynamicObjectType dynamicObjectType, DynamicObjectType bosOrgType, DynamicObject dy) {
        DynamicObject orgDy = new DynamicObject(dynamicObjectType);
        orgDy.set("orgid", dy.get("orgid"));
        orgDy.set("number", dy.get("number"));
        orgDy.set("name", dy.get("name"));
        orgDy.set("description", dy.get("description"));
        DynamicObject bosOrgDy = new DynamicObject(bosOrgType);
        bosOrgDy.set("id", (Object)dy.getLong("org"));
        orgDy.set("org", (Object)bosOrgDy);
        return orgDy;
    }
}

