/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.otherframework;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.application.impl.structproject.StructProjectApplicationImpl;
import kd.hr.haos.business.application.structproject.IStructProjectApplication;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;

public class StructProjectDeleteOP
extends HRDataBaseOp {
    private IStructProjectApplication structProjectApplication = new StructProjectApplicationImpl();
    private static final String HRMP_HAOS_OPPLUGIN = "hrmp-haos-opplugin";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("enable");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs event) {
        DynamicObject[] dataEntities = event.getDataEntities();
        ArrayList needToDeleteData = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList disableData = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList enableData = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject dataEntity : dataEntities) {
            if ("10".equals(dataEntity.getString("enable"))) {
                needToDeleteData.add(dataEntity);
                continue;
            }
            if ("1".equals(dataEntity.getString("enable"))) {
                enableData.add(dataEntity);
                continue;
            }
            disableData.add(dataEntity);
        }
        DynamicObject[] dyToDel = needToDeleteData.toArray(new DynamicObject[0]);
        this.structProjectApplication.doWithDelete(dyToDel);
        this.assembleDisplayResult(dataEntities, needToDeleteData, enableData, disableData);
    }

    private void assembleDisplayResult(DynamicObject[] dataEntities, List<DynamicObject> needToDeleteData, List<DynamicObject> enableData, List<DynamicObject> disableData) {
        if (!CollectionUtils.isEmpty(enableData) || !CollectionUtils.isEmpty(disableData)) {
            String title = String.format(ResManager.loadKDString((String)"\u5355\u636e\u603b\u6761\u6570\uff1a%1$s\uff0c\u5220\u9664\u6210\u529f\u6761\u6570\uff1a%2$s\uff0c\u5220\u9664\u5931\u8d25\u603b\u6761\u6570\uff1a%3$s\u3002", (String)"StructProjectValidator_4", (String)HRMP_HAOS_OPPLUGIN, (Object[])new Object[0]), dataEntities.length, needToDeleteData.size(), enableData.size() + disableData.size());
            String enableNumbers = enableData.stream().map(dyn -> dyn.getString("number")).collect(Collectors.joining(","));
            String disableNumbers = disableData.stream().map(dyn -> dyn.getString("number")).collect(Collectors.joining(","));
            String enableMessage = String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u5df2\u88ab\u542f\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"StructProjectValidator_2", (String)HRMP_HAOS_OPPLUGIN, (Object[])new Object[0]), enableNumbers);
            String disableMessage = String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u5df2\u88ab\u7981\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"StructProjectValidator_3", (String)HRMP_HAOS_OPPLUGIN, (Object[])new Object[0]), disableNumbers);
            String message = "";
            message = CollectionUtils.isEmpty(enableData) ? disableMessage : (CollectionUtils.isEmpty(disableData) ? enableMessage : disableMessage + "\n" + enableMessage + "\n");
            this.getOption().setVariableValue("message", message);
            this.getOption().setVariableValue("title", title);
            this.getOption().setVariableValue("showConfirm", String.valueOf(needToDeleteData.size() == 0 && enableData.size() + disableData.size() == 1));
        }
    }
}

