/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.otherframework;

import java.util.Collections;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.ORM;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.service.adminorg.AdminOrgHisServiceHelper;
import kd.hr.haos.business.util.HAOSDynamicObjectUtil;
import kd.hr.haos.common.util.OrgDateTimeUtil;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;

public class VirtualOrgSaveOp
extends HRDataBaseOp {
    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs event) {
        DynamicObject dataEntity = event.getDataEntities()[0];
        long orgId = dataEntity.getLong("orgid");
        if (orgId == 0L) {
            orgId = ORM.create().genLongId("haos_adminorgdetail");
            dataEntity.set("orgid", (Object)orgId);
            DynamicObject orgDy = AdOrgRepository.getInstance().genEmptyDy();
            HRDynamicObjectUtils.copy((DynamicObject)dataEntity, (DynamicObject)orgDy);
            orgDy.set("id", (Object)orgId);
            orgDy.set("parentorg", null);
            orgDy.set("boid", (Object)orgId);
            orgDy.set("structnumber", (Object)ORM.create().genStringId("haos_adminorgdetail"));
            orgDy.set("datastatus", (Object)EnumHisDataVersionStatus.TEMP.getStatus());
            HAOSDynamicObjectUtil.setInitFields((DynamicObject)orgDy);
            orgDy.set("iscurrentversion", (Object)Boolean.TRUE);
            orgDy.set("status", (Object)"C");
            orgDy.set("bsed", (Object)HRDateTimeUtils.getNowDate());
            orgDy.set("bsled", (Object)OrgDateTimeUtil.BSLED);
            orgDy.set("enable", (Object)"1");
            orgDy.set("isvirtualorg", (Object)Boolean.TRUE);
            this.saveTemporary(new DynamicObject[]{orgDy});
        } else if (HRStringUtils.equals((String)dataEntity.getDynamicObject("adminorg").getString("datastatus"), (String)EnumHisDataVersionStatus.TEMP.getStatus())) {
            DynamicObject[] orgDys = AdOrgRepository.getInstance().loadByIds(Collections.singletonList(orgId));
            if (orgDys.length == 0) {
                return;
            }
            HRDynamicObjectUtils.copy((DynamicObject)dataEntity, (DynamicObject)orgDys[0]);
            this.saveTemporary(orgDys);
        }
    }

    private void saveTemporary(DynamicObject[] orgDys) {
        HisVersionParamBo hisVersionParamBo = AdminOrgHisServiceHelper.getHisVersionParam((DynamicObject[])orgDys, (String)"haos_adminorgdetail", (boolean)false);
        hisVersionParamBo.setOperateType("SAVE_VERSION");
        hisVersionParamBo.setNeedProcessAttachment(false);
        hisVersionParamBo.setEffImmediately(false);
        HisModelController.getInstance().hisVersionChange(hisVersionParamBo);
    }
}

