/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.projectgroup;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.prjorg.PRJOrgRepository;
import kd.hr.haos.business.domain.service.impl.teamcoop.TeamCoopRelServiceImpl;
import kd.hr.haos.business.service.adminorg.bean.TeamCoopRelBO;
import kd.hr.haos.business.service.projectgroup.service.IProjectInfoService;
import kd.hr.haos.business.service.projectgroup.service.LocaleStringComparator;
import kd.hr.haos.business.service.projectgroup.service.ProTeamMsgService;
import kd.hr.haos.business.service.projectgroup.service.ProjChangeEventService;
import kd.hr.haos.business.service.projectgroup.service.ProjStrategyService;
import kd.hr.haos.business.service.projectgroup.service.ProjectGroupBaseService;
import kd.hr.haos.business.service.projectgroup.service.ProjectInfoService;
import kd.hr.haos.business.util.LogUtil;
import kd.hr.haos.business.util.OpConfirmHelper;
import kd.hr.haos.business.util.TimeLogger;
import kd.hr.haos.common.constants.projectgroup.ProjectGroupMDConstants;
import kd.hr.haos.common.model.prj.OpParam;
import kd.hr.haos.opplugin.web.projectgroup.validate.ProjectGroupSaveValidator;
import kd.hr.hbp.business.domain.model.newhismodel.BatchVersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRCoreBaseBillOp;

public class ProjectGroupChangeOp
extends HRCoreBaseBillOp
implements ProjectGroupMDConstants {
    private static final Log LOGGER = LogFactory.getLog(ProjectGroupChangeOp.class);
    private long eventId;
    private boolean showConfirm = false;
    List<Map<String, Object>> list;
    private IProjectInfoService projectInfoService = new ProjectInfoService();
    private HisResponse<BatchVersionChangeRespData> hisResponse;
    public static final TimeLogger TIME_LOGGER = TimeLogger.create();

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ProjectGroupSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        this.setProjectInfoIdentity(e.getDataEntities());
        boolean isOk = this.showConfirm(e);
        if (!isOk) {
            e.setCancelOperation(true);
            return;
        }
        this.eventId = ORM.create().genLongId("haos_projteambaseinfo");
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities.length == 0) {
            return;
        }
        for (DynamicObject dataEntity : dataEntities) {
            dataEntity.set("org", (Object)dataEntity.getDynamicObject("belongadminorg.org"));
        }
        OpParam opParam = new OpParam();
        opParam.setOpType(e.getOperationKey());
        this.list = ProjStrategyService.INSTANCE.getUpdateStrategyParam(dataEntities);
        TIME_LOGGER.start();
        this.hisResponse = ProjectGroupBaseService.getInstance().change(dataEntities, Long.valueOf(this.eventId), opParam);
        TIME_LOGGER.check("after change");
        if ("donothing_confirmchangeparent".equals(e.getOperationKey()) && !CollectionUtils.isEmpty((Collection)((BatchVersionChangeRespData)this.hisResponse.getData()).getVersionChangeRespDataList())) {
            this.synPrjRoleOrg(((VersionChangeRespData)((BatchVersionChangeRespData)this.hisResponse.getData()).getVersionChangeRespDataList().get(0)).getNewDynamicObjects());
            this.changeParentRole(dataEntities);
            this.changeCoopRel(dataEntities[0]);
        }
        TIME_LOGGER.check("after synPrjRoleOrg");
        ProjChangeEventService.handleChangeEventHis(this.hisResponse, (String)"haos_projteambaseinfo", (Boolean)true);
    }

    private void changeParentRole(DynamicObject[] dataEntities) {
        ArrayList list = new ArrayList(16);
        HashMap<String, Long> map = new HashMap<String, Long>(8);
        for (DynamicObject dataEntity : dataEntities) {
            long parentId;
            DynamicObject parentProject = dataEntity.getDynamicObject("parentprojectteam");
            if (parentProject == null) {
                DynamicObject parentAdmin = dataEntity.getDynamicObject("belongadminorg");
                parentId = parentAdmin.getLong("id");
            } else {
                parentId = parentProject.getLong("id");
            }
            map.put("projectId", dataEntity.getLong("boid"));
            map.put("newParentId", parentId);
            list.add(map);
        }
        HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IProjectRoleService", (String)"changeParentRole", (Object[])new Object[]{list});
    }

    private void synPrjRoleOrg(DynamicObject[] prjTeams) {
        List filteredPrjTeamList = Arrays.stream(prjTeams).filter(prjTeam -> prjTeam.getLong("id") != prjTeam.getLong("boid")).collect(Collectors.toList());
        Map response = (Map)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IProjectRoleService", (String)"changeProjectRoleOrg", (Object[])new Object[]{filteredPrjTeamList});
        new LogUtil(LOGGER).infoIfEnabled(() -> String.format("invoke hbpm's IProjectRoleService's changeProjectRoleOrg success with response: %s", response));
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        ProjStrategyService.INSTANCE.updateStrategy(this.list);
        ProTeamMsgService.getInstance().sendProTeamChgMsg(this.hisResponse);
    }

    private void changeCoopRel(DynamicObject dataEntity) {
        long boId = dataEntity.getLong("boid");
        DynamicObject parentProject = dataEntity.getDynamicObject("parentprojectteam");
        long parentId = parentProject == null ? dataEntity.getDynamicObject("belongadminorg").getLong("id") : parentProject.getLong("id");
        TeamCoopRelBO teamCoopRelBO = new TeamCoopRelBO(Long.valueOf(boId), Long.valueOf(1010L), Long.valueOf(parentId), 0);
        teamCoopRelBO.setEffDate(dataEntity.getDate("bsed"));
        TeamCoopRelServiceImpl.getInstance().ChangeOne(teamCoopRelBO);
    }

    private void setProjectInfoIdentity(DynamicObject[] dataEntity) {
        DynamicObject memoryPJTDy = dataEntity[0];
        DynamicObject[] dbPJTDys = PRJOrgRepository.getInstance().queryByPks("id, projectname, projectidentify, rootprojectteam.projectidentify, belongadminorg.id, parentorg.otclassify.id", (Collection)Sets.newHashSet((Object[])new Long[]{memoryPJTDy.getLong("boid")}));
        DynamicObject dbCurPJTDy = dbPJTDys[0];
        int changeType = this.projectInfoService.getChangeType(dbCurPJTDy, memoryPJTDy);
        switch (changeType) {
            case 4: {
                boolean isProjectNameChanged;
                boolean isBelongAdOrgChanged = memoryPJTDy.getLong("belongadminorg.id") != dbCurPJTDy.getLong("belongadminorg.id");
                boolean bl = isProjectNameChanged = !new LocaleStringComparator().compareAllMatch(dbCurPJTDy.getLocaleString("projectname"), memoryPJTDy.getLocaleString("projectname"));
                if (!isBelongAdOrgChanged || !isProjectNameChanged) break;
                memoryPJTDy.set("projectidentify", (Object)ORM.create().genStringId("haos_projteambaseinfo"));
                this.setShowConfirm(true);
                break;
            }
            case 2: {
                this.setShowConfirm(true);
            }
            case 3: {
                if (HRStringUtils.equals((String)dbCurPJTDy.getString("rootprojectteam.projectname"), (String)memoryPJTDy.getString("rootprojectteam.projectname"))) break;
                this.setShowConfirm(true);
                break;
            }
            case 1: {
                memoryPJTDy.set("projectidentify", (Object)ORM.create().genStringId("haos_projteambaseinfo"));
                this.setShowConfirm(true);
                break;
            }
            default: {
                throw new KDBizException("projectInfoService change type not supported");
            }
        }
    }

    private boolean showConfirm(BeginOperationTransactionArgs e) {
        boolean isProjectInfoIdentityChanged;
        if (HRStringUtils.equals((String)e.getOperationKey(), (String)"donothing_confirmchangeparent") && (isProjectInfoIdentityChanged = this.isShowConfirm())) {
            DynamicObject memoryPJTDy = e.getDataEntities()[0];
            DynamicObject[] dbPJTDys = PRJOrgRepository.getInstance().queryByPks("id, rootprojectteam.projectidentify, rootprojectteam.projectname", (Collection)Sets.newHashSet((Object[])new Long[]{memoryPJTDy.getLong("boid"), memoryPJTDy.getLong("parentorg.id")}));
            Map<Long, DynamicObject> idVsDbPJTDy = Arrays.stream(dbPJTDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
            DynamicObject dbCurPJTDy = idVsDbPJTDy.get(memoryPJTDy.getLong("boid"));
            DynamicObject dbParentPJTDy = idVsDbPJTDy.get(memoryPJTDy.getLong("parentorg.id"));
            String newProjectName = this.projectInfoService.isRootProjectTeam(memoryPJTDy) ? memoryPJTDy.getString("projectname") : dbParentPJTDy.getString("rootprojectteam.projectname");
            String message = String.format(ResManager.loadKDString((String)"\u9879\u76ee\u5c06\u4ece\u201c%1$s\u201d\u53d8\u66f4\u4e3a\u201c%2$s\u201d", (String)"ProjectGroupChangeOp_0", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), dbCurPJTDy.getString("rootprojectteam.projectname"), newProjectName);
            return OpConfirmHelper.showConfirmMessage((OperateOption)this.operateOption, (String)"kd.hr.haos.opplugin.web.projectgroup.ProjectGroupChangeOp", (String)message);
        }
        return true;
    }

    private boolean isShowConfirm() {
        return this.showConfirm;
    }

    private void setShowConfirm(boolean showConfirm) {
        this.showConfirm = showConfirm;
    }
}

