/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.projectgroup.validate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.hr.haos.business.servicehelper.ProjectGroupServiceHelper;
import kd.hr.haos.common.constants.projectgroup.ProjectGroupMDConstants;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class ProjTeamDisableValidator
extends HRDataBaseValidator
implements ProjectGroupMDConstants {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ArrayList idSet = new ArrayList(16);
        HashMap idDynMap = new HashMap(dataEntities.length);
        Arrays.stream(dataEntities).forEach(dyn -> {
            Long id = dyn.getDataEntity().getLong("id");
            idSet.add(id);
            idDynMap.put(id, dyn);
        });
        Set containPerson = ProjectGroupServiceHelper.checkProjectGroupMembersById(idSet);
        String loadString = ResManager.loadKDString((String)"\u5b58\u5728\u5728\u804c\u4eba\u5458\uff0c\u4e0d\u80fd\u7981\u7528\u3002", (String)"ProjTeamDisableValidator_1", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
        if (!ObjectUtils.isEmpty((Object)containPerson)) {
            throw new KDBizException(loadString);
        }
        Object[] proTeamDynArr = ProjectGroupServiceHelper.getEnableProTeamDynArrById(idSet);
        if (ObjectUtils.isEmpty((Object[])proTeamDynArr)) {
            String projNotExitTip = ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u56e2\u961f\u5df2\u88ab\u7981\u7528\uff0c\u4e0d\u80fd\u91cd\u590d\u7981\u7528\u3002", (String)"ProjTeamDisableValidator_0", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
            Arrays.stream(dataEntities).forEach(dyn -> this.addErrorMessage((ExtendedDataEntity)dyn, projNotExitTip));
            return;
        }
        Set<Long> enableIdSet = Arrays.stream(proTeamDynArr).map(dyn -> dyn.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] proTeamCoopRelArr = ProjectGroupServiceHelper.getCurEnableProTeamCoopArr(new ArrayList(enableIdSet));
        Map proTeamCoopDateMap = ProjectGroupServiceHelper.getProTeamOrgIdEffDateMap((DynamicObject[])proTeamCoopRelArr);
        DynamicObject[] curAndSubProTeamDynArr = ProjectGroupServiceHelper.getSubProjectArray(enableIdSet);
        HashMap<Long, DynamicObject> curEnableProTeamDynMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject dyn2 : curAndSubProTeamDynArr) {
            Long proTeamId = dyn2.getLong("id");
            if (!idSet.contains(proTeamId)) continue;
            curEnableProTeamDynMap.put(proTeamId, dyn2);
        }
        Map variables = this.getOption().getVariables();
        String effDateStr = (String)variables.get("bsed");
        Date effDate = new Date(Long.parseLong(effDateStr));
        Date effectDate = ProjectGroupServiceHelper.formatDateYYYYMMDD((Date)effDate);
        this.checkDisProTeamEffDateAndDisStatus(dataEntities, enableIdSet, proTeamCoopDateMap, curEnableProTeamDynMap, effectDate);
    }

    private void checkDisProTeamEffDateAndDisStatus(ExtendedDataEntity[] dataEntities, Set<Long> enableIdSet, Map<Long, Date> proTeamCoopDateMap, Map<Long, DynamicObject> curEnableProTeamDynMap, Date effectDate) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Date coopRelLastEffDate;
            Date coopDate;
            Date startDate;
            DynamicObject dyn = dataEntity.getDataEntity();
            Long proTeamId = dyn.getLong("id");
            if (!enableIdSet.contains(proTeamId)) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e3a\u7981\u7528\u72b6\u6001\u3002", (String)"ProjTeamDisableValidator_2", (String)"hrmp-haos-opplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObject project = curEnableProTeamDynMap.get(proTeamId);
            if (!enableIdSet.contains(proTeamId) || project == null || (startDate = ProjectGroupServiceHelper.formatDateYYYYMMDD((Date)project.getDate("bsed"))) == null) continue;
            if (!ObjectUtils.isEmpty(proTeamCoopDateMap) && (coopDate = proTeamCoopDateMap.get(project.getLong("id"))) != null && startDate.before(coopRelLastEffDate = ProjectGroupServiceHelper.formatDateYYYYMMDD((Date)proTeamCoopDateMap.get(project.getLong("id"))))) {
                startDate = coopRelLastEffDate;
            }
            if (!effectDate.before(startDate)) continue;
            String msg = ResManager.loadKDString((String)"%1$s\uff1a\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u751f\u6548\u65e5\u671f\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjTeamDisableValidator_3", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
            String errMsg = String.format(Locale.ROOT, msg, project.getString("number"), HRDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd"));
            this.addErrorMessage(dataEntity, errMsg);
            this.getValidateResult().setSuccess(false);
        }
    }
}

