/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.projectgroup.validate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.haos.business.domain.repository.orgteam.OTQueryRepository;
import kd.hr.haos.common.constants.projectgroup.ProjectGroupMDConstants;
import kd.hr.haos.common.util.tree.FindSubTree;
import kd.hr.haos.common.util.tree.Node;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class ProjTeamEnableValidator
extends HRDataBaseValidator
implements ProjectGroupMDConstants {
    Set<Long> curBatchBoSet;

    public void initialize() {
        super.initialize();
        this.curBatchBoSet = Arrays.stream(this.getDataEntities()).map(ExtendedDataEntity::getDataEntity).map(pjt -> pjt.getLong("boid")).collect(Collectors.toSet());
    }

    public Set<String> preparePropertys() {
        Set strings = super.preparePropertys();
        strings.add("enable");
        strings.add("boid");
        strings.add("parentorg");
        return strings;
    }

    public void validate() {
        this.checkSelfDisable();
        this.checkParentEnable();
    }

    private void checkParentEnable() {
        List<ExtendedDataEntity> failList = this.checkFaildPjtExt();
        String msg = ResManager.loadKDString((String)"%s\uff1a\u8be5\u6570\u636e\u7684\u4e0a\u7ea7\u9879\u76ee\u56e2\u961f\u662f\u5df2\u7981\u7528\u72b6\u6001\uff0c\u8bf7\u5148\u542f\u7528\u4e0a\u7ea7\u9879\u76ee\u56e2\u961f\u3002", (String)"ProjTeamEnableValidator_1", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
        failList.stream().forEach(pjtExt -> this.addErrorMessage((ExtendedDataEntity)pjtExt, String.format(msg, pjtExt.getDataEntity().getString("number"))));
    }

    private List<ExtendedDataEntity> checkFaildPjtExt() {
        List<CheckParentEnableModel> checkParentEnableModelList = this.getCheckParentEnableModels();
        Map<Long, Long> boVsParentBo = checkParentEnableModelList.stream().collect(Collectors.toMap(model -> model.bo, model -> model.parentBo));
        Map<Long, CheckParentEnableModel> boVsPtj = checkParentEnableModelList.stream().collect(Collectors.toMap(model -> model.bo, model -> model));
        FindSubTree findSubTree = new FindSubTree(boVsParentBo, boVsPtj);
        findSubTree.levelTraverse(this.createNodeVisitor());
        return checkParentEnableModelList.stream().filter(model -> this.curBatchBoSet.contains(model.bo)).filter(model -> "0".equals(model.enable)).map(model -> model.pjtExt).collect(Collectors.toList());
    }

    private List<CheckParentEnableModel> getCheckParentEnableModels() {
        Set<Long> parentNotInCurBatchBoSet = Arrays.stream(this.getDataEntities()).map(pjtExt -> pjtExt.getDataEntity().getLong("parentorg.id")).filter(otBo -> !this.curBatchBoSet.contains(otBo)).collect(Collectors.toSet());
        DynamicObject[] dbPjtArr = this.queryOriginalOt("boid, parent.id, enable", parentNotInCurBatchBoSet);
        return this.packageCheckParentEnableModel(dbPjtArr);
    }

    private DynamicObject[] queryOriginalOt(String selectFields, Set<Long> parentBoSet) {
        if (parentBoSet.size() == 0) {
            return new DynamicObject[0];
        }
        return OTQueryRepository.getInstance().queryOriginalArrById(selectFields, parentBoSet);
    }

    private List<CheckParentEnableModel> packageCheckParentEnableModel(DynamicObject[] dbPjtArr) {
        List parentModel = Arrays.stream(dbPjtArr).map(ot -> {
            CheckParentEnableModel checkParentEnableModel = new CheckParentEnableModel();
            checkParentEnableModel.bo = ot.getLong("boid");
            checkParentEnableModel.parentBo = ot.getLong("parent.id");
            checkParentEnableModel.enable = ot.getString("enable");
            return checkParentEnableModel;
        }).collect(Collectors.toList());
        List curBatchModel = Arrays.stream(this.getDataEntities()).map(pjtExt -> {
            DynamicObject pjt = pjtExt.getDataEntity();
            CheckParentEnableModel checkParentEnableModel = new CheckParentEnableModel();
            checkParentEnableModel.bo = pjt.getLong("boid");
            checkParentEnableModel.parentBo = pjt.getLong("parentorg.id");
            checkParentEnableModel.enable = pjt.getString("enable");
            checkParentEnableModel.pjtExt = pjtExt;
            return checkParentEnableModel;
        }).collect(Collectors.toList());
        ArrayList<CheckParentEnableModel> result = new ArrayList<CheckParentEnableModel>();
        result.addAll(parentModel);
        result.addAll(curBatchModel);
        return result;
    }

    private Consumer<Node<CheckParentEnableModel>> createNodeVisitor() {
        return node -> {
            CheckParentEnableModel parent = (CheckParentEnableModel)node.getData();
            List directChildPjtList = node.getChildList();
            if ("1".equals(parent.enable)) {
                directChildPjtList.forEach(checkedDirectChildPjt -> {
                    ((CheckParentEnableModel)checkedDirectChildPjt.getData()).enable = "1";
                });
            }
        };
    }

    private void checkSelfDisable() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Arrays.stream(dataEntities).forEach(pjtExt -> {
            String enable = pjtExt.getDataEntity().getString("enable");
            String msg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e3a\u5df2\u542f\u7528\u72b6\u6001\u3002", (String)"ProjTeamEnableValidator_0", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
            if ("1".equals(enable)) {
                this.addErrorMessage((ExtendedDataEntity)pjtExt, msg);
            }
        });
    }

    static class CheckParentEnableModel {
        long bo;
        long parentBo;
        String enable;
        ExtendedDataEntity pjtExt;

        CheckParentEnableModel() {
        }
    }
}

