/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.projectgroup.validate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.service.projectgroup.valid.core.ProjectGroupValidContext;
import kd.hr.haos.business.servicehelper.ProjectGroupServiceHelper;
import kd.hr.haos.common.constants.projectgroup.ProjectGroupMDConstants;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class ProjectGroupSaveValidator
extends HRDataBaseValidator
implements ProjectGroupMDConstants {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        DynamicObject dataDyn;
        String operateKey = this.getOperateKey();
        String errMsg = this.getProTeamDisErrMsg(operateKey, dataDyn = (dataEntities = this.getDataEntities())[0].getDataEntity());
        if (!StringUtils.isEmpty((CharSequence)errMsg)) {
            for (ExtendedDataEntity dyn : dataEntities) {
                this.addErrorMessage(dyn, errMsg);
            }
            return;
        }
        DynamicObjectCollection objects = dataDyn.getDynamicObjectCollection("entryentity");
        for (DynamicObject s : objects) {
            if (s.get("coopreltype") != null && s.get("cooporgteam") != null) continue;
            String loadKDString = ResManager.loadKDString((String)"\u534f\u4f5c\u4fe1\u606f\u672a\u586b\u5199\u5b8c\u6210\uff0c\u8bf7\u586b\u5199\u3002", (String)"ProjectGroupSaveValidator_1", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntities[0], loadKDString);
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject targetObject = dataEntity.getDataEntity();
            ProjectGroupValidContext projectGroupValidContext = new ProjectGroupValidContext(targetObject, operateKey);
            List result = projectGroupValidContext.valid();
            if (CollectionUtils.isEmpty((Collection)result)) continue;
            result.forEach(calibratorResult -> this.addErrorMessage(dataEntity, calibratorResult.getMessage()));
        }
    }

    private String getProTeamDisErrMsg(String operateKey, DynamicObject dataDyn) {
        String errMsg = null;
        if (HRStringUtils.equals((String)"donothing_confirmchangeinfo", (String)operateKey) || HRStringUtils.equals((String)"donothing_confirmchangeparent", (String)operateKey)) {
            ArrayList<Long> boIdList = new ArrayList<Long>(2);
            boIdList.add(dataDyn.getLong("id"));
            Object[] proTeamDynArr = ProjectGroupServiceHelper.getEnableProTeamDynArrById(boIdList);
            if (ObjectUtils.isEmpty((Object[])proTeamDynArr)) {
                errMsg = ResManager.loadKDString((String)"\u4e0d\u53ef\u53d8\u66f4\u5df2\u7981\u7528\u7684\u9879\u76ee\u56e2\u961f\u4fe1\u606f\u3002", (String)"ProjectGroupSaveValidator_0", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
            }
        } else if (HRStringUtils.equals((String)"donothing_save_rel", (String)operateKey)) {
            ArrayList<String> numberList = new ArrayList<String>(2);
            numberList.add(dataDyn.getString("number"));
            Object[] proTeamDynArr = ProjectGroupServiceHelper.getEnableProTeamDynArrByNumber(numberList);
            if (ObjectUtils.isEmpty((Object[])proTeamDynArr)) {
                errMsg = ResManager.loadKDString((String)"\u4e0d\u53ef\u53d8\u66f4\u5df2\u7981\u7528\u7684\u9879\u76ee\u56e2\u961f\u534f\u4f5c\u5173\u7cfb\u3002", (String)"ProjectGroupSaveValidator_2", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
            }
        }
        return errMsg;
    }
}

