/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.staff;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.application.impl.staff.StaffInfoApplicationImpl;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;

public class OrgStaffDeleteOp
extends HRDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs event) {
        event.getFieldKeys().add("enable");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs event) {
        DynamicObject[] dataEntities = event.getDataEntities();
        ArrayList needToDeleteData = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList otherDate = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject dataEntity : dataEntities) {
            if ("10".equals(dataEntity.getString("enable"))) {
                needToDeleteData.add(dataEntity);
                continue;
            }
            otherDate.add(dataEntity);
        }
        StaffInfoApplicationImpl staffInfoApplication = new StaffInfoApplicationImpl();
        staffInfoApplication.deleteStaffInfo(needToDeleteData.toArray(new DynamicObject[0]));
        this.assembleDisplayResult(dataEntities, needToDeleteData, otherDate);
    }

    private void assembleDisplayResult(DynamicObject[] dataEntities, List<DynamicObject> needToDeleteData, List<DynamicObject> otherDate) {
        if (!CollectionUtils.isEmpty(otherDate)) {
            String title = String.format(ResManager.loadKDString((String)"\u5355\u636e\u603b\u6761\u6570\uff1a%1$s\uff0c\u5220\u9664\u6210\u529f\u6761\u6570\uff1a%2$s\uff0c\u5220\u9664\u5931\u8d25\u603b\u6761\u6570\uff1a%3$s\u3002", (String)"OrgStaffDeleteOp_0", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), dataEntities.length, needToDeleteData.size(), otherDate.size());
            String numbers = otherDate.stream().map(dyn -> dyn.getString("number")).collect(Collectors.joining(","));
            String message = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u4e3a\u201c\u5f85\u542f\u7528\u201d\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"OrgStaffDeleteOp_1", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), numbers);
            this.getOption().setVariableValue("message", message);
            this.getOption().setVariableValue("title", title);
            this.getOption().setVariableValue("showConfirm", String.valueOf(needToDeleteData.size() == 0 && otherDate.size() == 1));
        }
    }
}

