/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.staff;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.service.impl.staff.StaffReportService;
import kd.hr.haos.business.service.staff.bean.StaffHisParamBO;
import kd.hr.haos.business.service.staff.service.OrgStaffBaseService;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.haos.opplugin.web.staff.validate.OrgStaffEnableValidator;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;

public class OrgStaffEnableOp
extends HRDataBaseOp
implements OrgStaffConstants {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new OrgStaffEnableValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("year");
        e.getFieldKeys().add("org");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        String operationKey = e.getOperationKey();
        this.enableStaffEntry(dataEntities, operationKey);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        StaffReportService staffReportSaveService = new StaffReportService();
        staffReportSaveService.saveReportData(Arrays.stream(e.getDataEntities()).map(dyn -> dyn.getLong("id")).collect(Collectors.toList()));
    }

    private void enableStaffEntry(DynamicObject[] dataEntities, String operationKey) {
        ArrayList staffHisParamBOs = Lists.newArrayListWithExpectedSize((int)16);
        List<Long> staffIdList = Arrays.stream(dataEntities).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> staffVsDutyOrgDynListMap = this.getStaffVsDynListMap(staffIdList, "haos_dutyorgdetail");
        Map<Long, List<DynamicObject>> staffVsUseOrgDynListMap = this.getStaffVsDynListMap(staffIdList, "haos_useorgdetail");
        Map<Long, List<DynamicObject>> staffVsMulDynListMap = this.getStaffVsDynListMap(staffIdList, "haos_muldimendetail");
        for (DynamicObject dataEntity : dataEntities) {
            this.buildParamBOs4DutyOrg(dataEntity, staffHisParamBOs, staffVsDutyOrgDynListMap);
            this.buildParamBOs4UseOrg(dataEntity, staffHisParamBOs, staffVsUseOrgDynListMap);
            this.buildParamBOs4Mul(dataEntity, staffHisParamBOs, staffVsMulDynListMap);
        }
        OrgStaffBaseService opService = new OrgStaffBaseService();
        if ("enable".equals(operationKey) && staffHisParamBOs.size() > 0) {
            opService.enable((List)staffHisParamBOs);
        }
    }

    private void buildParamBOs4DutyOrg(DynamicObject dataEntity, List<StaffHisParamBO> staffHisParamBOs, Map<Long, List<DynamicObject>> staffVsDynListMap) {
        this.buildParamBOs(dataEntity, staffHisParamBOs, staffVsDynListMap, "haos_dutyorgdetail");
    }

    private void buildParamBOs4UseOrg(DynamicObject dataEntity, List<StaffHisParamBO> staffHisParamBOs, Map<Long, List<DynamicObject>> staffVsDynListMap) {
        this.buildParamBOs(dataEntity, staffHisParamBOs, staffVsDynListMap, "haos_useorgdetail");
    }

    private void buildParamBOs4Mul(DynamicObject dataEntity, List<StaffHisParamBO> staffHisParamBOs, Map<Long, List<DynamicObject>> staffVsDynListMap) {
        this.buildParamBOs(dataEntity, staffHisParamBOs, staffVsDynListMap, "haos_muldimendetail");
    }

    private void buildParamBOs(DynamicObject dataEntity, List<StaffHisParamBO> staffHisParamBOs, Map<Long, List<DynamicObject>> staffVsDynListMap, String entryName) {
        long staffId = dataEntity.getLong("id");
        List dynList = staffVsDynListMap.getOrDefault(staffId, new ArrayList());
        dynList.forEach(dyn -> dyn.set("enable", (Object)"1"));
        if (!CollectionUtils.isEmpty((Collection)dynList)) {
            staffHisParamBOs.add(new StaffHisParamBO(entryName, dynList));
        }
    }

    private Map<Long, List<DynamicObject>> getStaffVsDynListMap(List<Long> staffIdList, String entityName) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityName);
        QFilter staffIdFilter = new QFilter("staff", "in", staffIdList);
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"-3");
        dataStatusFilter.or(new QFilter("datastatus", "in", (Object)"1"));
        DynamicObject[] dyns = helper.loadDynamicObjectArray(new QFilter[]{staffIdFilter, dataStatusFilter});
        return Arrays.stream(dyns).collect(Collectors.groupingBy(dyn -> dyn.getLong("staff.id")));
    }
}

