/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.staff;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.InitOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.haos.business.application.impl.staff.StaffInfoApplicationImpl;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.domain.repository.adorg.AdminOrgStructRepository;
import kd.hr.haos.business.domain.repository.other.LaborRelTypeRepository;
import kd.hr.haos.business.domain.repository.staff.StaffRuleConfigEntryRepository;
import kd.hr.haos.business.service.staff.bean.StaffRuleConfigEntryBO;
import kd.hr.haos.business.service.staff.bean.UseOrgEntryParamBO;
import kd.hr.haos.business.service.staff.service.StaffCommonService;
import kd.hr.haos.business.service.staff.service.StaffRuleConfigHelper;
import kd.hr.haos.business.util.ConcurrentIdCreator;
import kd.hr.haos.business.util.TimeLogger;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.haos.common.constants.staff.OrgStaffRuleConfigConstants;
import kd.hr.haos.opplugin.web.staff.validate.OrgStaffRuleConfigValidator;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;

public class OrgStaffRuleConfigSaveOp
extends HRDataBaseOp
implements OrgStaffRuleConfigConstants,
OrgStaffConstants {
    private static final Log logger = LogFactory.getLog(OrgStaffRuleConfigSaveOp.class);
    private TimeLogger timeLogger = TimeLogger.create();
    private ConcurrentIdCreator concurrentIdCreator = new ConcurrentIdCreator();
    Map<Long, Long> entryIdVsStaffIdMap = Maps.newHashMapWithExpectedSize((int)16);

    public void initialize(InitOperationArgs initOperationArgs) {
        super.initialize(initOperationArgs);
        this.getOption().setVariableValue("ignorerefentityids", "haos_staffruleconfigentry");
    }

    public void onAddValidators(AddValidatorsEventArgs event) {
        event.addValidator((AbstractValidator)new OrgStaffRuleConfigValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        this.timeLogger.start();
        DynamicObject[] dataEntities = e.getDataEntities();
        Map<Long, Map<Long, List<StaffRuleConfigEntryBO>>> ruleConfigIdVsBoListMap = this.getRuleConfigIdVsBoList(dataEntities);
        Map<Long, Map<Long, UseOrgEntryParamBO>> orgIdVsEntryBoIdVsBOMap = this.getOrgIdVsBoMap(dataEntities);
        ArrayList staffDynList = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
        Map<Long, HashSet<Long>[]> positionAndJobIdMap = this.getPositionAndJobIdMap(dataEntities);
        String[] staffNumberArray = this.getStaffNumberArray(ruleConfigIdVsBoListMap);
        Map<Long, List<DynamicObject>> ruleConfigIdVsEntryDynMap = this.getRuleConfigIdVsEntryDynMap(dataEntities);
        int staffNumberIndex = 0;
        for (DynamicObject dataEntity : dataEntities) {
            long ruleConfigId = dataEntity.getLong("id");
            this.deleteRefStaffDyn(ruleConfigIdVsEntryDynMap, dataEntity, ruleConfigId);
            Map<Long, List<StaffRuleConfigEntryBO>> entryIdVsEntryBOListMap = ruleConfigIdVsBoListMap.get(ruleConfigId);
            if (CollectionUtils.isEmpty(entryIdVsEntryBOListMap)) continue;
            Set<Map.Entry<Long, List<StaffRuleConfigEntryBO>>> entries = entryIdVsEntryBOListMap.entrySet();
            for (Map.Entry<Long, List<StaffRuleConfigEntryBO>> ruleConfigEntry : entries) {
                Long ruleConfigEntryId = ruleConfigEntry.getKey();
                List<StaffRuleConfigEntryBO> ruleConfigEntryBoList = ruleConfigEntry.getValue();
                long staffId = this.concurrentIdCreator.getId();
                this.entryIdVsStaffIdMap.put(ruleConfigEntryId, staffId);
                DynamicObject staffDyn = this.buildStaffDyn(staffNumberArray[staffNumberIndex++], ruleConfigEntryBoList, staffId);
                StaffRuleConfigEntryBO ruleConfigEntryBO = ruleConfigEntryBoList.get(0);
                DynamicObjectCollection useOrgEntryColl = staffDyn.getDynamicObjectCollection("bentryentity");
                DynamicObject staffProjectDyn = ruleConfigEntryBO.getStaffProjectDyn();
                DynamicObject orgDyn = ruleConfigEntryBO.getRuleConfigDyn().getDynamicObject("org");
                Map<Long, UseOrgEntryParamBO> entryAdminBoIdOrgIdVsBoMap = orgIdVsEntryBoIdVsBOMap.get(orgDyn.getLong("id"));
                for (StaffRuleConfigEntryBO staffRuleConfigEntryBO : ruleConfigEntryBoList) {
                    Long adminOrgBoId = staffRuleConfigEntryBO.getAdminOrgId();
                    UseOrgEntryParamBO useOrgEntryParamBO = entryAdminBoIdOrgIdVsBoMap.get(adminOrgBoId);
                    if (useOrgEntryParamBO == null) continue;
                    useOrgEntryParamBO.setParentEntryId(0L);
                    this.traverseUseOrgEntryBo(useOrgEntryParamBO, staffRuleConfigEntryBO, useOrgEntryColl);
                }
                Map<Long, DynamicObject> useOrgBoIdVsDynMap = useOrgEntryColl.stream().collect(Collectors.toMap(useOrgEntry -> useOrgEntry.getLong("buseorg.boid"), useOrgEntry -> useOrgEntry));
                this.buildMultiEntry(useOrgBoIdVsDynMap, staffProjectDyn, positionAndJobIdMap);
                staffDyn.set("bentryentity", (Object)useOrgEntryColl);
                staffDynList.add(staffDyn);
            }
        }
        this.timeLogger.check("beforesave cost:");
        if (!CollectionUtils.isEmpty((Collection)staffDynList)) {
            StaffInfoApplicationImpl staffInfoApplication = new StaffInfoApplicationImpl();
            staffInfoApplication.saveStaffInfo(staffDynList.toArray(new DynamicObject[0]));
            this.setEntryRefStaff(dataEntities);
        }
        this.timeLogger.end();
    }

    private void deleteRefStaffDyn(Map<Long, List<DynamicObject>> ruleConfigIdVsEntryDynMap, DynamicObject dataEntity, long ruleConfigId) {
        List<DynamicObject> entryDynListFromDB = ruleConfigIdVsEntryDynMap.get(ruleConfigId);
        if (CollectionUtils.isEmpty(entryDynListFromDB)) {
            return;
        }
        Map<Long, DynamicObject> ruleConfigEntryIdVsStaffDynMap = entryDynListFromDB.stream().filter(dyn -> dyn.getDynamicObject("refstaff") != null).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getDynamicObject("refstaff")));
        List entryIdListFromDB = entryDynListFromDB.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection entryDynCol = dataEntity.getDynamicObjectCollection("entryentity");
        List entryIdListFromPage = entryDynCol.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        entryIdListFromDB.removeAll(entryIdListFromPage);
        ArrayList toDeleteStaffDynList = Lists.newArrayListWithExpectedSize((int)entryIdListFromDB.size());
        entryIdListFromDB.stream().forEach(entryId -> toDeleteStaffDynList.add(ruleConfigEntryIdVsStaffDynMap.get(entryId)));
        logger.info("OrgStaffRuleConfigSaveOp#deleteRefStaffDyn.toDeleteStaffDynList= {}", toDeleteStaffDynList.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toList()));
        StaffInfoApplicationImpl staffInfoApplication = new StaffInfoApplicationImpl();
        staffInfoApplication.deleteStaffInfo(toDeleteStaffDynList.toArray(new DynamicObject[0]));
    }

    private Map<Long, List<DynamicObject>> getRuleConfigIdVsEntryDynMap(DynamicObject[] dataEntities) {
        List ruleConfigIdList = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getLong("id")).collect(Collectors.toList());
        QFilter staffRuleConfigIdFilter = new QFilter("staffruleconfig", "in", ruleConfigIdList);
        DynamicObject[] ruleConfigEntryDyns = StaffRuleConfigEntryRepository.getInstance().queryByFilter(staffRuleConfigIdFilter);
        return Arrays.stream(ruleConfigEntryDyns).collect(Collectors.groupingBy(dyn -> dyn.getLong("staffruleconfig.id")));
    }

    private void setEntryRefStaff(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection ruleConfigEntryCol = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject ruleConfigEntry : ruleConfigEntryCol) {
                long entryId = ruleConfigEntry.getLong("id");
                Long staffId = this.entryIdVsStaffIdMap.get(entryId);
                if (staffId == null || staffId == 0L) continue;
                ruleConfigEntry.set("refstaff", (Object)staffId);
            }
        }
    }

    private Map<Long, HashSet<Long>[]> getPositionAndJobIdMap(DynamicObject[] dataEntities) {
        ArrayList structNumberList = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection ruleConfigEntryCol = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject ruleConfigEntry : ruleConfigEntryCol) {
                if (!Objects.isNull(ruleConfigEntry.getDynamicObject("refstaff"))) continue;
                DynamicObjectCollection ruleOrgCol = ruleConfigEntry.getDynamicObjectCollection("staffruleorg");
                for (DynamicObject ruleOrgDyn : ruleOrgCol) {
                    String adminOrgStructNumber = ruleOrgDyn.getString("fbasedataid.structnumber");
                    structNumberList.add(adminOrgStructNumber);
                }
            }
        }
        DynamicObject[] adminOrgStructDyns = AdminOrgStructRepository.getInstance().queryOriginStructInfoLikeStructNum("id, adminorg", (List)structNumberList);
        List adminOrgBoIdList = Arrays.stream(adminOrgStructDyns).map(dyn -> dyn.getLong("adminorg")).collect(Collectors.toList());
        return StaffCommonService.getPositionAndJobIds(adminOrgBoIdList);
    }

    private DynamicObject buildStaffDyn(String number, List<StaffRuleConfigEntryBO> entryBoList, long staffId) {
        StaffRuleConfigEntryBO entryBO = entryBoList.get(0);
        HRBaseServiceHelper staffHelper = new HRBaseServiceHelper("haos_staff");
        DynamicObject staffDyn = staffHelper.generateEmptyDynamicObject();
        DynamicObject ruleConfigDyn = entryBO.getRuleConfigDyn();
        staffDyn.set("id", (Object)staffId);
        staffDyn.set("number", (Object)number);
        String name = this.createOrgName(entryBoList, String.valueOf(HRDateTimeUtils.getYear((Date)ruleConfigDyn.getDate("year"))));
        staffDyn.set("name", (Object)name);
        staffDyn.set("enable", (Object)"10");
        DynamicObject orgDyn = ruleConfigDyn.getDynamicObject("org");
        staffDyn.set("org", (Object)orgDyn);
        staffDyn.set("year", (Object)ruleConfigDyn.getDate("year"));
        staffDyn.set("staffcycle", (Object)ruleConfigDyn.getDynamicObject("staffcycle"));
        DynamicObject staffProjectDyn = entryBO.getStaffProjectDyn();
        staffDyn.set("staffproject", (Object)staffProjectDyn);
        DynamicObjectCollection dimensionDynCol = staffDyn.getDynamicObjectCollection("staffdimension");
        this.buildMultiBaseData(dimensionDynCol, staffProjectDyn);
        staffDyn.set("staffdimension", (Object)dimensionDynCol);
        String controlStrategy = staffProjectDyn.getString("controlstrategy");
        staffDyn.set("staffcontrolstrategy", (Object)controlStrategy);
        if (HRStringUtils.equals((String)controlStrategy, (String)"3")) {
            staffDyn.set("staffelasticcontrol", (Object)staffProjectDyn.getString("elasticcontrol"));
            staffDyn.set("staffelasticcount", (Object)staffProjectDyn.getInt("elasticcount"));
        }
        DynamicObject creator = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        creator.set("id", (Object)RequestContext.get().getUserId());
        staffDyn.set("creator", (Object)creator);
        staffDyn.set("createtime", (Object)new Date());
        staffDyn.set("status", (Object)"A");
        return staffDyn;
    }

    private String createOrgName(List<StaffRuleConfigEntryBO> entryBoList, String year) {
        int nameLength = 0;
        String post = ResManager.loadKDString((String)"\u5e74\u7f16\u5236\u4fe1\u606f", (String)"HRBigDataMultiEntityExportTask_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]);
        nameLength += year.length();
        StringBuilder nameSB = new StringBuilder();
        if ((nameLength += post.length()) + entryBoList.get(0).getAdminOrgName().length() > 255) {
            nameSB.append(entryBoList.get(0).getAdminOrgName().substring(0, 255 - nameLength - 1));
            nameSB.append("\u2026");
        } else {
            StaffRuleConfigEntryBO entryBO;
            String adminOrgName;
            Integer resultStrLength;
            Iterator<StaffRuleConfigEntryBO> iterator = entryBoList.iterator();
            while (iterator.hasNext() && (resultStrLength = Integer.valueOf(1 + nameLength + (adminOrgName = (entryBO = iterator.next()).getAdminOrgName()).length())) <= 255) {
                nameSB.append(adminOrgName);
                nameSB.append("\u3001");
                nameLength += adminOrgName.length() + 1;
            }
            nameSB.deleteCharAt(nameSB.length() - 1);
        }
        nameSB.append(year);
        nameSB.append(post);
        return nameSB.toString();
    }

    private String[] getStaffNumberArray(Map<Long, Map<Long, List<StaffRuleConfigEntryBO>>> ruleConfigIdVsBoListMap) {
        int newStaffSize = 0;
        for (Map.Entry<Long, Map<Long, List<StaffRuleConfigEntryBO>>> entries : ruleConfigIdVsBoListMap.entrySet()) {
            Map<Long, List<StaffRuleConfigEntryBO>> entryIdVsBoListMap = entries.getValue();
            Set<Map.Entry<Long, List<StaffRuleConfigEntryBO>>> entryIdVsBoListSet = entryIdVsBoListMap.entrySet();
            newStaffSize += entryIdVsBoListSet.size();
        }
        return StaffRuleConfigHelper.getNumbers((String)"haos_staff", (int)newStaffSize, (Long)0L);
    }

    private void buildMultiEntry(Map<Long, DynamicObject> useOrgBoIdVsDynMap, DynamicObject staffProjectDyn, Map<Long, HashSet<Long>[]> positionAndJobIdMap) {
        List staffDimensionIdList = staffProjectDyn.getDynamicObjectCollection("staffdimension").stream().map(dimension -> dimension.getLong("fbasedataid.id")).collect(Collectors.toList());
        Set<Map.Entry<Long, DynamicObject>> entries = useOrgBoIdVsDynMap.entrySet();
        Set laborRelTypeIds = LaborRelTypeRepository.getInstance().queryLaborRelType();
        for (Map.Entry<Long, DynamicObject> entry : entries) {
            Long useOrgBoId = entry.getKey();
            DynamicObject useOrgEntryDyn = entry.getValue();
            DynamicObjectCollection positionSubEntryCol = useOrgEntryDyn.getDynamicObjectCollection("centryentity");
            DynamicObjectCollection jobSubEntryCol = useOrgEntryDyn.getDynamicObjectCollection("dentryentity");
            DynamicObjectCollection laborSubEntryCol = useOrgEntryDyn.getDynamicObjectCollection("eentryentity");
            HashSet<Long>[] positionAndJobIds = positionAndJobIdMap.get(useOrgBoId);
            if (positionAndJobIds != null && positionAndJobIds.length > 0) {
                if (staffDimensionIdList.contains(1010L)) {
                    this.buildDimensionInfo("c", positionAndJobIds[0], positionSubEntryCol, staffProjectDyn);
                }
                if (staffDimensionIdList.contains(1020L)) {
                    this.buildDimensionInfo("d", positionAndJobIds[1], jobSubEntryCol, staffProjectDyn);
                }
            }
            if (!staffDimensionIdList.contains(1050L) || CollectionUtils.isEmpty((Collection)laborRelTypeIds)) continue;
            this.buildDimensionInfo("e", laborRelTypeIds, laborSubEntryCol, staffProjectDyn);
        }
    }

    private void buildDimensionInfo(String prefix, Set<Long> keyFieldIds, DynamicObjectCollection subEntryCol, DynamicObject staffProjectDyn) {
        if (!CollectionUtils.isEmpty(keyFieldIds)) {
            DynamicObjectType objectType = subEntryCol.getDynamicObjectType();
            for (long keyFieldId : keyFieldIds) {
                DynamicObject dyn = new DynamicObject(objectType);
                if ("c".equals(prefix)) {
                    dyn.set("cdutyworkrole_id", (Object)keyFieldId);
                } else if ("d".equals(prefix)) {
                    dyn.set("djob_id", (Object)keyFieldId);
                } else {
                    dyn.set("elaborreltype_id", (Object)keyFieldId);
                }
                dyn.set(prefix + "controlstrategy", (Object)staffProjectDyn.getString("controlstrategy"));
                dyn.set(prefix + "elasticcontrol", (Object)staffProjectDyn.getString("elasticcontrol"));
                dyn.set(prefix + "elasticcount", (Object)staffProjectDyn.getInt("elasticcount"));
                subEntryCol.add((Object)dyn);
            }
        }
    }

    private void traverseUseOrgEntryBo(UseOrgEntryParamBO useOrgEntryParamBO, StaffRuleConfigEntryBO staffRuleConfigEntryBO, DynamicObjectCollection useOrgEntryColl) {
        Boolean includeSub = staffRuleConfigEntryBO.getIncludeSub();
        this.buildUseOrgEntryData(useOrgEntryParamBO, staffRuleConfigEntryBO, useOrgEntryColl);
        if (includeSub.booleanValue()) {
            List childEntryInfos = useOrgEntryParamBO.getChildEntryInfos();
            if (CollectionUtils.isEmpty((Collection)childEntryInfos)) {
                return;
            }
            childEntryInfos.stream().forEach(childEntryParamBO -> this.traverseUseOrgEntryBo((UseOrgEntryParamBO)childEntryParamBO, staffRuleConfigEntryBO, useOrgEntryColl));
        }
    }

    private void buildUseOrgEntryData(UseOrgEntryParamBO useOrgEntryParamBO, StaffRuleConfigEntryBO staffRuleConfigEntryBO, DynamicObjectCollection useOrgEntryColl) {
        DynamicObject useOrgEntryDyn = new DynamicObject(useOrgEntryColl.getDynamicObjectType());
        useOrgEntryDyn.set("id", (Object)useOrgEntryParamBO.getId());
        useOrgEntryDyn.set("pid", (Object)useOrgEntryParamBO.getParentEntryId());
        useOrgEntryDyn.set("buseorg", (Object)useOrgEntryParamBO.getAdminOrgDyn());
        DynamicObject staffProjectDyn = staffRuleConfigEntryBO.getStaffProjectDyn();
        DynamicObjectCollection staffDimensionCol = useOrgEntryDyn.getDynamicObjectCollection("bstaffdimension");
        this.buildMultiBaseData(staffDimensionCol, staffProjectDyn);
        useOrgEntryDyn.set("bstaffdimension", (Object)staffDimensionCol);
        useOrgEntryDyn.set("bcontrolstrategy", (Object)staffProjectDyn.getString("controlstrategy"));
        useOrgEntryDyn.set("belasticcontrol", (Object)staffProjectDyn.getString("elasticcontrol"));
        useOrgEntryDyn.set("belasticcount", (Object)staffProjectDyn.getInt("elasticcount"));
        useOrgEntryColl.add((Object)useOrgEntryDyn);
    }

    private DynamicObjectCollection buildMultiBaseData(DynamicObjectCollection staffDimensionCol, DynamicObject staffProjectDyn) {
        DynamicObjectType entryType = staffDimensionCol.getDynamicObjectType();
        List staffDimensionList = staffProjectDyn.getDynamicObjectCollection("staffdimension").stream().map(dyn -> dyn.getDynamicObject("fbasedataid")).collect(Collectors.toList());
        for (DynamicObject staffDimensionFromProject : staffDimensionList) {
            DynamicObject row = new DynamicObject(entryType);
            row.set("fbasedataid", (Object)staffDimensionFromProject);
            staffDimensionCol.add((Object)row);
        }
        return staffDimensionCol;
    }

    private Map<Long, Map<Long, UseOrgEntryParamBO>> getOrgIdVsBoMap(DynamicObject[] dataEntities) {
        List orgIdList = Arrays.stream(dataEntities).filter(dataEntity -> Objects.nonNull(dataEntity.getDynamicObject("org"))).map(dataEntity -> dataEntity.getLong("org.id")).collect(Collectors.toList());
        QFilter orgIdFilter = new QFilter("org", "in", orgIdList);
        orgIdFilter.and(new QFilter("enable", "=", (Object)"1"));
        orgIdFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        orgIdFilter.and(new QFilter("datastatus", "=", (Object)"1"));
        orgIdFilter.and(new QFilter("haos_orgsortcode.datastatus", "=", (Object)"1"));
        orgIdFilter.and(new QFilter("iscurrentversion", "=", (Object)"0"));
        orgIdFilter.and(new QFilter("haos_orgsortcode.iscurrentversion", "=", (Object)"0"));
        DynamicObject[] adminOrgDyns = AdOrgRepository.getInstance().queryArrayOrderBy("id, enable, boid, parent, org", new QFilter[]{orgIdFilter}, "haos_orgsortcode.sortcode");
        Map<Long, List<DynamicObject>> orgIdVsAdminOrgDynListMap = Arrays.stream(adminOrgDyns).collect(Collectors.groupingBy(dyn -> dyn.getLong("org.id")));
        LinkedHashMap orgIdVsEntryBoIdVsBOMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        Set<Map.Entry<Long, List<DynamicObject>>> entries = orgIdVsAdminOrgDynListMap.entrySet();
        for (Map.Entry<Long, List<DynamicObject>> entry : entries) {
            HashMap adminOrgBoIdVsBoMap = Maps.newHashMapWithExpectedSize((int)16);
            ArrayList useOrgEntryBoList = Lists.newArrayListWithExpectedSize((int)16);
            List<DynamicObject> adminOrgDynList = entry.getValue();
            if (adminOrgDynList.size() < 30) {
                List adminOrgIdList = adminOrgDynList.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
                logger.info("OrgStaffRuleConfigSaveOp.getOrgIdVsBoMap,orgId={}, adminOrgIdList={}", (Object)entry.getKey(), (Object)adminOrgIdList);
            }
            for (DynamicObject adminOrgDyn : adminOrgDynList) {
                long adminOrgId = adminOrgDyn.getLong("id");
                long adminOrgBoId = adminOrgDyn.getLong("boid");
                UseOrgEntryParamBO staffEntryParamBO = new UseOrgEntryParamBO("bentryentity", "buseorg", adminOrgDyn);
                staffEntryParamBO.setId(this.concurrentIdCreator.getId());
                staffEntryParamBO.setAdminOrgId(adminOrgId);
                staffEntryParamBO.setBoId(adminOrgBoId);
                staffEntryParamBO.setParentOrgId(adminOrgDyn.getLong("parent.id"));
                adminOrgBoIdVsBoMap.put(adminOrgBoId, staffEntryParamBO);
                useOrgEntryBoList.add(staffEntryParamBO);
            }
            this.buildStaffStructInfo(useOrgEntryBoList, adminOrgBoIdVsBoMap);
            Map<Long, UseOrgEntryParamBO> idVsBoMap = useOrgEntryBoList.stream().collect(Collectors.toMap(bo -> bo.getBoId(), bo -> bo));
            orgIdVsEntryBoIdVsBOMap.put(entry.getKey(), idVsBoMap);
        }
        return orgIdVsEntryBoIdVsBOMap;
    }

    private void buildStaffStructInfo(List<UseOrgEntryParamBO> useOrgEntryBoList, Map<Long, UseOrgEntryParamBO> adminOrgBoIdVsBoMap) {
        int size = useOrgEntryBoList.size();
        for (int i = size - 1; i >= 0; --i) {
            UseOrgEntryParamBO staffEntryParamBO = useOrgEntryBoList.get(i);
            long parentOrgId = staffEntryParamBO.getParentOrgId();
            UseOrgEntryParamBO parentUseOrgEntryBo = adminOrgBoIdVsBoMap.get(parentOrgId);
            if (parentUseOrgEntryBo == null) continue;
            List childStaffEntryBoList = parentUseOrgEntryBo.getChildEntryInfos() == null ? Lists.newArrayListWithExpectedSize((int)16) : parentUseOrgEntryBo.getChildEntryInfos();
            childStaffEntryBoList.add(staffEntryParamBO);
            parentUseOrgEntryBo.setChildEntryInfos(childStaffEntryBoList);
            staffEntryParamBO.setParentEntryId(parentUseOrgEntryBo.getId());
        }
    }

    private Map<Long, Map<Long, List<StaffRuleConfigEntryBO>>> getRuleConfigIdVsBoList(DynamicObject[] dataEntities) {
        ArrayList ruleConfigEntryBOList = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection ruleConfigEntryCol = dataEntity.getDynamicObjectCollection("entryentity");
            ruleConfigEntryCol.stream().filter(entry -> Objects.isNull(entry.getDynamicObject("refstaff"))).forEach(entry -> ruleConfigEntryBOList.addAll(this.buildRuleConfigEntryBO(dataEntity, (DynamicObject)entry)));
        }
        return ruleConfigEntryBOList.stream().collect(Collectors.groupingBy(StaffRuleConfigEntryBO::getRuleConfigId, Collectors.groupingBy(StaffRuleConfigEntryBO::getEntryId)));
    }

    private List<StaffRuleConfigEntryBO> buildRuleConfigEntryBO(DynamicObject ruleConfigDyn, DynamicObject entryDyn) {
        List staffRuleOrgDynList = entryDyn.getDynamicObjectCollection("staffruleorg").stream().map(staffRuleOrgDyn -> staffRuleOrgDyn.getDynamicObject("fbasedataid")).collect(Collectors.toList());
        return staffRuleOrgDynList.stream().map(ruleConfigOrgDyn -> new StaffRuleConfigEntryBO(ruleConfigDyn, entryDyn, ruleConfigOrgDyn)).collect(Collectors.toList());
    }
}

