/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.staff.validate;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.staff.StaffRepository;
import kd.hr.haos.business.domain.repository.staff.UseOrgDetailRepository;
import kd.hr.haos.business.domain.service.impl.staff.SyncPersonStaffServiceImpl;
import kd.hr.haos.business.domain.service.staff.ISyncPersonStaffService;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class OrgStaffEnableValidator
extends HRDataBaseValidator
implements OrgStaffConstants {
    private ISyncPersonStaffService syncPersonStaffService = new SyncPersonStaffServiceImpl();

    public void validate() {
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        List staffIdList = Arrays.stream(extendedDataEntities).map(extendedDataEntity -> extendedDataEntity.getDataEntity().getLong("id")).collect(Collectors.toList());
        DynamicObject[] useOrgDyns = UseOrgDetailRepository.getInstance().queryUseOrgDynArrByIdList(staffIdList);
        Map<Long, List<DynamicObject>> staffIdVsUseOrgDynListMap = Arrays.stream(useOrgDyns).collect(Collectors.groupingBy(dyn -> dyn.getLong("staff.id")));
        DynamicObject[] otherStaffDyns = StaffRepository.getInstance().queryEnableAndNotInIdDyns(staffIdList);
        List otherNameList = Arrays.stream(otherStaffDyns).map(dyn -> dyn.getString("name")).collect(Collectors.toList());
        Map<String, Integer> nameVsSizeMap = this.getNameVsSizeMap(extendedDataEntities);
        Set<String> yearUseOrgBoIdSet = this.getYearUseOrgStrList(otherStaffDyns);
        List<String> curStaffYearUseOrgStrList = this.getCurStaffYearUseOrgStrList(extendedDataEntities, staffIdVsUseOrgDynListMap);
        for (ExtendedDataEntity extendedDataEntity2 : extendedDataEntities) {
            Long orgId;
            DynamicObject dataEntity = extendedDataEntity2.getDataEntity();
            long id = dataEntity.getLong("id");
            String name = dataEntity.getString("name");
            List<DynamicObject> useOrgDynList = staffIdVsUseOrgDynListMap.get(id);
            if (CollectionUtils.isEmpty(useOrgDynList)) {
                this.addErrorMessage(extendedDataEntity2, String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e2d\u65e0\u6709\u6548\u7684\u7ec4\u7ec7\u6570\u636e\uff0c\u8bf7\u6dfb\u52a0\u3002", (String)"OrgStaffEnableValidator_00", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), dataEntity.getString("name")));
            } else {
                Date yearDate = dataEntity.getDate("year");
                int year = HRDateTimeUtils.getYear((Date)yearDate);
                boolean validDBRepeat = true;
                boolean validMemoryRepeat = true;
                for (DynamicObject useOrgDyn : useOrgDynList) {
                    String useOrgBoId = useOrgDyn.getString("useorg.boid");
                    String yearUseOrgBoIdStr = year + useOrgBoId;
                    if (yearUseOrgBoIdSet.contains(yearUseOrgBoIdStr) && validDBRepeat) {
                        this.addErrorMessage(extendedDataEntity2, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e2d\u7684\u4f7f\u7528\u7ec4\u7ec7\u5b58\u5728\u5df2\u542f\u7528\u7684\u4eba\u529b\u7f16\u5236\uff08\u5e74\u4efd\uff1a%2$s\uff09\uff0c\u65e0\u9700\u91cd\u590d\u8bbe\u7f6e\u3002", (String)"OrgStaffEnableValidator_01", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), dataEntity.getString("name"), year));
                        validDBRepeat = false;
                    }
                    if (curStaffYearUseOrgStrList.stream().filter(str -> HRStringUtils.equals((String)str, (String)yearUseOrgBoIdStr)).count() <= 1L || !validMemoryRepeat) continue;
                    this.addErrorMessage(extendedDataEntity2, ResManager.loadKDString((String)"\u6240\u9009\u7f16\u5236\u4fe1\u606f\u4e2d\u7684\u201c\u4f7f\u7528\u7ec4\u7ec7\u201d\u91cd\u590d\uff0c\u4e0d\u80fd\u540c\u65f6\u542f\u7528\u3002", (String)"OrgStaffEnableValidator_02", (String)"hrmp-haos-opplugin", (Object[])new Object[0]));
                    validMemoryRepeat = false;
                }
            }
            if (otherNameList.contains(name)) {
                this.addErrorMessage(extendedDataEntity2, ResManager.loadKDString((String)"\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgStaffEnableValidator_03", (String)"hrmp-haos-opplugin", (Object[])new Object[0]));
            }
            if (nameVsSizeMap.get(name) > 1) {
                this.addErrorMessage(extendedDataEntity2, ResManager.loadKDString((String)"\u4e0d\u80fd\u540c\u65f6\u542f\u7528\u540d\u79f0\u76f8\u540c\u7684\u4eba\u529b\u7f16\u5236\u3002", (String)"OrgStaffEnableValidator_04", (String)"hrmp-haos-opplugin", (Object[])new Object[0]));
            }
            if (this.syncPersonStaffService.isOrgSyncIng(orgId = Long.valueOf(dataEntity.getLong("org.id")))) {
                this.addErrorMessage(extendedDataEntity2, ResManager.loadKDString((String)"\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u4e0b\u5b58\u5728\u672a\u5b8c\u6210\u7684\u540c\u6b65\u4efb\u52a1\u3002", (String)"OrgStaffEnableValidator_05", (String)"hrmp-haos-opplugin", (Object[])new Object[0]));
            }
            if (!this.syncPersonStaffService.isStaffSyncIng(Long.valueOf(id))) continue;
            this.addErrorMessage(extendedDataEntity2, ResManager.loadKDString((String)"\u7f16\u5236\u4fe1\u606f\u5b58\u5728\u672a\u5b8c\u6210\u7684\u5360\u7f16\u6570\u636e\u540c\u6b65\u4efb\u52a1\u3002", (String)"OrgStaffEnableValidator_06", (String)"hrmp-haos-opplugin", (Object[])new Object[0]));
        }
    }

    private Map<String, Integer> getNameVsSizeMap(ExtendedDataEntity[] extendedDataEntities) {
        HashMap nameVsSizeMap = Maps.newHashMapWithExpectedSize((int)extendedDataEntities.length);
        Arrays.stream(extendedDataEntities).forEach(extendedDataEntity -> {
            String name = extendedDataEntity.getDataEntity().getString("name");
            nameVsSizeMap.put(name, nameVsSizeMap.getOrDefault(name, 0) + 1);
        });
        return nameVsSizeMap;
    }

    private List<String> getCurStaffYearUseOrgStrList(ExtendedDataEntity[] extendedDataEntities, Map<Long, List<DynamicObject>> staffIdVsUseOrgDynListMap) {
        ArrayList curStaffYearUseOrgBoIdStrList = Lists.newArrayListWithExpectedSize((int)staffIdVsUseOrgDynListMap.size());
        Arrays.stream(extendedDataEntities).forEach(ex -> {
            DynamicObject dyn = ex.getDataEntity();
            Date year = dyn.getDate("year");
            int yearValue = HRDateTimeUtils.getYear((Date)year);
            long staffId = dyn.getLong("id");
            List useOrgDynList = staffIdVsUseOrgDynListMap.getOrDefault(staffId, new ArrayList());
            useOrgDynList.stream().forEach(useOrgDyn -> {
                String useOrgBoIdStr = useOrgDyn.getString("useorg.boid");
                String yearUseOrgBoIdStr = yearValue + useOrgBoIdStr;
                curStaffYearUseOrgBoIdStrList.add(yearUseOrgBoIdStr);
            });
        });
        return curStaffYearUseOrgBoIdStrList;
    }

    private Set<String> getYearUseOrgStrList(DynamicObject[] staffDyns) {
        DynamicObject[] enableStaffDyns = StaffRepository.getInstance().queryEnableDyns();
        Map<Long, Integer> staffIdVsYearMap = Arrays.stream(enableStaffDyns).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> HRDateTimeUtils.getYear((Date)dyn.getDate("year"))));
        List enableStaffIdList = Arrays.stream(enableStaffDyns).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        DynamicObject[] enableUseOrgDyns = UseOrgDetailRepository.getInstance().queryUseOrgDynArrByIdList(enableStaffIdList);
        HashSet yearUseOrgBoIdStrSet = Sets.newHashSetWithExpectedSize((int)staffDyns.length);
        Arrays.stream(enableUseOrgDyns).forEach(dyn -> {
            long staffId = dyn.getLong("staff.id");
            Integer year = (Integer)staffIdVsYearMap.get(staffId);
            Long useOrgBoId = dyn.getLong("useorg.boid");
            String yearUseOrgBoIdStr = "" + year + useOrgBoId;
            yearUseOrgBoIdStrSet.add(yearUseOrgBoIdStr);
        });
        return yearUseOrgBoIdStrSet;
    }
}

