/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.staff.validate;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.staff.StaffRuleConfigEntryRepository;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.haos.common.constants.staff.OrgStaffRuleConfigConstants;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class OrgStaffRuleConfigDeleteValidator
extends HRDataBaseValidator
implements OrgStaffRuleConfigConstants,
OrgStaffConstants {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        List toDeleteRuleConfigIdList = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity().getLong("id")).collect(Collectors.toList());
        QFilter staffRuleConfigIdFilter = new QFilter("staffruleconfig", "in", toDeleteRuleConfigIdList);
        DynamicObject[] staffRuleConfigEntryDyns = StaffRuleConfigEntryRepository.getInstance().loadDynamicObjectArray(staffRuleConfigIdFilter);
        Map<Long, List<DynamicObject>> ruleConfigIdVsEntryListMap = Arrays.stream(staffRuleConfigEntryDyns).collect(Collectors.groupingBy(dyn -> dyn.getLong("staffruleconfig.id")));
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject dataEntity2 = extendedDataEntity.getDataEntity();
            long id = dataEntity2.getLong("id");
            List<DynamicObject> entryDynList = ruleConfigIdVsEntryListMap.get(id);
            if (CollectionUtils.isEmpty(entryDynList)) continue;
            for (DynamicObject entryDyn : entryDynList) {
                String enable = entryDyn.getString("refstaff.enable");
                if (HRStringUtils.equals((String)enable, (String)"10")) continue;
                StringBuilder orgNameSb = new StringBuilder();
                DynamicObjectCollection ruleOrgDynCol = entryDyn.getDynamicObjectCollection("staffruleorg");
                for (DynamicObject ruleOrgDyn : ruleOrgDynCol) {
                    String orgName = ruleOrgDyn.getString("fbasedataid.name");
                    orgNameSb.append(orgName).append("\u3001");
                }
                orgNameSb.delete(orgNameSb.length() - 1, orgNameSb.length());
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5173\u8054\u7f16\u5236\u4fe1\u606f\u4e0d\u4e3a\u201c\u5f85\u542f\u7528\u201d\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"OrgStaffRuleConfigDeleteValidator_00", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), orgNameSb.toString()));
            }
        }
    }
}

