/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.staff.validate;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.adorg.AdminOrgStructRepository;
import kd.hr.haos.business.domain.repository.staff.StaffRuleConfigRepository;
import kd.hr.haos.business.service.ext.StaffRuleConfigExtend;
import kd.hr.haos.business.service.staff.bean.StaffRuleConfigEntryBO;
import kd.hr.haos.business.service.staff.service.StaffRuleConfigHelper;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.haos.common.constants.staff.OrgStaffRuleConfigConstants;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import org.apache.commons.collections4.trie.PatriciaTrie;

public class OrgStaffRuleConfigValidator
extends HRDataBaseValidator
implements OrgStaffConstants,
OrgStaffRuleConfigConstants {
    private static final Log logger = LogFactory.getLog(OrgStaffRuleConfigValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        DynamicObject[] staffRuleInfoArr = this.queryEnableStaffRuleConfig(dataEntities);
        Set<Long> idSetFromDB = Arrays.stream(staffRuleInfoArr).map(staffRuleInfo -> staffRuleInfo.getLong("id")).collect(Collectors.toSet());
        Map<Long, List<DynamicObject>> orgIdVsRuleConfigDynMap = Arrays.stream(staffRuleInfoArr).collect(Collectors.groupingBy(staffRuleInfo -> staffRuleInfo.getLong("org.id")));
        Map<Long, List<StaffRuleConfigEntryBO>> ruleConfigIdVsBoList = this.getRuleConfigIdVsBoListMap(dataEntities);
        Boolean hasCodeRule = StaffRuleConfigHelper.codeRuleExistFlag((String)"haos_staff", null);
        boolean skipBURepeatConfigValidator = StaffRuleConfigExtend.getInstance().skipBURepeatConfigValidator();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            this.validateNumberRule(dataEntity, hasCodeRule);
            if (!skipBURepeatConfigValidator) {
                this.validateEnableConfig(dataEntity, idSetFromDB, orgIdVsRuleConfigDynMap);
            }
            long ruleConfigId = dataEntity.getDataEntity().getLong("id");
            List<StaffRuleConfigEntryBO> staffRuleConfigEntryBOList = ruleConfigIdVsBoList.get(ruleConfigId);
            this.validateOrgRangeCoincidance(staffRuleConfigEntryBOList);
        }
    }

    private Map<Long, List<StaffRuleConfigEntryBO>> getRuleConfigIdVsBoListMap(ExtendedDataEntity[] dataEntities) {
        Map<Long, String> orgBoIdVsStructLongNumberMap = this.getOrgBoIdVsStructLongNumMap(dataEntities);
        ArrayList staffRuleConfigBOList = Lists.newArrayListWithExpectedSize((int)16);
        Arrays.stream(dataEntities).forEach(dataEntity -> {
            DynamicObject ruleConfigDyn = dataEntity.getDataEntity();
            DynamicObjectCollection ruleConfigDynEntryCol = ruleConfigDyn.getDynamicObjectCollection("entryentity");
            ruleConfigDynEntryCol.stream().filter(entry -> {
                DynamicObject refStaff = entry.getDynamicObject("refstaff");
                if (Objects.nonNull(refStaff)) {
                    return !HRStringUtils.equals((String)entry.getString("refstaff.enable"), (String)"0");
                }
                return true;
            }).forEach(entry -> staffRuleConfigBOList.addAll(this.buildRuleConfigEntryBO((ExtendedDataEntity)dataEntity, (DynamicObject)entry, orgBoIdVsStructLongNumberMap)));
        });
        return staffRuleConfigBOList.stream().collect(Collectors.groupingBy(bo -> bo.getRuleConfigId()));
    }

    private Map<Long, String> getOrgBoIdVsStructLongNumMap(ExtendedDataEntity[] dataEntities) {
        HashSet ruleOrgIdSet = Sets.newHashSetWithExpectedSize((int)16);
        Arrays.stream(dataEntities).forEach(dataEntity -> {
            DynamicObjectCollection ruleConfigDynEntryCol = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
            ruleConfigDynEntryCol.stream().forEach(entry -> {
                Set staffRuleOrgIdSet = entry.getDynamicObjectCollection("staffruleorg").stream().map(staffRuleOrg -> staffRuleOrg.getLong("fbasedataid.id")).collect(Collectors.toSet());
                ruleOrgIdSet.addAll(staffRuleOrgIdSet);
            });
        });
        DynamicObject[] orgStructDyns = AdminOrgStructRepository.getInstance().queryEffStructInfoByOrgId("id, adminorg, structlongnumber", (Collection)ruleOrgIdSet);
        return Arrays.stream(orgStructDyns).collect(Collectors.toMap(dyn -> dyn.getLong("adminorg.id"), dyn -> dyn.getString("structlongnumber")));
    }

    private DynamicObject[] queryEnableStaffRuleConfig(ExtendedDataEntity[] dataEntities) {
        Set orgIdSet = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity().getLong("org.id")).collect(Collectors.toSet());
        QFilter filter = new QFilter("org", "in", orgIdSet);
        filter.and("enable", "=", (Object)"1");
        return StaffRuleConfigRepository.getInstance().queryOriginalArray("id, org.name, org.id, year", new QFilter[]{filter});
    }

    private void validateNumberRule(ExtendedDataEntity dataEntity, Boolean hasCodeRule) {
        DynamicObjectCollection ruleConfigEntryCol = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
        for (DynamicObject ruleConfigEntry : ruleConfigEntryCol) {
            if (!Objects.isNull(ruleConfigEntry.getDynamicObject("refstaff")) || hasCodeRule.booleanValue()) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u542f\u7528\u7f16\u5236\u4fe1\u606f\u7684\u7f16\u7801\u89c4\u5219\u3002", (String)"OrgStaffRuleConfigValidator_03", (String)"hrmp-haos-opplugin", (Object[])new Object[0]));
            return;
        }
    }

    private void validateEnableConfig(ExtendedDataEntity dataEntity, Set<Long> idSetFromDB, Map<Long, List<DynamicObject>> orgIdVsRuleConfigDynMap) {
        boolean changeSaveValid;
        if (CollectionUtils.isEmpty(orgIdVsRuleConfigDynMap)) {
            return;
        }
        DynamicObject ruleConfigDyn = dataEntity.getDataEntity();
        long ruleConfigId = ruleConfigDyn.getLong("id");
        long orgId = ruleConfigDyn.getLong("org.id");
        int year = HRDateTimeUtils.getYear((Date)ruleConfigDyn.getDate("year"));
        Map<Integer, List<DynamicObject>> yearVsRuleConfigDynListMap = orgIdVsRuleConfigDynMap.get(orgId).stream().collect(Collectors.groupingBy(dyn -> HRDateTimeUtils.getYear((Date)dyn.getDate("year"))));
        List<DynamicObject> ruleVsRuleConfigDynList = yearVsRuleConfigDynListMap.get(year);
        boolean newSaveValid = !idSetFromDB.contains(ruleConfigId) && !CollectionUtils.isEmpty(ruleVsRuleConfigDynList);
        boolean bl = changeSaveValid = idSetFromDB.contains(ruleConfigId) && !CollectionUtils.isEmpty(ruleVsRuleConfigDynList) && ruleVsRuleConfigDynList.size() > 1;
        if (newSaveValid || changeSaveValid) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5728\u201c%2$s\u201d\u5185\u5df2\u914d\u7f6e\u7f16\u5236\u89c4\u5219\uff0c\u4e0d\u53ef\u91cd\u590d\u914d\u7f6e\u3002", (String)"OrgStaffRuleConfigValidator_00", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), ruleConfigDyn.getString("org.name"), year));
        }
    }

    private void validateOrgRangeCoincidance(List<StaffRuleConfigEntryBO> staffRuleConfigBOList) {
        if (CollectionUtils.isEmpty(staffRuleConfigBOList)) {
            return;
        }
        List newRuleConfigEntryBoList = staffRuleConfigBOList.stream().filter(bo -> bo.getStaffId() == 0L).collect(Collectors.toList());
        List<StaffRuleConfigEntryBO> newAndIncludeSubBoList = newRuleConfigEntryBoList.stream().filter(StaffRuleConfigEntryBO::getIncludeSub).collect(Collectors.toList());
        PatriciaTrie newDataPatriciaTrie = newRuleConfigEntryBoList.stream().collect(Collectors.toMap(StaffRuleConfigEntryBO::getStructLongNumber, dyn -> dyn, (value, value2) -> value, PatriciaTrie::new));
        List existRuleConfigBoList = staffRuleConfigBOList.stream().filter(bo -> bo.getStaffId() != 0L).collect(Collectors.toList());
        List<StaffRuleConfigEntryBO> existAndIncludeSubBoList = existRuleConfigBoList.stream().filter(StaffRuleConfigEntryBO::getIncludeSub).collect(Collectors.toList());
        PatriciaTrie existDataPatriciaTrie = existRuleConfigBoList.stream().collect(Collectors.toMap(StaffRuleConfigEntryBO::getStructLongNumber, dyn -> dyn, (value, value2) -> value, PatriciaTrie::new));
        this.validateNewIncludeSubData(newAndIncludeSubBoList, (PatriciaTrie<StaffRuleConfigEntryBO>)newDataPatriciaTrie, (PatriciaTrie<StaffRuleConfigEntryBO>)existDataPatriciaTrie);
        if (existAndIncludeSubBoList.size() > 0) {
            this.validateExistIncludeSubData(existAndIncludeSubBoList, (PatriciaTrie<StaffRuleConfigEntryBO>)newDataPatriciaTrie, (PatriciaTrie<StaffRuleConfigEntryBO>)existDataPatriciaTrie);
        }
    }

    private void validateNewIncludeSubData(List<StaffRuleConfigEntryBO> includeSubBoList, PatriciaTrie<StaffRuleConfigEntryBO> newDataPatriciaTrie, PatriciaTrie<StaffRuleConfigEntryBO> existDataPatriciaTrie) {
        for (StaffRuleConfigEntryBO includeSubBo : includeSubBoList) {
            String structNumber = includeSubBo.getStructLongNumber();
            SortedMap subSortedMap = newDataPatriciaTrie.prefixMap((Object)structNumber);
            if (subSortedMap != null && subSortedMap.size() > 1) {
                subSortedMap.forEach((subStructNumber, subRuleConfigEntryBo) -> {
                    if (!includeSubBo.getAdminOrgId().equals(subRuleConfigEntryBo.getAdminOrgId())) {
                        this.addErrorMessage(subRuleConfigEntryBo.getRuleConfigDataEntity(), String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u8303\u56f4\u91cd\u5408\uff0c\u201c%1$s\u201d\u4e3a\u201c%2$s\u201d\u7684\u4e0b\u7ea7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgStaffRuleConfigValidator_02", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), subRuleConfigEntryBo.getAdminOrgName(), includeSubBo.getAdminOrgName()));
                    }
                });
            }
            if ((subSortedMap = existDataPatriciaTrie.prefixMap((Object)structNumber)) == null) continue;
            subSortedMap.forEach((subStructNumber, subRuleConfigEntryBo) -> this.addErrorMessage(subRuleConfigEntryBo.getRuleConfigDataEntity(), String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u8303\u56f4\u91cd\u5408\uff0c\u201c%1$s\u201d\u4e3a\u201c%2$s\u201d\u7684\u4e0b\u7ea7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgStaffRuleConfigValidator_02", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), subRuleConfigEntryBo.getAdminOrgName(), includeSubBo.getAdminOrgName())));
        }
    }

    private void validateExistIncludeSubData(List<StaffRuleConfigEntryBO> includeSubBoList, PatriciaTrie<StaffRuleConfigEntryBO> newDataPatriciaTrie, PatriciaTrie<StaffRuleConfigEntryBO> existDataPatriciaTrie) {
        for (StaffRuleConfigEntryBO includeSubBo : includeSubBoList) {
            String structNumber = includeSubBo.getStructLongNumber();
            SortedMap subSortedMap = newDataPatriciaTrie.prefixMap((Object)structNumber);
            if (subSortedMap == null) continue;
            subSortedMap.forEach((subStructNumber, subRuleConfigEntryBo) -> {
                SortedMap subSortedMapInExist = existDataPatriciaTrie.prefixMap((Object)structNumber);
                String parentStructNumber = "";
                for (String subStructNumberInExist : subSortedMapInExist.keySet()) {
                    if (!subStructNumber.contains(subStructNumberInExist) || subStructNumberInExist.length() <= parentStructNumber.length()) continue;
                    parentStructNumber = subStructNumberInExist;
                }
                StaffRuleConfigEntryBO lastEntry = (StaffRuleConfigEntryBO)subSortedMapInExist.get(parentStructNumber);
                if (lastEntry.getIncludeSub().booleanValue()) {
                    this.addErrorMessage(subRuleConfigEntryBo.getRuleConfigDataEntity(), String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u8303\u56f4\u91cd\u5408\uff0c\u201c%1$s\u201d\u4e3a\u201c%2$s\u201d\u7684\u4e0b\u7ea7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgStaffRuleConfigValidator_02", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), subRuleConfigEntryBo.getAdminOrgName(), lastEntry.getAdminOrgName()));
                }
            });
        }
    }

    private List<StaffRuleConfigEntryBO> buildRuleConfigEntryBO(ExtendedDataEntity ruleConfigDataEntity, DynamicObject entryDyn, Map<Long, String> orgBoIdVsStructLongNumberMap) {
        boolean includeSub = entryDyn.getBoolean("includesub");
        Long refStaffId = Objects.isNull(entryDyn.getDynamicObject("refstaff")) ? 0L : entryDyn.getLong("refstaff.id");
        List staffRuleOrgDynList = entryDyn.getDynamicObjectCollection("staffruleorg").stream().map(staffRuleOrgDyn -> staffRuleOrgDyn.getDynamicObject("fbasedataid")).collect(Collectors.toList());
        return staffRuleOrgDynList.stream().map(dyn -> new StaffRuleConfigEntryBO(ruleConfigDataEntity, dyn, includeSub, (String)orgBoIdVsStructLongNumberMap.get(dyn.getLong("id")), refStaffId)).collect(Collectors.toList());
    }
}

