/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.staff.validate;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.haos.business.domain.repository.staff.StaffCaseRepository;
import kd.hr.haos.business.util.IdAndDateRangeBo;
import kd.hr.haos.business.util.StaffCaseDateRangeHelper;
import kd.hr.haos.common.constants.staff.StaffCaseConstants;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class StaffCaseSaveValidator
extends HRDataBaseValidator
implements StaffCaseConstants {
    public void validate() {
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        List personIdList = Arrays.stream(extendedDataEntities).map(extendedDataEntity -> extendedDataEntity.getDataEntity().getLong("person.id")).collect(Collectors.toList());
        DynamicObject[] staffCaseDyns = StaffCaseRepository.getInstance().queryEnableAndAuditDyns(personIdList);
        Map personIdVsStaffCaseListMap = Arrays.stream(staffCaseDyns).collect(Collectors.groupingBy(dyn -> dyn.getLong("person.id"), Collectors.mapping(dyn -> StaffCaseDateRangeHelper.buildBo((DynamicObject)dyn), Collectors.toList())));
        Map personIdVsBoList = Arrays.stream(extendedDataEntities).collect(Collectors.groupingBy(extendedDataEntity -> extendedDataEntity.getDataEntity().getLong("person.id"), Collectors.mapping(extendedDataEntity -> StaffCaseDateRangeHelper.buildBo((DynamicObject)extendedDataEntity.getDataEntity()), Collectors.toList())));
        for (ExtendedDataEntity extendedDataEntity2 : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity2.getDataEntity();
            Date bsed = dataEntity.getDate("bsed");
            Date blsed = dataEntity.getDate("bsled");
            if (blsed != null && bsed.after(blsed)) {
                this.addErrorMessage(extendedDataEntity2, String.format(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u5931\u6548\u65e5\u671f\u3002", (String)"StaffCaseSaveValidator_01", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), new Object[0]));
            }
            long personId = dataEntity.getLong("person.id");
            IdAndDateRangeBo needToValidateBo = StaffCaseDateRangeHelper.buildBo((DynamicObject)dataEntity);
            boolean isDateIntervalForMemory = StaffCaseDateRangeHelper.isDateInterval((IdAndDateRangeBo)needToValidateBo, personIdVsBoList.get(personId));
            if (isDateIntervalForMemory) {
                this.addErrorMessage(extendedDataEntity2, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u751f\u6548\u65e5\u671f\u8303\u56f4\u5185\u5b58\u5728\u5176\u4ed6\u7f16\u5236\u4e2a\u4f8b\uff0c\u4e0d\u53ef\u91cd\u590d\u8bbe\u7f6e\u3002", (String)"StaffCaseSaveValidator_00", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), new Object[0]));
                continue;
            }
            boolean isDateIntervalForDB = StaffCaseDateRangeHelper.isDateInterval((IdAndDateRangeBo)needToValidateBo, personIdVsStaffCaseListMap.get(personId));
            if (!isDateIntervalForDB) continue;
            this.addErrorMessage(extendedDataEntity2, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u751f\u6548\u65e5\u671f\u8303\u56f4\u5185\u5b58\u5728\u5176\u4ed6\u7f16\u5236\u4e2a\u4f8b\uff0c\u4e0d\u53ef\u91cd\u590d\u8bbe\u7f6e\u3002", (String)"StaffCaseSaveValidator_00", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), new Object[0]));
        }
    }
}

