/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.staff.validate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class StaffProjectEnableValidator
extends HRDataBaseValidator
implements OrgStaffConstants {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashMap<String, ExtendedDataEntity> nameMap = new HashMap<String, ExtendedDataEntity>(dataEntities.length);
        HashSet<Object> sameNameEntitySet = new HashSet<Object>(dataEntities.length);
        ArrayList<Long> idList = new ArrayList<Long>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String name = dataEntity.getDataEntity().getString("name");
            if (nameMap.containsKey(name)) {
                sameNameEntitySet.add(dataEntity);
                sameNameEntitySet.add(nameMap.get(name));
                idList.add(dataEntity.getDataEntity().getLong("id"));
                idList.add(((ExtendedDataEntity)nameMap.get(name)).getDataEntity().getLong("id"));
                continue;
            }
            nameMap.put(dataEntity.getDataEntity().getString("name"), dataEntity);
        }
        for (ExtendedDataEntity extendedDataEntity : sameNameEntitySet) {
            if ("1".equals(extendedDataEntity.getDataEntity().getString("enable"))) continue;
            String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff1a\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u542f\u7528\u3002", (String)"StaffProjectEnableValidator_1", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), extendedDataEntity.getDataEntity().getString("name"));
            this.addErrorMessage(extendedDataEntity, message);
        }
        QFilter filter = new QFilter("name", "in", nameMap.keySet());
        filter.and("enable", "=", (Object)"1");
        HRBaseServiceHelper hRBaseServiceHelper = new HRBaseServiceHelper("haos_staffproject");
        DynamicObject[] dbObjects = hRBaseServiceHelper.query("id,name", new QFilter[]{filter});
        Map<String, DynamicObject> dbObjectMap = Arrays.stream(dbObjects).collect(Collectors.toMap(dyn -> dyn.getString("name"), dyn -> dyn));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String name = dataEntity.getDataEntity().getString("name");
            long id = dataEntity.getDataEntity().getLong("id");
            if (!dbObjectMap.containsKey(name) || dbObjectMap.get(name).getLong("id") == id || idList.contains(id)) continue;
            String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff1a\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u542f\u7528\u3002", (String)"StaffProjectEnableValidator_1", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), name);
            this.addErrorMessage(dataEntity, message);
        }
    }
}

