/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.structproject;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.Assert;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.structproject.StructProjectRepository;
import kd.hr.haos.business.service.otherstruct.OtherStructService;
import kd.hr.haos.business.service.otherstruct.model.OtherStructEntity;
import kd.hr.haos.business.service.otherstruct.model.OtherStructVO;
import kd.hr.haos.opplugin.web.structproject.OtherStructProjectOrgImportHelper;
import kd.hr.haos.opplugin.web.structproject.validator.OtherStructProjectOrgImportStartDateValidator;
import kd.hr.haos.opplugin.web.structproject.validator.OtherStructProjectOrgImportValidator;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;

public class OtherStructProjectOrgImportSaveOp
extends HRDataBaseOp {
    private static final Log LOGGER = LogFactory.getLog(OtherStructProjectOrgImportSaveOp.class);
    private DynamicObject structProjectDy;
    private Boolean enable;
    private List<Long> rowIds = new ArrayList<Long>();

    public OtherStructProjectOrgImportSaveOp() {
        IHRAppCache appCache = HRAppCache.get((String)"haos");
        String structProjectCache = (String)appCache.get("structproject" + RequestContext.get().getRequestId(), String.class);
        if (HRStringUtils.isEmpty((String)structProjectCache)) {
            return;
        }
        long structProjectId = Long.parseLong(structProjectCache);
        DynamicObject[] structProjectDys = StructProjectRepository.getInstance().loadByIds(Collections.singleton(structProjectId));
        Assert.isTrue((structProjectDys.length == 1 ? 1 : 0) != 0, (String)("structProjectDys find count" + structProjectDys.length));
        this.structProjectDy = structProjectDys[0];
        this.enable = !HRStringUtils.equals((String)this.structProjectDy.getString("enable"), (String)"10");
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("isvirtualorg");
        fieldKeys.add("parentorg");
        fieldKeys.add("orgid");
        fieldKeys.add("enable");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new OtherStructProjectOrgImportStartDateValidator(this.structProjectDy));
        e.addValidator((AbstractValidator)new OtherStructProjectOrgImportValidator(this.structProjectDy));
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        long structProjectId = this.structProjectDy.getLong("id");
        DynamicObject[] dataEntities = e.getDataEntities();
        List orgIds = Stream.of(dataEntities).map(dataEntity -> dataEntity.getLong("id")).collect(Collectors.toList());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgstructure");
        DynamicObject[] dbStructDys = serviceHelper.query("orgteam.id,parentorgteam.id,bsed,enable", new QFilter[]{new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("structproject", "=", (Object)structProjectId), new QFilter("orgteam", "in", orgIds)});
        HashMap dbStructDyMap = Maps.newHashMapWithExpectedSize((int)dbStructDys.length);
        Stream.of(dbStructDys).forEach(dbStructDy -> dbStructDyMap.put(dbStructDy.getLong("orgteam.id"), dbStructDy));
        Date enablingDate = this.structProjectDy.getDate("effdt");
        ArrayList otherStructVOs = Lists.newArrayListWithCapacity((int)dataEntities.length);
        HashSet disableOrgIds = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        Date effectDate = this.getStartDate(enablingDate, dataEntities);
        for (DynamicObject sourceDataEntity : dataEntities) {
            this.setRootEstablishmentDate(sourceDataEntity, enablingDate);
            long orgId2 = sourceDataEntity.getLong("id");
            this.rowIds.add(orgId2);
            DynamicObject dbStructDy2 = (DynamicObject)dbStructDyMap.get(orgId2);
            this.createOtherStructVO(sourceDataEntity, dbStructDy2).ifPresent(vo -> {
                if (Objects.equals(vo.getChangeTypeId(), 1040L)) {
                    disableOrgIds.add(orgId2);
                } else {
                    otherStructVOs.add(vo);
                }
                vo.setStartDate(effectDate);
            });
        }
        List disableVOs = OtherStructProjectOrgImportHelper.getAllSubOrg(disableOrgIds, structProjectId, effectDate).stream().map(orgId -> new OtherStructVO(orgId, Long.valueOf(1040L), Long.valueOf(0L))).collect(Collectors.toList());
        otherStructVOs.addAll(disableVOs);
        LOGGER.info("param structProjectId|{}, effectDate|{}, enable|{}, otherStructVOs|{}", new Object[]{structProjectId, effectDate, this.enable, JSON.toJSONString((Object)otherStructVOs)});
        List<DynamicObject> dyList = this.convertVirtualOrg(dataEntities, otherStructVOs);
        LOGGER.info("param dyList size|{} ,dyList values|{} ", (Object)dyList.size(), dyList);
        if (CollectionUtils.isEmpty((Collection)otherStructVOs) && CollectionUtils.isEmpty(dyList)) {
            return;
        }
        OtherStructEntity otherStructEntity = new OtherStructEntity((List)otherStructVOs);
        otherStructEntity.setEffectDate(effectDate);
        otherStructEntity.setStructProjectId(Long.valueOf(structProjectId));
        if (this.enable.booleanValue()) {
            otherStructEntity.setEnable("1");
            otherStructEntity.setDeleteFlag(Boolean.FALSE);
        } else {
            otherStructEntity.setEnable("10");
            otherStructEntity.setDeleteFlag(Boolean.TRUE);
        }
        otherStructEntity.setDeleteAll(Boolean.FALSE);
        otherStructEntity.setDyList(dyList);
        OtherStructService otherStructService = new OtherStructService(otherStructEntity);
        otherStructService.saveOtherStruct();
    }

    private void setRootEstablishmentDate(DynamicObject sourceDataEntity, Date rootEstablishmentDate) {
        if (HRObjectUtils.isEmpty((Object)sourceDataEntity.getDate("bsed"))) {
            if (this.enable.booleanValue()) {
                sourceDataEntity.set("bsed", (Object)HRDateTimeUtils.truncateDate((Date)new Date()));
            } else {
                sourceDataEntity.set("bsed", (Object)rootEstablishmentDate);
            }
        }
    }

    private Date getStartDate(Date rootEstablishmentDate, DynamicObject[] dataEntities) {
        Date[] bseds = (Date[])Stream.of(dataEntities).map(dataEntity -> dataEntity.getDate("bsed")).filter(Objects::nonNull).distinct().toArray(Date[]::new);
        if (bseds.length == 1) {
            return bseds[0];
        }
        if (this.enable.booleanValue()) {
            return HRDateTimeUtils.truncateDate((Date)new Date());
        }
        return rootEstablishmentDate;
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        Optional.ofNullable(e.getOperationResult().getSuccessPkIds()).ifPresent(pkIds -> pkIds.addAll(this.rowIds));
    }

    private Optional<OtherStructVO> createOtherStructVO(DynamicObject sourceDataEntity, DynamicObject dbStructDy) {
        String dbEnable;
        DynamicObject sourceDataParentOrgDy = sourceDataEntity.getDynamicObject("parentorg");
        long sourceDataOrgId = sourceDataEntity.getLong("id");
        if (HRObjectUtils.isEmpty((Object)dbStructDy)) {
            if (HRObjectUtils.isEmpty((Object)sourceDataParentOrgDy)) {
                return Optional.empty();
            }
            long sourceDataParentId = sourceDataParentOrgDy.getLong("id");
            return Optional.of(new OtherStructVO(Long.valueOf(sourceDataOrgId), Long.valueOf(1010L), Long.valueOf(sourceDataParentId)));
        }
        if (HRObjectUtils.isEmpty((Object)sourceDataParentOrgDy)) {
            long rootOrgId = this.structProjectDy.getLong("rootorg.id");
            if (Objects.equals(sourceDataOrgId, rootOrgId)) {
                return Optional.empty();
            }
            return Optional.of(new OtherStructVO(Long.valueOf(sourceDataOrgId), Long.valueOf(1040L), Long.valueOf(0L)));
        }
        long sourceDataParentId = sourceDataParentOrgDy.getLong("id");
        long dbStructParentId = dbStructDy.getLong("parentorgteam.id");
        if (!Objects.equals(sourceDataParentId, dbStructParentId)) {
            return Optional.of(new OtherStructVO(Long.valueOf(sourceDataOrgId), Long.valueOf(1020L), Long.valueOf(sourceDataParentId)));
        }
        String sourceEnable = sourceDataEntity.getString("enable");
        if (!HRStringUtils.equals((String)sourceEnable, (String)(dbEnable = dbStructDy.getString("enable"))) && this.enable.booleanValue()) {
            return Optional.of(new OtherStructVO(Long.valueOf(sourceDataOrgId), Long.valueOf(1030L), Long.valueOf(sourceDataParentId)));
        }
        return Optional.empty();
    }

    private List<DynamicObject> convertVirtualOrg(DynamicObject[] sourceDataEntities, List<OtherStructVO> otherStructVOs) {
        Set defaultOrgIds = otherStructVOs.stream().filter(vo -> Lists.newArrayList((Object[])new Long[]{1010L, 1020L}).contains(vo.getChangeTypeId())).map(OtherStructVO::getOrgId).collect(Collectors.toSet());
        MainEntityType dynamicObjectType = EntityMetadataCache.getDataEntityType((String)"haos_virtualorg");
        List virtualOrgs = Stream.of(sourceDataEntities).filter(dataEntity -> dataEntity.getBoolean("isvirtualorg")).collect(Collectors.toList());
        Set<Long> orgIds = virtualOrgs.stream().map(virtualOrg -> virtualOrg.getLong("id")).collect(Collectors.toSet());
        Set<Long> parentIds = virtualOrgs.stream().map(virtualOrg -> virtualOrg.getDynamicObject("parentorg")).filter(Objects::nonNull).map(parent -> parent.getLong("id")).collect(Collectors.toSet());
        Map<Long, DynamicObject> originalOrgDyMap = this.getOriginalOrgMap(orgIds);
        Map<Long, DynamicObject> parentOrgDyMap = this.getOriginalOrgMap(parentIds);
        ArrayList dyList = Lists.newArrayListWithExpectedSize((int)virtualOrgs.size());
        for (DynamicObject sourceDataEntity : virtualOrgs) {
            DynamicObject virtualOrgDy = new DynamicObject((DynamicObjectType)dynamicObjectType);
            virtualOrgDy.set("orgid", sourceDataEntity.get("id"));
            virtualOrgDy.set("number", sourceDataEntity.get("number"));
            virtualOrgDy.set("name", sourceDataEntity.get("name"));
            virtualOrgDy.set("description", sourceDataEntity.get("description"));
            long orgId = sourceDataEntity.getLong("id");
            DynamicObject originalOrgDy = originalOrgDyMap.get(orgId);
            DynamicObject sourceDataOrg = sourceDataEntity.getDynamicObject("org");
            if (Objects.isNull(sourceDataOrg)) {
                if (defaultOrgIds.contains(orgId)) {
                    Optional.ofNullable(sourceDataEntity.getDynamicObject("parentorg")).map(dy -> dy.getLong("id")).ifPresent(parentId -> virtualOrgDy.set("org", parentOrgDyMap.get(parentId)));
                } else {
                    virtualOrgDy.set("org", (Object)originalOrgDy);
                }
            } else {
                virtualOrgDy.set("org", (Object)sourceDataOrg);
            }
            dyList.add(virtualOrgDy);
        }
        return dyList;
    }

    private Map<Long, DynamicObject> getOriginalOrgMap(Set<Long> orgIds) {
        HRBaseServiceHelper orgDetailHelper = new HRBaseServiceHelper("haos_structorgdetail");
        DynamicObject[] originalOrgDy = orgDetailHelper.query("org", new QFilter[]{new QFilter("id", "in", orgIds)});
        HashMap originalOrgMap = Maps.newHashMapWithExpectedSize((int)originalOrgDy.length);
        for (DynamicObject originalOrg : originalOrgDy) {
            originalOrgMap.put(originalOrg.getLong("id"), originalOrg.getDynamicObject("org"));
        }
        return originalOrgMap;
    }
}

